import type { SVGProps } from 'react'

const SvgConfettiColorfulIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={20}
    height={20}
    fill="none"
    viewBox="0 0 20 20"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <g clipPath="url(#prefix__clip0_4508_1033)">
      <path
        stroke="currentColor"
        strokeWidth={1.2}
        d="M7.646 5.782c-.353.354-4.242 11.314-4.242 11.314s10.96-3.889 11.313-4.242c.354-.354.354-2.475-2.12-4.95C10.12 5.429 8 5.429 7.646 5.782Z"
      />
      <path
        stroke="currentColor"
        strokeWidth={1.2}
        d="M7.646 5.782s-.353 2.475 2.122 4.95c2.475 2.475 4.95 2.122 4.95 2.122"
      />
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M10.546 14.197 6.303 9.954l-.848.849 4.242 4.242.849-.848Zm-2.475 1.06L5.242 12.43l-.848.849 2.828 2.828.849-.848Z"
        clipRule="evenodd"
      />
      <path fill="#EC266C" d="M17.5 9.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" />
      <path fill="#FF7D46" d="M10.5 1.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z" />
      <path fill="#F6B03C" d="M18.5 2.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" />
      <path fill="#1992D7" d="M15 5.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z" />
      <path fill="#7140FD" d="M14.5 2a1 1 0 1 1-2 0 1 1 0 0 1 2 0Z" />
      <path fill="#F66F8F" d="M20 6.5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z" />
    </g>
    <defs>
      <clipPath id="prefix__clip0_4508_1033">
        <path fill="#fff" d="M0 0h20v20H0z" />
      </clipPath>
    </defs>
  </svg>
)
export default SvgConfettiColorfulIcon
