import type { SVGProps } from 'react'

const SvgAfghanistanIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={20}
    height={20}
    fill="none"
    viewBox="0 0 20 20"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <path
      fill="#141414"
      d="M20 15a2.222 2.222 0 0 1-2.222 2.222H2.222A2.222 2.222 0 0 1 0 15V5c0-1.228.995-2.223 2.222-2.223h15.556C19.005 2.777 20 3.772 20 5v10Z"
    />
    <path
      fill="#007A36"
      d="M17.778 2.777C19.005 2.777 20 3.772 20 5v10a2.222 2.222 0 0 1-2.222 2.222h-4.445V2.777h4.445Z"
    />
    <path fill="#D32011" d="M6.667 2.777h6.666v14.445H6.667V2.777Z" />
    <path
      fill="#fff"
      d="M12.249 13.213c-.018.044-.079.084-.126.065-.048-.02-.065-.09-.047-.134a.59.59 0 0 1 .168-.172c.015.006.023.196.005.24Zm.034.042c-.047.007-.1.057-.091.108.008.05.072.083.12.075a.596.596 0 0 0 .205-.126.598.598 0 0 0-.234-.057Zm.195-.223c-.016.04-.072.078-.116.06-.044-.017-.06-.083-.044-.124a.547.547 0 0 1 .156-.16.55.55 0 0 1 .004.224Zm.031.039c-.043.007-.092.053-.084.1.008.048.068.077.112.07a.542.542 0 0 0 .19-.118.544.544 0 0 0-.218-.052Zm-1.017.299c-.01.056-.072.117-.133.106-.06-.011-.097-.09-.087-.147.01-.056.14-.245.157-.242.019.004.073.226.063.283Zm.05.04c-.054.02-.104.093-.082.15.022.058.105.08.16.06.054-.02.217-.18.21-.198-.006-.017-.235-.031-.288-.011Zm.147-.268c-.008.048-.06.098-.11.09-.051-.01-.082-.076-.073-.123a.586.586 0 0 1 .131-.202c.015.003.06.188.052.235Zm.041.035c-.045.016-.086.076-.068.124.018.048.088.067.133.05.045-.017.18-.15.175-.165a.596.596 0 0 0-.24-.01Zm.148-.257c-.008.044-.056.09-.103.082-.047-.008-.075-.07-.067-.113a.546.546 0 0 1 .121-.187.554.554 0 0 1 .049.218Zm.038.032c-.042.015-.08.07-.063.115s.082.062.124.046a.552.552 0 0 0 .162-.152.544.544 0 0 0-.223-.01Zm.125-.224c-.007.04-.05.083-.093.075-.042-.008-.068-.063-.06-.102a.486.486 0 0 1 .11-.17c.012.002.05.158.043.197Zm.034.03c-.037.013-.072.063-.056.104.015.04.074.055.111.041a.49.49 0 0 0 .148-.138.497.497 0 0 0-.203-.008Zm-.053.974c-.043.04-.129.05-.17.005-.043-.045-.025-.13.017-.17.043-.038.26-.111.272-.098.012.013-.077.224-.12.263Zm.014.063c-.056-.016-.138.012-.155.07-.018.06.037.128.092.144.055.017.282-.013.287-.031.005-.017-.168-.166-.224-.183Zm.28-.126c-.036.033-.107.043-.142.005-.035-.038-.02-.108.015-.141a.585.585 0 0 1 .226-.082.602.602 0 0 1-.1.218Zm.012.053c-.046-.014-.115.01-.13.059-.014.049.03.106.077.119a.588.588 0 0 0 .239-.026c.004-.015-.14-.139-.186-.152Zm.272-.117c-.033.03-.099.039-.132.004-.032-.035-.018-.1.015-.13.032-.03.2-.087.21-.077a.54.54 0 0 1-.093.203Zm.012.048c-.043-.012-.107.01-.12.055-.014.045.028.098.07.11a.538.538 0 0 0 .222-.024.548.548 0 0 0-.172-.14Zm.233-.103c-.029.027-.089.036-.118.004-.03-.032-.017-.091.012-.118a.493.493 0 0 1 .19-.07.488.488 0 0 1-.084.184Zm.011.044c-.038-.012-.096.008-.108.05-.012.04.025.088.064.1a.48.48 0 0 0 .2-.022.505.505 0 0 0-.156-.128Zm.19-1.54c.008.058-.033.134-.095.142-.061.007-.12-.058-.127-.115-.007-.057.061-.276.08-.278.018-.002.135.194.143.252Zm.06.025c-.046.035-.071.118-.033.167.037.049.124.045.17.01.046-.035.154-.237.143-.252-.012-.014-.234.04-.28.075Zm.061-.3c.006.048-.028.111-.08.118-.05.006-.099-.047-.105-.095a.599.599 0 0 1 .066-.232.579.579 0 0 1 .12.209Zm.05.02c-.038.03-.06.099-.028.14.031.04.104.037.142.008.037-.03.127-.197.118-.21a.609.609 0 0 0-.232.063Zm.065-.288c.005.044-.027.103-.074.109-.048.005-.092-.044-.098-.089a.547.547 0 0 1 .06-.214.54.54 0 0 1 .112.194Zm.046.019c-.035.027-.055.09-.026.128.03.038.096.035.131.008a.546.546 0 0 0 .11-.194.543.543 0 0 0-.215.058Zm.053-.25c.005.04-.024.093-.067.098-.043.005-.084-.04-.088-.08a.487.487 0 0 1 .054-.194.477.477 0 0 1 .1.176Zm.041.017c-.032.024-.05.082-.023.116.026.034.087.032.119.007a.497.497 0 0 0 .1-.175.492.492 0 0 0-.196.052Zm.238.947c-.029.05-.108.087-.161.056-.054-.032-.061-.118-.033-.168.029-.05.215-.184.23-.175.016.01-.007.237-.036.287Zm.032.056c-.058 0-.128.051-.127.113.001.062.073.11.13.11.058 0 .265-.097.265-.116 0-.018-.21-.108-.268-.107Zm.23-.203c-.024.041-.09.071-.134.046-.045-.026-.051-.098-.027-.14.023-.041.178-.153.191-.145a.582.582 0 0 1-.03.239Zm.027.046c-.048 0-.107.043-.106.094 0 .051.06.092.108.092s.22-.08.22-.096a.592.592 0 0 0-.222-.09Zm.225-.192c-.022.038-.083.066-.124.042-.041-.024-.047-.09-.025-.129a.54.54 0 0 1 .178-.135.537.537 0 0 1-.029.222Zm.026.042c-.044 0-.099.04-.098.088 0 .048.056.086.1.085a.55.55 0 0 0 .205-.089.55.55 0 0 0-.207-.084Zm.193-.167c-.02.035-.075.06-.113.038-.037-.021-.043-.082-.023-.116a.502.502 0 0 1 .16-.122.486.486 0 0 1-.024.2Zm.022.038c-.04.001-.089.037-.088.08 0 .043.05.077.09.077.041-.001.186-.068.186-.081a.49.49 0 0 0-.188-.075Zm-.583-.308c-.002.058-.054.128-.115.126-.062-.001-.11-.074-.11-.13.002-.058.1-.265.119-.265.018 0 .107.211.106.27Zm.055.034c-.05.028-.088.106-.057.16.03.054.117.063.167.034.05-.028.186-.212.177-.228-.008-.016-.237.005-.287.034Zm.104-.289c-.001.048-.044.106-.095.105-.052-.001-.092-.061-.091-.11.001-.047.083-.22.098-.219.015 0 .09.176.088.224Zm.046.028c-.042.023-.073.089-.048.134.025.045.097.052.139.028.041-.023.155-.176.147-.19-.007-.014-.196.004-.238.028Zm.106-.277c-.001.044-.041.098-.089.097-.047-.001-.085-.057-.084-.101a.547.547 0 0 1 .092-.204c.014 0 .082.163.08.208Zm.042.025c-.038.022-.067.082-.043.124.024.042.09.048.129.026a.545.545 0 0 0 .136-.176.553.553 0 0 0-.222.026Zm-.469-.949c.023.054.004.139-.053.163-.056.024-.13-.022-.153-.075-.023-.054-.018-.283-.001-.29.017-.007.185.15.207.202Zm.064.008c-.034.047-.036.134.014.17.05.037.132.009.166-.038.034-.046.082-.27.068-.28-.015-.012-.214.101-.248.148Zm-.024-.305c.019.043.003.115-.044.135-.047.02-.109-.019-.127-.063a.6.6 0 0 1-.001-.24c.014-.006.154.124.172.168Zm.053.006c-.028.039-.03.11.012.141.042.03.11.008.138-.03a.59.59 0 0 0 .056-.235.595.595 0 0 0-.206.124Zm-.017-.296c.017.041.004.107-.04.125-.044.018-.102-.017-.119-.058a.54.54 0 0 1 0-.222.545.545 0 0 1 .16.155Zm.05.006c-.027.036-.028.102.01.13.038.03.102.007.128-.028a.555.555 0 0 0 .053-.217.536.536 0 0 0-.191.115Zm-.019-.256c.016.037.003.096-.036.113-.04.017-.092-.015-.108-.052a.49.49 0 0 1 0-.201.49.49 0 0 1 .144.14Zm.045.006c-.024.032-.025.093.01.119.035.025.092.006.116-.027a.488.488 0 0 0 .048-.196.475.475 0 0 0-.174.104Zm.49.845c-.014.056-.08.113-.14.098-.06-.015-.091-.097-.077-.153.014-.056.155-.236.173-.231.018.004.058.23.044.286Zm.046.044c-.055.017-.108.085-.09.145.017.059.1.086.155.07.055-.017.228-.167.223-.184-.005-.019-.232-.048-.288-.03Zm.165-.258c-.011.046-.066.094-.116.081-.05-.012-.076-.08-.064-.126.011-.047.129-.197.144-.193a.606.606 0 0 1 .036.238Zm.039.036c-.046.014-.09.071-.076.12.015.05.084.073.13.059.046-.014.19-.139.185-.154a.602.602 0 0 0-.24-.025Zm.164-.246c-.01.043-.062.087-.108.075-.046-.011-.07-.074-.06-.117a.54.54 0 0 1 .133-.179.536.536 0 0 1 .035.22Zm.036.034c-.043.013-.084.066-.07.111.014.046.077.067.12.054a.543.543 0 0 0 .172-.142.545.545 0 0 0-.222-.023Zm.14-.215c-.01.04-.056.08-.098.069-.042-.011-.064-.068-.054-.107a.498.498 0 0 1 .12-.161c.013.003.04.16.031.2Zm.032.031c-.038.012-.076.06-.063.1.012.042.07.061.108.05a.495.495 0 0 0 .155-.129.484.484 0 0 0-.2-.02Zm-.647-.135c.015.056-.015.138-.075.153-.06.016-.126-.04-.141-.096-.015-.056.022-.282.04-.286.018-.005.162.173.176.23Zm.063.016c-.041.042-.055.127-.011.17.044.044.13.028.17-.013.04-.041.12-.255.107-.268-.013-.013-.226.07-.267.111Zm.02-.305c.012.047-.013.114-.063.127-.05.013-.105-.033-.117-.08-.012-.047.019-.234.034-.238a.605.605 0 0 1 .146.19Zm.052.014c-.034.034-.046.105-.01.141.037.037.109.024.143-.01a.594.594 0 0 0 .089-.224.6.6 0 0 0-.222.093Zm.025-.295c.011.043-.012.106-.058.118-.046.012-.097-.032-.109-.075a.56.56 0 0 1 .031-.221.551.551 0 0 1 .136.178Zm.048.013c-.031.031-.042.097-.008.13.034.034.1.022.13-.01a.549.549 0 0 0 .084-.207.545.545 0 0 0-.206.087Zm-.742-.634c.05.02.094.087.073.14-.021.054-.1.072-.15.053-.05-.02-.198-.171-.19-.187.005-.016.217-.026.267-.006Zm.046-.038c.009.053.066.11.122.101.057-.01.092-.082.083-.134-.008-.053-.125-.23-.142-.228-.017.003-.071.208-.063.26Zm-.217-.182c.04.016.078.072.06.116-.017.045-.083.06-.124.044a.538.538 0 0 1-.159-.155.536.536 0 0 1 .223-.005Zm.039-.031c.007.043.053.091.1.083.048-.007.077-.067.07-.111a.533.533 0 0 0-.118-.19.533.533 0 0 0-.052.218Zm-.208-.182c.039.015.073.068.056.109-.016.04-.076.055-.115.04a.501.501 0 0 1-.147-.144.508.508 0 0 1 .206-.005Zm.037-.028c.006.04.05.085.093.077.044-.007.071-.062.065-.104a.517.517 0 0 0-.11-.175.497.497 0 0 0-.049.202Zm-.181-.154c.034.014.066.06.051.097-.014.038-.07.051-.104.037a.463.463 0 0 1-.134-.13.452.452 0 0 1 .187-.004Zm.032-.026c.006.036.046.077.085.07.04-.007.064-.057.059-.094a.467.467 0 0 0-.1-.159.46.46 0 0 0-.044.183Zm.877.225c.028.045.023.126-.026.156s-.123-.003-.15-.048c-.028-.046-.056-.256-.04-.265.014-.009.188.111.216.157Zm.06-.002c-.025.047-.015.127.036.154.05.026.122-.01.147-.057.025-.048.038-.26.024-.268-.015-.008-.182.123-.207.17Zm-.064-.277c.023.038.019.105-.022.13-.04.025-.102-.001-.125-.04a.54.54 0 0 1-.034-.22.533.533 0 0 1 .181.13Zm.05-.001c-.02.039-.012.106.03.127.042.023.102-.008.123-.047a.556.556 0 0 0 .02-.223.54.54 0 0 0-.173.143Zm-.057-.27c.021.036.018.098-.02.121-.038.024-.095-.001-.116-.036a.505.505 0 0 1-.032-.205.497.497 0 0 1 .168.12Zm.046-.001c-.02.037-.011.098.028.119.038.02.094-.008.113-.045a.5.5 0 0 0 .018-.206.507.507 0 0 0-.16.132Zm-.052-.232c.02.032.016.088-.018.11-.034.02-.086-.002-.105-.034a.452.452 0 0 1-.028-.185.462.462 0 0 1 .151.11Zm.042 0c-.017.032-.01.088.025.106.036.019.086-.007.103-.04a.457.457 0 0 0 .016-.186.458.458 0 0 0-.144.12Zm-.509.339c.047.026.08.1.052.15-.028.049-.109.056-.155.03-.046-.027-.171-.198-.163-.213.008-.015.22.006.266.033Zm.051-.03c.001.052.048.117.106.117.057-.001.102-.068.101-.121 0-.054-.09-.246-.107-.246s-.1.196-.1.25Zm-.189-.213c.038.023.067.083.043.125-.023.041-.09.047-.128.025a.543.543 0 0 1-.136-.177.545.545 0 0 1 .221.027Zm.043-.025c0 .044.04.099.088.098.047 0 .085-.056.084-.1a.542.542 0 0 0-.09-.205.549.549 0 0 0-.082.207Zm-.179-.208c.036.02.062.076.04.115-.022.038-.084.044-.12.023a.504.504 0 0 1-.125-.164.5.5 0 0 1 .205.026Zm.04-.024c0 .04.037.091.082.09.044 0 .079-.052.078-.093 0-.041-.07-.19-.083-.19a.504.504 0 0 0-.077.193Z"
    />
    <path
      fill="#fff"
      d="M14.144 12.842s-.397-.004-.737-.234c-.34-.23-1.037-.651-1.594-.104 0 0 .39-.066.681.177.293.244.745.529 1.127.497a.646.646 0 0 0 .523-.336Z"
    />
    <path
      fill="#FF5B57"
      d="m7.23 6.771-.492-.491a4.618 4.618 0 0 1 3.287-1.362 4.62 4.62 0 0 1 3.288 1.362l-.492.491a3.928 3.928 0 0 0-2.796-1.158A3.93 3.93 0 0 0 7.23 6.77Z"
    />
    <path
      fill="#fff"
      d="m8.1 12.112-.005-.351h3.772l.015.358-3.783-.007ZM11.882 8.638l-.317-.04v-.74c0-.018-.006-.032-.01-.048h.015a.089.089 0 0 0 0-.177h-.392a.089.089 0 0 0 0 .177h.015c-.004.016-.01.03-.01.047v.695l-.145-.018-.287-.31a.515.515 0 0 0 .092-.286c0-.344-.356-.623-.796-.623-.44 0-.796.279-.796.623 0 .103.035.2.091.285l-.29.311-.145.018v-.694c0-.017-.005-.032-.01-.047h.016a.089.089 0 0 0 0-.177H8.52a.089.089 0 0 0 0 .176h.015c-.004.016-.01.031-.01.048v.741l-.316.04.262.392h.041v.543h.406v-.543h2.252v.543h.406v-.543h.042l.263-.393Z"
    />
    <path
      fill="#fff"
      d="M11.374 7.569c.15 0 .271-.064.271-.144 0-.043-.038-.081-.096-.108l-.176-.251-.175.251c-.057.026-.096.064-.096.108 0 .08.123.144.272.144Zm-1.36-.33c.156 0 .282-.077.282-.173 0-.05-.037-.095-.094-.127l-.188-.27-.187.27c-.057.032-.094.077-.094.127 0 .096.126.173.281.173Zm-1.298.33c.15 0 .271-.064.271-.144 0-.043-.038-.081-.096-.108l-.175-.251-.175.251c-.058.026-.096.064-.096.108 0 .08.121.144.271.144ZM11.844 11.591l-.267-.289v-.506h-.406v.486h-.163L9.96 9.832l-.799-.043-.04 1.236 1.049.01.493.247v.309h1.18Z"
    />
    <path
      fill="#fff"
      d="M8.919 10.796h-.406v.53l-.245.265h1.18v-.31h-.53v-.485ZM7.824 8.8l-.125.109s-.538.392-.359.77c-.1.14-.327.42-.153.702.175.284.34.537.231.802.327-.17.475-.484.375-.837-.084-.296.331-.522.469-.588l.25.379v.348h.407v-.599h-.352L7.824 8.8Zm4.926.88c.179-.379-.36-.77-.36-.77l-.124-.11-.743 1.087h-.352v.599h.406v-.349l.251-.379c.137.066.553.292.47.589-.1.353.047.667.374.837-.11-.266.056-.519.23-.802.175-.283-.052-.562-.152-.702ZM12.04 14.492a.194.194 0 0 1-.193.193c-.107 0-.716-.087-.716-.193 0-.107.61-.194.716-.194.107 0 .193.087.193.194Z"
    />
    <path
      fill="#fff"
      d="M12.735 14.506c.544-.101.566-.396.566-.396s-.296.188-.645.119c-.348-.07-.663-.058-.663-.058s.332.367.053.55c-.123.081-.465.047-.614.014a5.18 5.18 0 0 0-.54-.092.194.194 0 0 0 0 .386c.072 0 .389-.058.554-.096.165-.038.28-.056.404-.081.148-.03.458.009.846.04a.951.951 0 0 0 .801-.306c-.275.087-.636-.017-.762-.08Zm2.614-4.39c.022-.052-.476.319-.815.277-.34-.041-.992-.134-1.125.12-.134.252-.253.514-.253.514s.226-.131.518-.133c.294-.002.912-.03 1.154-.111.244-.082.434-.458.52-.666Zm-.47-1.64c-.006-.111-.226-.064-.271-.156-.045-.092.123-.287.03-.353s-.566.358-.83.642c-.263.284-.336.738-.251.872.084.134.03.012.03.012s.166-.33.434-.466c.267-.134.858-.551.858-.551Zm-7.167 4.737c.018.044.078.084.126.065.048-.02.064-.09.046-.134a.59.59 0 0 0-.168-.172c-.014.006-.022.196-.004.24Zm-.034.042c.048.007.1.057.091.108-.008.05-.072.083-.12.075a.59.59 0 0 1-.205-.126.598.598 0 0 1 .234-.057Zm-.195-.223c.017.04.073.078.117.06.043-.017.06-.083.043-.124a.546.546 0 0 0-.156-.16.542.542 0 0 0-.004.224Zm-.031.039c.044.007.092.053.084.1-.008.048-.068.077-.111.07a.541.541 0 0 1-.19-.118.544.544 0 0 1 .217-.052Zm1.017.299c.01.056.072.117.133.106.06-.011.098-.09.088-.147-.011-.056-.14-.245-.158-.242-.019.004-.074.226-.063.283Zm-.05.04c.054.02.104.093.082.15-.021.058-.105.08-.16.06-.054-.02-.217-.18-.21-.198.006-.017.235-.031.288-.011Zm-.147-.268c.008.048.06.098.11.09.05-.01.081-.076.072-.123a.586.586 0 0 0-.13-.202.595.595 0 0 0-.052.235Zm-.041.035c.045.016.085.076.067.124-.017.048-.087.067-.132.05-.045-.017-.181-.15-.175-.165a.596.596 0 0 1 .24-.01Zm-.148-.257c.008.044.055.09.103.082.046-.008.075-.07.067-.113a.548.548 0 0 0-.122-.187.553.553 0 0 0-.048.218Zm-.038.032c.042.015.08.07.063.115s-.082.062-.124.046a.553.553 0 0 1-.162-.152.546.546 0 0 1 .223-.01Zm-.125-.224c.007.04.05.083.093.075.042-.008.068-.063.06-.102a.487.487 0 0 0-.11-.17.486.486 0 0 0-.043.197Zm-.035.03c.038.013.072.063.057.104-.015.04-.074.055-.112.041a.489.489 0 0 1-.147-.138.508.508 0 0 1 .202-.008Zm.054.974c.043.04.129.05.171.005.042-.045.024-.13-.018-.17-.043-.038-.26-.111-.272-.098-.013.014.077.224.12.263Zm-.014.063c.055-.016.137.012.154.07.018.06-.036.128-.091.144-.056.017-.282-.013-.287-.031-.005-.018.169-.166.224-.183Zm-.28-.126c.036.033.107.043.142.005.035-.038.02-.108-.015-.141a.584.584 0 0 0-.226-.082c-.011.01.064.186.1.218Zm-.012.053c.046-.014.115.01.13.059.014.049-.03.106-.077.119a.587.587 0 0 1-.239-.026c-.004-.015.14-.139.186-.152Zm-.272-.117c.032.03.099.039.131.004s.019-.1-.014-.13a.548.548 0 0 0-.21-.077.54.54 0 0 0 .093.203Zm-.011.048c.042-.012.106.01.12.055.013.045-.029.098-.071.11a.538.538 0 0 1-.222-.024.541.541 0 0 1 .173-.14Zm-.235-.103c.03.027.09.036.119.004.03-.032.017-.091-.013-.118a.493.493 0 0 0-.19-.07.49.49 0 0 0 .084.184Zm-.01.044c.038-.012.096.008.108.05.013.04-.025.088-.064.1a.481.481 0 0 1-.2-.022.492.492 0 0 1 .156-.128Zm-.19-1.54c-.008.058.033.134.095.142.061.007.12-.058.127-.115.007-.057-.06-.276-.08-.278-.018-.002-.136.194-.143.252Zm-.06.025c.046.035.071.118.033.167-.037.049-.124.045-.17.01-.046-.035-.154-.237-.143-.252.012-.014.234.04.28.075Zm-.062-.3c-.005.048.029.111.08.118.05.006.1-.047.105-.095a.598.598 0 0 0-.065-.232c-.016-.002-.114.161-.12.209Zm-.05.02c.039.03.06.099.029.14-.032.04-.104.037-.142.008-.038-.03-.128-.197-.118-.21a.604.604 0 0 1 .232.063Zm-.064-.288c-.006.044.026.103.074.109.048.005.092-.044.098-.089a.546.546 0 0 0-.061-.214.55.55 0 0 0-.111.194Zm-.046.019c.035.027.055.09.026.128-.029.038-.096.035-.131.008a.546.546 0 0 1-.11-.194c.009-.01.18.03.215.058Zm-.053-.25c-.005.04.024.093.067.098.042.005.083-.04.088-.08a.486.486 0 0 0-.055-.194.486.486 0 0 0-.1.176Zm-.042.017c.032.024.05.082.024.116-.026.034-.088.032-.12.007a.497.497 0 0 1-.099-.175.49.49 0 0 1 .195.052Zm-.237.947c.029.05.108.087.161.056.054-.032.061-.118.033-.168-.028-.05-.214-.184-.23-.175-.015.01.007.237.036.287Zm-.033.056c.058 0 .129.051.128.113-.002.062-.073.11-.13.11-.058 0-.266-.097-.265-.116 0-.018.21-.108.267-.107Zm-.23-.203c.025.041.09.071.135.046.044-.026.05-.098.027-.14-.024-.041-.178-.153-.192-.145a.6.6 0 0 0 .03.239Zm-.026.046c.048 0 .106.043.106.094 0 .052-.06.092-.109.092a.587.587 0 0 1-.22-.096c0-.015.175-.09.223-.09Zm-.226-.192c.022.038.084.066.125.042.04-.024.047-.09.025-.129a.54.54 0 0 0-.178-.135.537.537 0 0 0 .028.222Zm-.025.042c.045 0 .1.04.098.088 0 .048-.056.086-.1.085a.55.55 0 0 1-.205-.089.55.55 0 0 1 .207-.084Zm-.193-.167c.02.035.075.06.113.038.037-.021.042-.082.022-.116a.502.502 0 0 0-.16-.122.485.485 0 0 0 .025.2Zm-.023.038c.04.001.09.037.089.08 0 .043-.05.077-.091.077a.494.494 0 0 1-.185-.081c0-.013.147-.076.187-.075Zm.584-.308c.001.058.053.128.115.126.062-.001.11-.074.109-.13-.001-.058-.1-.265-.118-.265-.019 0-.107.211-.106.27Zm-.055.034c.05.028.088.106.057.16-.03.054-.117.063-.167.034-.05-.028-.186-.212-.177-.228.009-.016.236.005.287.034ZM5.97 11.3c.001.048.044.106.096.105.051-.001.091-.061.09-.11 0-.047-.083-.22-.098-.219-.016 0-.09.176-.088.224Zm-.046.028c.042.023.073.089.048.134-.025.045-.098.052-.14.028-.04-.024-.154-.176-.146-.19.007-.014.196.004.238.028Zm-.106-.277c.002.044.042.098.089.097.048-.001.085-.057.084-.101a.546.546 0 0 0-.091-.204.552.552 0 0 0-.082.208Zm-.042.025c.038.022.067.082.043.124-.023.042-.09.048-.128.026a.538.538 0 0 1-.137-.176.554.554 0 0 1 .222.026Zm.469-.949c-.023.054-.004.139.052.163.057.024.13-.022.154-.075.022-.054.018-.283 0-.29-.016-.007-.184.15-.206.202Zm-.064.008c.034.047.035.134-.014.17-.05.037-.132.009-.167-.038-.034-.046-.082-.27-.068-.28.015-.012.215.101.249.148Zm.024-.305c-.02.043-.004.115.043.135.048.02.11-.019.128-.063a.6.6 0 0 0 0-.24c-.013-.006-.153.124-.171.168Zm-.054.006c.029.039.03.11-.011.141-.042.03-.11.008-.139-.03a.592.592 0 0 1-.056-.235c.012-.01.178.085.206.124Zm.018-.296c-.017.041-.003.107.04.125.044.018.102-.017.119-.058a.541.541 0 0 0 0-.222.544.544 0 0 0-.16.155Zm-.05.006c.027.036.028.102-.01.13-.038.03-.102.007-.128-.028a.556.556 0 0 1-.053-.217.547.547 0 0 1 .192.115Zm.018-.256c-.015.037-.002.096.037.113.04.017.091-.015.107-.052a.488.488 0 0 0 0-.201.497.497 0 0 0-.144.14Zm-.045.006c.024.032.025.093-.01.119-.035.025-.092.006-.116-.027a.487.487 0 0 1-.047-.196c.011-.008.15.07.173.104Zm-.49.845c.015.056.08.113.14.098.06-.015.092-.097.077-.153-.013-.056-.154-.236-.172-.231-.018.004-.058.23-.044.286Zm-.046.044c.055.017.109.085.091.145-.018.059-.1.086-.155.07-.055-.017-.229-.167-.223-.184.005-.019.232-.048.287-.03Zm-.164-.258c.011.046.066.094.116.081.05-.012.076-.08.064-.126-.011-.047-.129-.197-.144-.193-.015.004-.048.191-.036.238Zm-.04.036c.047.014.091.071.076.12-.015.05-.083.073-.13.059-.045-.014-.19-.139-.185-.154a.602.602 0 0 1 .24-.025Zm-.163-.246c.01.043.062.087.108.075.046-.011.07-.074.06-.117a.541.541 0 0 0-.134-.179.546.546 0 0 0-.034.22Zm-.036.034c.043.013.084.066.07.111-.014.046-.077.067-.12.054a.542.542 0 0 1-.172-.142.545.545 0 0 1 .222-.023Zm-.14-.215c.01.04.056.08.098.069.042-.011.064-.068.054-.107a.5.5 0 0 0-.12-.161.483.483 0 0 0-.031.2Zm-.032.031c.038.012.076.06.064.1-.013.042-.07.061-.109.05a.495.495 0 0 1-.155-.129.482.482 0 0 1 .2-.02Zm.646-.135c-.014.056.016.138.076.153.06.016.126-.04.14-.096.015-.056-.022-.282-.04-.286-.017-.005-.16.173-.176.23Zm-.062.016c.04.042.054.127.01.17-.043.044-.129.028-.17-.013-.04-.041-.12-.255-.107-.268.014-.013.226.07.267.111Zm-.02-.305c-.012.047.013.114.063.127.05.013.105-.033.117-.08.012-.047-.019-.234-.034-.238-.015-.004-.134.145-.146.19Zm-.052.014c.034.034.045.105.009.141-.037.037-.108.024-.142-.01a.593.593 0 0 1-.09-.224c.011-.01.19.059.223.093Zm-.025-.295c-.011.043.012.106.058.118.046.012.097-.032.109-.075a.559.559 0 0 0-.031-.221.537.537 0 0 0-.136.178Zm-.048.013c.03.031.042.097.008.13-.034.034-.1.022-.131-.01a.549.549 0 0 1-.083-.207c.01-.01.174.055.205.087Zm.742-.634c-.05.02-.094.087-.072.14.02.054.099.072.148.053.05-.02.199-.171.192-.187-.006-.016-.218-.026-.268-.006Zm-.046-.038c-.009.053-.065.11-.122.101-.057-.01-.092-.082-.083-.134.008-.053.125-.23.142-.228.016.003.07.208.063.26Zm.217-.182c-.041.016-.079.072-.06.116.017.045.082.06.123.044a.539.539 0 0 0 .16-.155.535.535 0 0 0-.223-.005Zm-.038-.031c-.008.043-.054.091-.102.083-.047-.007-.076-.067-.07-.111a.54.54 0 0 1 .12-.19.554.554 0 0 1 .051.218Zm.206-.182c-.038.015-.073.068-.056.109.017.04.077.055.115.04a.501.501 0 0 0 .148-.144.508.508 0 0 0-.207-.005Zm-.035-.028c-.007.04-.05.085-.094.077-.044-.007-.07-.062-.065-.104a.516.516 0 0 1 .11-.175.505.505 0 0 1 .049.202Zm.18-.154c-.034.014-.065.06-.051.097.014.038.07.051.104.037a.461.461 0 0 0 .134-.13.452.452 0 0 0-.187-.004ZM6.613 7.6c-.006.036-.045.077-.085.07-.04-.007-.063-.057-.058-.094a.458.458 0 0 1 .099-.159c.013.003.05.146.044.183Zm-.876.225c-.028.045-.023.126.026.156s.123-.003.15-.048c.028-.046.056-.256.04-.265-.014-.009-.189.111-.216.157Zm-.06-.002c.025.047.014.127-.036.154-.051.026-.123-.01-.148-.057-.025-.048-.038-.26-.023-.268.015-.008.182.123.207.17Zm.064-.277c-.024.038-.02.105.021.13.04.025.103-.001.126-.04a.541.541 0 0 0 .034-.22.533.533 0 0 0-.181.13Zm-.05-.001c.02.039.012.106-.03.127-.042.023-.101-.008-.123-.047a.554.554 0 0 1-.02-.223.542.542 0 0 1 .173.143Zm.057-.27c-.022.036-.018.098.02.121.038.024.095-.001.116-.036a.505.505 0 0 0 .032-.205.496.496 0 0 0-.168.12Zm-.046-.001c.02.037.01.098-.028.119-.039.02-.095-.008-.114-.045a.501.501 0 0 1-.018-.206.5.5 0 0 1 .16.132Zm.051-.232c-.02.032-.016.088.019.11.034.02.085-.002.105-.034a.452.452 0 0 0 .028-.185.463.463 0 0 0-.152.11Zm-.041 0c.017.032.01.088-.026.106-.035.019-.085-.007-.103-.04a.458.458 0 0 1-.016-.186.444.444 0 0 1 .145.12Zm.51.339c-.048.026-.081.1-.053.15.028.049.109.056.155.03.047-.027.172-.198.163-.213-.009-.015-.22.006-.266.033Zm-.053-.03c0 .052-.048.117-.105.117-.057-.001-.103-.068-.102-.121.001-.054.09-.246.108-.246.017 0 .1.196.1.25Zm.19-.213c-.039.023-.068.083-.044.125.024.041.09.048.129.025a.543.543 0 0 0 .136-.177.534.534 0 0 0-.222.027Zm-.043-.025c0 .044-.04.099-.088.098-.048 0-.086-.056-.085-.1 0-.045.076-.205.09-.205a.55.55 0 0 1 .083.207Zm.179-.208c-.036.02-.063.076-.04.115.022.038.083.044.119.023a.505.505 0 0 0 .125-.164.5.5 0 0 0-.204.026Zm-.04-.024c0 .04-.037.091-.082.09-.044 0-.079-.052-.078-.093 0-.041.07-.19.083-.19.014 0 .078.152.077.193Z"
    />
    <path
      fill="#fff"
      d="M5.816 12.842s.398-.004.738-.234c.34-.23 1.036-.651 1.593-.104 0 0-.389-.066-.68.177-.293.244-.746.529-1.127.497-.38-.031-.524-.336-.524-.336Zm5.472.805s-.667.196-1.307.183c-.641.013-1.308-.183-1.308-.183l-.614.589s.236-.072.627.104c.367.165.791.338 1.294.338s.928-.173 1.294-.338c.392-.177.627-.104.627-.104l-.613-.589Z"
    />
    <path
      fill="#fff"
      d="M7.92 14.492c0 .106.087.193.194.193.107 0 .716-.087.716-.193 0-.107-.61-.194-.716-.194a.194.194 0 0 0-.193.194Z"
    />
    <path
      fill="#fff"
      d="M7.227 14.506c-.545-.102-.566-.396-.566-.396s.296.188.644.119c.348-.07.663-.059.663-.059s-.332.368-.053.551c.123.081.465.047.614.014.149-.033.47-.092.54-.092a.193.193 0 0 1 0 .386 4.92 4.92 0 0 1-.553-.096c-.165-.038-.28-.056-.405-.082-.148-.03-.458.01-.845.04a.951.951 0 0 1-.802-.305c.274.087.636-.017.763-.08Zm-2.615-4.39c-.022-.052.475.319.815.277.34-.042.991-.134 1.125.12.134.252.253.514.253.514s-.226-.132-.519-.133c-.294-.002-.91-.03-1.154-.111-.243-.082-.434-.458-.52-.666Zm.47-1.64c.005-.111.225-.064.27-.156.046-.092-.122-.287-.03-.353.094-.066.567.358.83.642.264.284.337.738.252.872-.084.134-.03.012-.03.012s-.167-.33-.434-.466c-.267-.134-.859-.552-.859-.552Zm6.14 4.344c-.109.027-.244.162-.371.351a.353.353 0 0 0-.35-.33.36.36 0 0 0-.128.026.252.252 0 0 0-.206-.111.256.256 0 0 0-.174.07.256.256 0 0 0-.173-.07.254.254 0 0 0-.206.11.347.347 0 0 0-.127-.025.355.355 0 0 0-.355.35c-.13-.199-.27-.343-.384-.37-.186-.046-.33-.242-.454-.33 0 0 .012.337.347.578.222.16.163.53.163.53s.405.1.588.12c-.027-.081-.064-.156-.098-.23a.34.34 0 0 0 .106.046l.103.193s.238.022.49.022c.251 0 .49-.022.49-.022l.104-.193a.357.357 0 0 0 .083-.031c-.032.07-.066.14-.092.216.183-.02.589-.121.589-.121s-.06-.37.163-.53c.335-.24.347-.578.347-.578-.125.087-.269.283-.455.329Z"
    />
  </svg>
)
export default SvgAfghanistanIcon
