import type { SVGProps } from 'react'

const SvgLockedIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={16}
    height={16}
    fill="none"
    viewBox="0 0 16 16"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <path
      fill="currentColor"
      fillRule="evenodd"
      d="M5.763 2.138C6.375 1.526 7.207 1.4 8 1.4c.793 0 1.625.126 2.237.738.586.586.845 1.492.862 2.73.357.16.67.373.935.65.857.898 1.066 2.32 1.066 4.232 0 1.912-.208 3.333-1.066 4.231C11.167 14.89 9.795 15.1 8 15.1s-3.166-.21-4.034-1.119C3.11 13.083 2.9 11.662 2.9 9.75s.209-3.334 1.066-4.231c.265-.278.578-.49.935-.652.017-1.237.276-2.143.862-2.729Zm3.625.849c.23.23.441.665.497 1.535C9.323 4.432 8.693 4.4 8 4.4c-.693 0-1.323.031-1.886.122.057-.87.268-1.306.498-1.535.263-.264.68-.387 1.388-.387.707 0 1.125.123 1.388.387Zm-4.554 3.36c-.492.516-.734 1.47-.734 3.403s.242 2.887.734 3.402c.483.506 1.361.748 3.166.748s2.684-.242 3.166-.748c.493-.515.734-1.469.734-3.402s-.241-2.887-.734-3.403C10.684 5.842 9.806 5.6 8 5.6c-1.805 0-2.683.242-3.166.747ZM6.5 10.35h3v-1.2h-3v1.2Z"
      clipRule="evenodd"
    />
  </svg>
)
export default SvgLockedIcon
