import type { SVGProps } from 'react'

const SvgInactiveIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={16}
    height={16}
    fill="none"
    viewBox="0 0 16 16"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <g clipPath="url(#prefix__clip0_3902_969)">
      <path
        fill="currentColor"
        fillRule="evenodd"
        d="M2.1 8c0-1.366.063-2.41.23-3.214.165-.799.423-1.316.782-1.674.358-.358.875-.617 1.674-.782C5.59 2.163 6.634 2.1 8 2.1c1.365 0 2.409.063 3.214.23.798.165 1.316.424 1.674.782.358.358.617.875.782 1.674.167.805.23 1.848.23 3.214 0 1.365-.063 2.409-.23 3.214-.165.799-.424 1.316-.782 1.674-.358.358-.876.617-1.674.782-.805.167-1.849.23-3.214.23-1.366 0-2.41-.063-3.214-.23-.799-.165-1.316-.424-1.674-.782-.359-.358-.617-.875-.783-1.674C2.163 10.41 2.1 9.365 2.1 8ZM8 .9c-1.385 0-2.529.062-3.458.255-.936.193-1.7.529-2.279 1.108-.58.58-.915 1.343-1.109 2.28C.962 5.471.9 6.614.9 8c0 1.384.062 2.528.254 3.458.194.935.53 1.7 1.109 2.279.58.58 1.343.914 2.28 1.108.928.193 2.072.255 3.457.255 1.384 0 2.528-.062 3.457-.255.936-.194 1.7-.529 2.28-1.108.579-.58.914-1.344 1.108-2.28.193-.929.255-2.073.255-3.457 0-1.385-.062-2.528-.255-3.458-.194-.936-.53-1.7-1.108-2.279-.58-.58-1.344-.915-2.28-1.108C10.528.962 9.384.9 8 .9ZM7 8c0-2.026 0-2.684-.308-2.897C6.544 5 6.325 5 6 5 5 5 5 5 5 8c0 2.026 0 2.684.308 2.897C5.456 11 5.675 11 6 11c.325 0 .544 0 .692-.103C7 10.684 7 10.026 7 8Zm4 0c0-2.026 0-2.684-.308-2.897C10.544 5 10.325 5 10 5c-.325 0-.544 0-.692.103C9 5.316 9 5.974 9 8s0 2.684.308 2.897C9.456 11 9.675 11 10 11c.325 0 .544 0 .692-.103C11 10.684 11 10.026 11 8Z"
        clipRule="evenodd"
      />
    </g>
    <defs>
      <clipPath id="prefix__clip0_3902_969">
        <path fill="#fff" d="M0 0h16v16H0z" />
      </clipPath>
    </defs>
  </svg>
)
export default SvgInactiveIcon
