import type { SVGProps } from 'react'

const SvgContactIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={12}
    height={12}
    fill="none"
    viewBox="0 0 12 12"
    aria-hidden={true}
    focusable={false}
    {...props}
  >
    <g clipPath="url(#prefix__clip0_183_90)">
      <path
        fill="var(--customisation-50, #2A4AF5)"
        d="M11.5 6a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0Z"
      />
      <path
        fill="#fff"
        fillRule="evenodd"
        d="M2.795 9.015c.1-.16.208-.305.325-.44.786-.9 1.852-1.125 2.88-1.125 1.028 0 2.094.225 2.88 1.126.117.134.225.28.325.439-.255.27-.543.509-.86.708a2.453 2.453 0 0 0-.293-.424C7.565 8.742 6.882 8.55 6 8.55c-.881 0-1.565.192-2.051.75a2.453 2.453 0 0 0-.295.423 4.421 4.421 0 0 1-.859-.708ZM6 3.55a.95.95 0 1 0 0 1.9.95.95 0 0 0 0-1.9Zm-2.05.95a2.05 2.05 0 1 1 4.1 0 2.05 2.05 0 0 1-4.1 0Z"
        clipRule="evenodd"
      />
    </g>
    <defs>
      <clipPath id="prefix__clip0_183_90">
        <path fill="#fff" d="M0 0h12v12H0z" />
      </clipPath>
    </defs>
  </svg>
)
export default SvgContactIcon
