const colorMap = {
  // neutral
  '$neutral-5': 'text-neutral-5',
  '$neutral-10': 'text-neutral-10',
  '$neutral-20': 'text-neutral-20',
  '$neutral-30': 'text-neutral-30',
  '$neutral-40': 'text-neutral-40',
  '$neutral-50': 'text-neutral-50',
  '$neutral-60': 'text-neutral-60',
  '$neutral-70': 'text-neutral-70',
  '$neutral-80': 'text-neutral-80',
  '$neutral-90': 'text-neutral-90',
  '$neutral-95': 'text-neutral-95',
  '$neutral-100': 'text-neutral-100',
  '$neutral-2.5': 'text-neutral-2.5',
  '$neutral-80/10': 'text-neutral-80/10',
  '$neutral-80/20': 'text-neutral-80/20',
  '$neutral-80/30': 'text-neutral-80/30',
  '$neutral-80/40': 'text-neutral-80/40',
  '$neutral-80/5': 'text-neutral-80/5',
  '$neutral-80/50': 'text-neutral-80/50',
  '$neutral-80/60': 'text-neutral-80/60',
  '$neutral-80/70': 'text-neutral-80/70',
  '$neutral-80/90': 'text-neutral-80/90',
  '$neutral-80/95': 'text-neutral-80/95',

  // customisation
  '$army-50': 'text-army-50',
  '$army-60': 'text-army-60',
  '$army/10': 'text-army/10',
  '$army/20': 'text-army/20',
  '$army/30': 'text-army/30',
  '$army/40': 'text-army/40',
  '$army/5': 'text-army/5',
  '$blue-50': 'text-blue-50',
  '$blue-60': 'text-blue-60',
  '$blue/10': 'text-blue/10',
  '$blue/20': 'text-blue/20',
  '$blue/30': 'text-blue/30',
  '$blue/40': 'text-blue/40',
  '$blue/5': 'text-blue/5',
  '$camel-50': 'text-camel-50',
  '$camel-60': 'text-camel-60',
  '$camel/10': 'text-camel/10',
  '$camel/20': 'text-camel/20',
  '$camel/30': 'text-camel/30',
  '$camel/40': 'text-camel/40',
  '$camel/5': 'text-camel/5',
  '$cooper-50': 'text-cooper-50',
  '$cooper-60': 'text-cooper-60',
  '$cooper/10': 'text-cooper/10',
  '$cooper/20': 'text-cooper/20',
  '$cooper/30': 'text-cooper/30',
  '$cooper/40': 'text-cooper/40',
  '$cooper/5': 'text-cooper/5',
  '$magenta-50': 'text-magenta-50',
  '$magenta-60': 'text-magenta-60',
  '$magenta/10': 'text-magenta/10',
  '$magenta/20': 'text-magenta/20',
  '$magenta/30': 'text-magenta/30',
  '$magenta/40': 'text-magenta/40',
  '$magenta/5': 'text-magenta/5',
  '$orange-50': 'text-orange-50',
  '$orange-60': 'text-orange-60',
  '$orange/10': 'text-orange/10',
  '$orange/20': 'text-orange/20',
  '$orange/30': 'text-orange/30',
  '$orange/40': 'text-orange/40',
  '$orange/5': 'text-orange/5',
  '$pink-50': 'text-pink-50',
  '$pink-60': 'text-pink-60',
  '$pink/10': 'text-pink/10',
  '$pink/20': 'text-pink/20',
  '$pink/30': 'text-pink/30',
  '$pink/40': 'text-pink/40',
  '$pink/5': 'text-pink/5',
  '$purple-50': 'text-purple-50',
  '$purple-60': 'text-purple-60',
  '$purple/10': 'text-purple/10',
  '$purple/20': 'text-purple/20',
  '$purple/30': 'text-purple/30',
  '$purple/40': 'text-purple/40',
  '$purple/5': 'text-purple/5',
  '$sky-50': 'text-sky-50',
  '$sky-60': 'text-sky-60',
  '$sky/10': 'text-sky/10',
  '$sky/20': 'text-sky/20',
  '$sky/30': 'text-sky/30',
  '$sky/40': 'text-sky/40',
  '$sky/5': 'text-sky/5',
  '$turquoise-50': 'text-turquoise-50',
  '$turquoise-60': 'text-turquoise-60',
  '$turquoise/10': 'text-turquoise/10',
  '$turquoise/20': 'text-turquoise/20',
  '$turquoise/30': 'text-turquoise/30',
  '$turquoise/40': 'text-turquoise/40',
  '$turquoise/5': 'text-turquoise/5',
  '$yang-50': 'text-yang-50',
  '$yang-60': 'text-yang-60',
  '$yang/10': 'text-yang/10',
  '$yang/20': 'text-yang/20',
  '$yang/30': 'text-yang/30',
  '$yang/40': 'text-yang/40',
  '$yang/5': 'text-yang/5',
  '$yellow-50': 'text-yellow-50',
  '$yellow-60': 'text-yellow-60',
  '$yellow/10': 'text-yellow/10',
  '$yellow/20': 'text-yellow/20',
  '$yellow/30': 'text-yellow/30',
  '$yellow/40': 'text-yellow/40',
  '$yellow/5': 'text-yellow/5',
  '$yin-50': 'text-yin-50',
  '$yin-60': 'text-yin-60',
  '$yin/10': 'text-yin/10',
  '$yin/20': 'text-yin/20',
  '$yin/30': 'text-yin/30',
  '$yin/40': 'text-yin/40',
  '$yin/5': 'text-yin/5',
  // Added white tokens
  '$white-5': 'text-white-5',
  '$white-10': 'text-white-10',
  '$white-20': 'text-white-20',
  '$white-30': 'text-white-30',
  '$white-40': 'text-white-40',
  '$white-50': 'text-white-50',
  '$white-60': 'text-white-60',
  '$white-80': 'text-white-80',
  '$white-90': 'text-white-90',
  '$white-100': 'text-white-100',
} as const

export type ColorToken = keyof typeof colorMap

export const mapColorToken = (token: ColorToken): string => {
  return colorMap[token]
}
