import { match } from 'ts-pattern'

import { config } from '~config'
import { detectDesktopOS } from '~hooks/use-desktop-os'

import { MacOsPicker } from './mac-os-picker'

const desktopOs = detectDesktopOS()

const DownloadButton = () => {
  return (
    <div className="inline-flex gap-2 rounded-[20px] border border-dashed border-neutral-80/20 p-2">
      {match(desktopOs)
        .with('macos', () => <MacOsPicker>Beta 2 for macOS</MacOsPicker>)
        .with('windows', () => (
          <a
            className="group inline-flex h-10 items-center justify-center gap-1 whitespace-nowrap rounded-xl border border-neutral-30 bg-white-100 px-3 text-center text-15 font-medium leading-normal text-neutral-100 outline-none transition-all hover:border-neutral-40 active:border-neutral-50"
            href={config.desktop.downloadUrls.windows}
            target="_blank"
            rel="noreferrer"
          >
            <span>{icons.windows}</span>
            Beta for Windows
          </a>
        ))
        .with('linux', () => (
          <a
            className="group inline-flex h-10 items-center justify-center gap-1 whitespace-nowrap rounded-xl border border-neutral-30 bg-white-100 px-3 text-center text-15 font-medium leading-normal text-neutral-100 outline-none transition-all hover:border-neutral-40 active:border-neutral-50"
            href={config.desktop.downloadUrls.linux}
            target="_blank"
            rel="noreferrer"
          >
            <span>{icons.linux}</span>
            Beta for Linux
          </a>
        ))
        .otherwise(() => null)}
    </div>
  )
}

const icons = {
  linux: (
    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="none">
      <path
        fill="#09101C"
        d="M9.556 5.91c0 .053-.053.053-.053.053H9.45c-.033 0-.045-.02-.062-.049a.296.296 0 0 0-.044-.057s-.053-.053-.053-.106c0-.027 0-.04.007-.047.007-.006.02-.006.046-.006l.106.053c.053.053.106.106.106.159Zm-.953-.53c0-.265-.106-.424-.265-.424 0 0 0 .053-.053.053v.106h.159c0 .053.013.093.026.132.013.04.027.08.027.133h.106Zm1.854-.265c.106 0 .159.106.212.265h.106c-.053-.053-.053-.106-.053-.16 0-.052 0-.105-.053-.158-.053-.053-.106-.106-.16-.106 0 0-.052.053-.105.053 0 .026.013.04.026.053.014.013.027.026.027.053Zm-1.59.848c-.026 0-.04 0-.046-.007-.006-.007-.006-.02-.006-.046 0-.053 0-.106.053-.16.105 0 .158-.052.158-.052.053 0 .053.053.053.053 0 .053-.053.106-.159.212h-.053Zm-.582-.053c-.212-.106-.265-.265-.265-.53 0-.16 0-.265.106-.371a.291.291 0 0 1 .265-.159c.106 0 .159.053.265.159.053.159.106.318.106.477v.106h.053v-.053c.053 0 .053-.106.053-.318 0-.159 0-.318-.106-.477-.106-.159-.212-.265-.424-.265a.398.398 0 0 0-.371.265c-.106.212-.127.37-.127.636 0 .212.074.424.286.636a.277.277 0 0 1 .08-.053.277.277 0 0 0 .079-.053Zm6.622 7.469c.053 0 .053-.021.053-.069 0-.116-.053-.254-.212-.408-.16-.159-.424-.26-.742-.302-.053-.005-.106-.005-.106-.005a.537.537 0 0 0-.053-.01h-.053a2.885 2.885 0 0 1-.212-.027c.16-.493.212-.927.212-1.309 0-.53-.106-.9-.318-1.218-.212-.318-.424-.477-.688-.53-.053.053-.053.053-.053.106.264.106.53.318.688.636.16.37.212.689.212 1.06 0 .296-.053.736-.265 1.297-.211.085-.423.281-.582.588 0 .048 0 .074.053.074 0 0 .053-.047.106-.137.053-.045.092-.09.132-.135.04-.045.08-.09.132-.135.16-.09.265-.138.424-.138.265 0 .53.037.689.111.212.069.318.143.37.228.054.08.107.154.16.222 0 .07.053.101.053.101Zm-4.874-7.681c-.053-.053-.053-.16-.053-.265 0-.212 0-.318.106-.477.106-.106.212-.159.318-.159.159 0 .265.106.37.212l.033.094c.04.111.073.204.073.33 0 .265-.105.424-.317.477 0 0 .053.053.106.053.077 0 .126.028.189.064.022.013.047.027.075.041l.037-.208c.038-.212.07-.383.07-.586 0-.318-.053-.53-.16-.689a.68.68 0 0 0-.53-.212.854.854 0 0 0-.476.16c-.106.158-.159.264-.159.423 0 .265.053.477.159.689.027 0 .053.013.08.026a.189.189 0 0 0 .079.027Zm.636.847c-.689.477-1.219.689-1.643.689-.37 0-.741-.159-1.06-.424.054.106.107.212.16.265l.318.318c.212.212.476.318.741.318.371 0 .795-.212 1.325-.583l.476-.318c.106-.106.212-.212.212-.37 0-.054 0-.107-.053-.107-.053-.106-.317-.265-.847-.423-.477-.212-.848-.318-1.06-.318-.159 0-.423.106-.794.318-.318.211-.53.423-.53.635 0 0 .053.053.106.16.318.264.636.423.953.423.424 0 .954-.212 1.643-.742v.106c.053 0 .053.053.053.053Zm-4.7 5.602c0-.365.096-.768.292-1.245.19-.476.382-.794.567-1.006-.01-.053-.037-.053-.08-.053l-.052-.053c-.154.159-.34.53-.562 1.06-.223.476-.34.916-.34 1.24.001.238.06.444.165.624.117.175.397.43.842.752l.562.366c.599.52.916.88.916 1.091 0 .111-.053.223-.211.345a.502.502 0 0 1-.371.19c-.01 0-.016.01-.016.037 0 .006.053.112.164.318.223.302.7.45 1.335.45 1.165 0 2.066-.476 2.755-1.43 0-.265 0-.429-.053-.498v-.196c0-.344.053-.604.159-.773.106-.17.212-.25.37-.25.107 0 .212.038.318.117.053-.408.053-.763.053-1.08 0-.482 0-.88-.106-1.25a2.792 2.792 0 0 0-.264-.795l-.318-.477c-.053-.08-.093-.159-.133-.238-.04-.08-.08-.16-.132-.239l-.023-.09c-.044-.17-.083-.32-.083-.545-.08-.133-.146-.265-.212-.398-.066-.132-.132-.265-.212-.397-.106-.265-.212-.53-.318-.742l-.477.371c-.53.37-.953.53-1.324.53-.318 0-.583-.053-.742-.265l-.317-.265c0 .159-.053.37-.16.583l-.333.636c-.148.37-.228.582-.244.741a6.394 6.394 0 0 0-.016.083c-.013.072-.024.13-.031.13l-.398.794c-.429.794-.646 1.53-.646 2.14 0 .122.01.249.032.376a.785.785 0 0 1-.355-.689Zm3.794 5.012c-.689 0-1.219.093-1.59.278v-.016c-.264.318-.561.482-.974.482-.26 0-.668-.1-1.219-.302a14.385 14.385 0 0 0-1.478-.433 3.174 3.174 0 0 0-.291-.055 10.912 10.912 0 0 1-.408-.072 3.055 3.055 0 0 1-.376-.109.93.93 0 0 1-.318-.163.3.3 0 0 1-.109-.226c0-.085.018-.175.054-.272.034-.058.071-.116.108-.17.037-.057.069-.11.09-.163a.778.778 0 0 0 .074-.149.816.816 0 0 0 .074-.313 5.61 5.61 0 0 0-.063-.492 4.772 4.772 0 0 1-.064-.524c0-.233.053-.419.17-.551.116-.133.228-.202.344-.202h.61c.047 0 .121-.026.233-.09l.018-.042c.03-.066.054-.122.072-.175.014-.035.024-.066.032-.09.006-.018.01-.033.015-.042.01-.032.021-.064.032-.09a.727.727 0 0 1 .085-.122.32.32 0 0 1-.064-.207c0-.058 0-.111.01-.143 0-.19.09-.46.282-.816l.185-.333.037-.069c.135-.252.24-.447.318-.641.09-.212.185-.53.291-.954.085-.37.286-.741.604-1.112l.398-.477c.275-.318.455-.583.556-.795.1-.212.153-.476.153-.688 0-.106-.026-.424-.084-.954-.053-.53-.08-1.06-.08-1.536 0-.37.032-.636.1-.9.07-.266.192-.53.372-.742.159-.212.37-.424.688-.53A3.522 3.522 0 0 1 9.763 2c.159 0 .318 0 .476.053.16 0 .371.053.636.159.212.106.424.212.583.37.212.16.37.425.53.69.106.317.212.635.265 1.059.029.145.042.291.056.454.013.134.026.28.05.446 0 .187.018.336.033.46.01.088.02.163.02.23.03.088.042.194.057.317.012.096.025.202.049.318.052.212.105.424.211.583.106.211.212.423.371.635.093.155.203.309.321.474.085.118.174.241.262.374.477.53.848 1.112 1.06 1.695.264.53.423 1.219.423 1.955 0 .365-.053.72-.159 1.065.106 0 .16.042.212.116.053.074.106.233.16.482l.052.392a.623.623 0 0 0 .265.323c.106.096.212.175.37.239l.033.016c.104.051.243.12.339.206a.47.47 0 0 1 .159.334c0 .18-.053.313-.16.408a.83.83 0 0 1-.37.228c-.106.053-.318.159-.636.308-.265.157-.53.347-.794.572l-.53.451a2.938 2.938 0 0 1-.583.445 1.16 1.16 0 0 1-.583.143l-.37-.042c-.424-.112-.69-.323-.848-.647-.848-.102-1.536-.153-1.96-.153Zm4.452-1.025.012-.01a4.34 4.34 0 0 1 .8-.518c.076-.045.152-.085.223-.12a1.847 1.847 0 0 1-.59-.701l-.01.008c-.264.185-.58.316-.909.316-.307 0-.62-.05-.892-.196 0 .727-.036 1.413-.165 2.131.437.264.917-.259 1.269-.64.099-.109.188-.205.262-.27ZM5.533 13.93c.564.625 1.784 2.15 1.784 3.008.001.162-.353.056-.418.036-.177-.054-.42-.137-.736-.252a14.152 14.152 0 0 0-1.039-.337 6.723 6.723 0 0 0-1.015-.177c.13-.266.2-.55.2-.849 0-.207-.039-.408-.078-.61l-.025-.134c.214-.002.428-.009.636-.07.32-.094.574-.296.691-.615Z"
      />
    </svg>
  ),
  windows: (
    <svg
      width="21"
      height="20"
      viewBox="0 0 21 20"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M3 4.62373L9.13008 3.79152L9.13271 9.68623L3.00557 9.72099L3 4.62379V4.62373ZM9.12715 10.3653L9.13184 16.2652L3.00475 15.4254L3.00439 10.3258L9.12715 10.3653ZM9.87023 3.68258L17.9981 2.5V9.61123L9.87023 9.67549V3.68258ZM18 10.4208L17.9981 17.5L9.87018 16.3564L9.85881 10.4076L18 10.4208Z"
        fill="#09101C"
      />
    </svg>
  ),
}
export { DownloadButton }
