2021년 2월 현재 직장에서 내부 개발로 맡아 진행했던 경험입니다.

http://infrait.co.kr/bbs/notice.asp

# 요구사항:

1. 1번 사진(기존 홈페이지)을 2번 사진(요구되는 모습)처럼 보이도록 만들어야 합니다.
2. 아래 사항들을 충족해야 합니다.
    1. '기간' 추가
    2. '기간'에 맞는 '처리현황 출력'

# 활용 Skills:

1. ASP-HTML
    1. FORM 등
2. JAVASCRIPT
3. DB (Microsoft DB Server Management Service)

# 프로세스:

1. 각 게시물의 DB 테이블에 '기간' 추가
    1. 공지사항 / 이벤트 페이지와 연관된 '글 쓰기' 및 '글 수정' 페이지 수정
        1. 일반 홈페이지
            1. 게시글 목록 디스플레이 수정
            2. 각 게시글 수정 페이지 수정
        2. 관리자 페이지
            1. 게시글 작성 페이지 수정
            2. 게시글 수정 페이지 수정
    2. 각 게시물과 연결된 관련 DB 수정
2. 출력 확인

## 폼의 형태:

위와 같이 기간을 추가 하였습니다. 기간이기 때문에 두개의 값(bperiod1, bperiod2)을 만들었습니다.

- 우선 위와 같이, write.asp 파일과 save.asp 파일에 있는 변수들, SQL문, 폼 등에 bperiod1과 bperiod2를 추가해주었습니다.

## Database

- 해당 DB Table 안에 bperiod1 과 bperiod2를 datetime 변수로 지정해주었습니다.
    - 추후에 값 비교 후 '처리상황'을 생성하기 위해 datetime으로 하였습니다.

- 위 사진은 index.asp 입니다. 즉, 메인 페이지이죠. 여기 보니, include를 사용하여 db에 들어있는 공지사항들을 출력하는게 /board/list.asp라고 합니다.

- 위 사진은 list.asp입니다.  추가적으로 bPeriod1 & 2 변수를 만들어 주고, DB에서 불러와 값을 넣어 준 뒤, 글 제목에 (if bbs="notice" 공지사항 게시판 이라면) 기간을 추가하여 보여주도록 하였습니다.

- 위와 같이 리스트 페이지는 끝냈습니다.

## 관리자 페이지

- 위에 보이는 것이 관리자 페이지에서의 '공지사항 / 이벤트' 글 목록이고, 아래에 '글쓰기' 버튼이 보입니다.
- 글쓰기 버튼 클릭 → 글쓰기 페이지

기존 글쓰기 모습

기능 추가 후 글쓰기 모습

- 글쓰기/수정 페이지를 수정하여 위와 같이 바뀌도록 하였고, 아래 사진처럼 save.asp의 코드도 수정하여 period1 및 period2가 DB에도 저장이 되도록 하였습니다.

- 그리고 위 사진은 각 글의 하단에 있는 '글쓰기' 와 'modify(수정)' 기능입니다.
    - 위 두가지 페이지 또한 수정을 해야 합니다.

# 테스트

- **관리자페이지의 글쓰기/수정하기 페이지에 기간을 넣을 수 있도록 input을 주었습니다.**
- **관리자페이지와 연동되어 있는 save.asp 파일 등에 코드를 작성해 줌으로써 input으로 받아들여진 기간변수들이 DB로 저장될 수 있도록 하였습니다.**
- **일반 홈페이지에서도 DB에서 값을 받아와서 기간을 출력하고 해당 기간의 마지막 날짜와 현재날짜를 비교하여 '진행 중' 혹은 '마감'이라는 진행현황을 출력할 수 있도록 하였습니다.**
- **일반 홈페이지에서 수정 기능은 사용하지 않는다고해서 진행하였던 기능추가건은 그대로 놔두었습니다.**

## 느낌점 및 후기:

- **기존에 사용은 하였지만, 기능들은 자주 이용하지 않았던 것들이라 문제나 애로사항이 발생하였을 때 혼자서 헤쳐나가야 했습니다. 이런저런 파일들 include된 파일들을 헤쳐나가며 이젠 스스로도 코드를 보고 어떤 기능들이 어느 다른 기능들 혹은 페이지들과 연결되어 있는지 알아내고, 분석하고, 원하는 기능과 비슷한 기능들을 참조하고 구글링을 통해 추가기능들 개발할 수 있었습니다.**
- **DB management를 사용하는 것 또한 많이 능숙해졌다는 것을 느낄 수 있었습니다. 연결되어 있는 DB및 Table을 찾고 해당 DB/Table에 필요한 변수들을 추가해주고, 또한 테스트를 위해 각 데이터에 값들을 넣어줄 수 있었습니다.**
- **한페이지에서 기능들이 구현되기 때문에 많은 include 및 switch를 활용한 페이지여서 많이 복잡하기도 하였지만, 하나하나 나누어서 생각하고 구현하며 적용하니 문제 없이 원하는 기능들을 잘 구현해 낸 것 같습니다.**
