<p align="center">
  <img src="https://i.ibb.co/3pnjZMf/preview.png" alt="preview" width="350">
</p>

<p align="center"><a href="https://github.com/staniel359/muffon/actions/workflows/main.yml"><img alt="GitHub Actions Workflow Status" src="https://img.shields.io/github/actions/workflow/status/staniel359/muffon/main.yml?&labelColor=334"></a>&nbsp;<a href="https://github.com/staniel359/muffon/releases"><img alt="GitHub all releases" src="https://img.shields.io/github/downloads/staniel359/muffon/total?style=flat&logo=github&labelColor=334&color=a767eb"></a>&nbsp;<a href="https://github.com/staniel359/muffon/commits/main/"><img alt="GitHub last commit (branch)" src="https://img.shields.io/github/last-commit/staniel359/muffon/main?&labelColor=334&color=a767eb"></a>&nbsp;<a href="https://discord.gg/QAmJq5EpEb"><img alt="Discord" src="https://img.shields.io/badge/support/chat-blue?style=flat&logo=discord&labelColor=334&color=445"></a></p>

#

<img src="https://i.ibb.co/0tHYZS7/preview-light.png" alt="screenshot">

<img src="https://i.ibb.co/jg3vZv8/preview-dark.png" alt="screenshot">

## Description

[**muffon**](https://www.howtopronounce.com/muffon) is a cross-platform music streaming client for desktop, which helps you listen to, discover and organize music in an advanced way.

It retrieves audio, video and metadata from various Internet sources, such as:

- <img src="https://www.last.fm/static/images/favicon.702b239b6194.ico" height="16"> **Last.FM**
- <img src="https://vk.com/images/icons/favicons/fav_logo.ico" height="16"> **VK**
- <img src="https://ok.ru/favicon.ico" height="16"> **Odnoklassniki**
- <img src="https://music.yandex.ru/favicon16.png" height="16"> **Yandex Music**
- <img src="https://open.spotifycdn.com/cdn/images/favicon16.c498a969.png" height="16"> **Spotify**
- <img src="https://s4.bcbits.com/img/favicon/favicon-16x16.png" height="16"> **Bandcamp**
- <img src="https://e-cdn-files.dzcdn.net/cache/images/common/favicon/favicon-16x16.1e6ae1b5b7794f3e00c0.png" height="16"> **Deezer**
- <img src="https://a-v2.sndcdn.com/assets/images/sc-icons/favicon-2cadd14bdb.ico" height="16"> **SoundCloud**
- <img src="https://music.youtube.com/favicon.ico" height="16"> **YouTube Music**
- <img src="https://www.youtube.com/s/desktop/271dfaff/img/favicon.ico" height="16"> **YouTube**
- <img src="https://st.discogs.com/94414fa553c3f284a04c3da67024dd6574b8ab6f/images/favicon.ico" height="16"> **Discogs**
- <img src="https://assets.genius.com/images/apple-touch-icon.png" height="16"> **Genius**
- <img src="https://s.mxmcdn.net/site/images/favicon-32.png" height="16"> **MusixMatch**
- <img src="https://musicbrainz.org/static/images/favicons/favicon-16x16.png" height="16"> **MusicBrainz**

### Features

- **absolutely free**
- **no ads**
- **no login** (but required for certain features)
- **listening** (artists / albums / tracks) (+ offline) (+ equalizer)
- **artists** (tracks / albums / similar / shows)
- **albums**
- **tracks** (similar / albums)
- **tags** (artists / albums / tracks)
- **queue** (+ shuffle / loop) (+ albums adding)
- **music library** (+ import from account) (+ compatibility)
- **music services integration** (Last.FM, Spotify)
- **recommendations** (artists / tracks) (based on your library) (+ filters)
- **search** (artists / albums / album groups / tracks / lyrics / tags / videos / video channels / video playlists) (through all of the sources above)
- **radio** (tags / artists / top)
- **scrobbling** (Last.FM)
- **Discord Rich Presence** (+ buttons customization)
- **videos** (+ related / channels / playlists) (YouTube, YouTube Music)
- **lyrics** (+ annotations) (Genius, MusixMatch)
- **top** (artists / albums / tracks / tags) (+ country select)
- **new / upcoming releases**
- **multitag search** (artists / albums)
- **external links** (artists / albums / tracks / videos / video channels / video playlists)
- **playlists** (+ import from account) (+ album / queue adding)
- **favorites** (artists / albums / tracks / videos) (+ import from account)
- **bookmarks** (artists / albums / tracks / videos / video channels / video playlists)
- **listened** (artists / albums / tracks)
- **watched** (videos)
- **posting** (+ comments)
- **following**
- **messaging**
- **feed** (+ global)
- **communities**
- **sharing** (artists / albums / tracks / videos / video channels / video playlists / playlists / communities)
- **theming** (dark mode / background / transparency)
- **history** (activity / player / browser)

### Languages

- Беларуская ([@staniel359](https://github.com/staniel359))
- Deutsch ([@gamersi](https://github.com/gamersi))
- English ([@staniel359](https://github.com/staniel359))
- Français ([@TheFlomax](https://github.com/TheFlomax))
- עברית ([@EthanPZ1](https://github.com/EthanPZ1))
- Italiano ([@ZinRicky](https://github.com/ZinRicky), [@filipporomani](https://github.com/filipporomani))
- 日本語 ([@xyloflake](https://github.com/xyloflake))
- 한국어 ([@DDinghoya](https://github.com/DDinghoya))
- Polski ([@Lukas-KK](https://github.com/Lukas-KK))
- Русский ([@staniel359](https://github.com/staniel359))

### Technical stack

- Vue
- Electron

### Available platforms

- Windows (10, 11)
- MacOS
- Linux

## Download

[Latest (v2.1.0)](https://github.com/staniel359/muffon/releases/latest)

## Star History

<a href="https://star-history.com/#staniel359/muffon&Date">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=staniel359/muffon&type=Date&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=staniel359/muffon&type=Date" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=staniel359/muffon&type=Date" />
  </picture>
</a>

## Troubleshooting

If you're using Windows 10 and during the installation you see this window:

![Windows SmartScreen](https://i.ibb.co/ZL9Q5p9/img-59127adff18fb.png)

1. Click **"More info"**
2. Click **"Run anyway"**

That's because Windows blocks unsigned apps.

## Support

#### Have a question / suggestion / bug report?
[Create an issue](https://github.com/staniel359/muffon/issues/new) or [Join Discord chat](https://discord.gg/kpWsA5NBmJ)

- If you have a suggestion: Please check [planned features](https://emphasized-friend-e32.notion.site/Planned-35e985a3524e48f6a69732cce0d0b5e6) and [coming soon in next release](https://emphasized-friend-e32.notion.site/New-version-0aebcf9fcbd8474aa514feffa8b42703) to make sure you don't make a duplicate suggestion!
  
## Contribute

- **Translators** wanted for localization

## Donate

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/staniel359)

## Related projects

[muffon-api](https://github.com/staniel359/muffon-api) - REST API for client

[muffon-website](https://github.com/staniel359/muffon-website) - Website
