# 💻 타입스크립트(TypeScript) 특징

<br />

## 👨🏻‍💻 타입스크립트란?

- 타입스크립트는 자바스크립트에 타입을 부여한 언어이다. 자바스크립트의 확장된 언어라고 볼 수 있다.
- 타입스크립트는 자바스크립트와 달리 브라우저에서 실행하려면 파일을 한번 변환해주어야 한다. 이러한 과정을 컴파일(Compile)이라고 한다.

<br />

## 👨🏻‍💻 타입스크립트 특징

### 🏃 컴파일 언어, 정적 타입 언어

- 자바스크립트는 동적 타입의 인터프리터 언어로 런타임에서 오류를 발견할 수 있다. 이에 반해 타입스크립트는 정적 타입의 컴파일 언어이며 타입스크립트 컴파일러 또는 바벨(Babel)을 통해 자바스크립트 코드로 변환된다.
- 코드 작성 단계에서 타입을 체크해 오류를 확인할 수 있고 미리 타입을 결정하기 때문에 실행 속도가 매우 빠르다는 장점이 있다.
- 코드 작성 시 매번 타입을 결정해야 하기 때문에 번거롭고 코드량이 증가하여 컴파일 시간이 오래 걸린다는 단점이 있다.

<br />

### 🏃 자바스크립트 슈퍼셋(Superset)

- 타입스크립트는 자바스크립트의 슈퍼셋, 즉 자바스크립트 기본 문법에 타입스크립트의 문법을 추가한 언어이다.
- 유효한 자바스크립트로 작성한 코드는 확장자를 .js에서 .ts로 변경하고 타입스크립트로 컴파일해 변환할 수 있다.

<br/>

### 🏃 객체 지향 프로그래밍 지원

- 타입스크립트는 ES6(ECMAScript6)에서 새롭게 사용된 문법을 포함하고 있으며 클래스, 인터페이스, 상속, 모듈 등과 같은 객체 지향 프로그래밍 패턴을 지원한다.

<br/>

## 👨🏻‍💻 타입스크립트 사용을 고려해야 하는 이유

### 🏃 높은 수준의 코드 탐색과 디버깅

- 타입스크립트는 코드에 목적을 명시하고 목적에 맞지 않는 타입의 변수나 함수들에서 에러를 발생시켜 버그를 사전에 제거한다.
- 코드 자동완성이나 실행 전 피드백을 제공하여 작업과 동시에 디버깅이 가능해 생상선을 높일 수 있다.

<br />

### 🏃 자바스크립트 호환

- 타입스크립트는 자바스크립트와 100% 호환된다.
- 타입스크립트는 앱과 웹을 구현하는 자바스크립트와 동일한 용도로 사용 가능하며 서버 단에서 개발이 이루어지는 복잡한 대형 프로젝트에서도 빛을 발한다.

<br />

### 🏃 강력한 생태계

- 타입스크립트는 그리 오래되지 않은 언어임에도 불구하고 강력한 생태계를 갖고 있다.
- 대부분의 라이브러리들이 타입스크립트를 지원하며 비쥬얼 스튜디오 코드(VSCode)를 비롯해 각종 에디터가 타입스크립트 관련 기능과 플러그인을 지원한다.

<br />

### 🏃 점진적 전환 가능

- 기존의 자바스크립트 프로젝트를 타입스크립트로 전환하는데 부담이 있다면 추가 기능이나 특정 기능에만 타입스크립트를 도입함으로써 프로젝트를 점진적으로 전환할 수 있다.

<br />

## 참고

https://joshua1988.github.io/ts/
https://www.samsungsds.com/kr/insights/TypeScript.html
