# 💻 헷갈리는 용어(값, 리터럴, 표현식, 문, 토큰)

## 👨🏻‍💻 값(value)

- 값은 `식(표현식[expression])`이 `평가(evaluate)`되어 생성된 결과를 말한다. 또한, `평가`란 식을 해석해서 값을 생성하거나 참조하는 것을 의미한다.
- 아래 예제에서 `10 + 20(식)`은 `평가`되어 숫자인 `값 30`을 생성한다.

```js
10 + 20; // 30
```

- 모든 값은 데이터 타입을 가지며, 메모리에 `2진수`, 즉 `비트(Bit)의 나열`로 저장된다.
- 메모리에 저장된 값은 데이터 타입에 따라 다르게 해석될 수 있다. 예를 들어, 메모리에 저장된 값 0100 0001을 숫자로 해석하면 65이지만 문자로 해석하면 'A' 이다.

<br />

## 👨🏻‍💻 변수(variable)

- 변수는 `하나의 값`을 저장하기 위해 확보한 `메모리 공간 자체` 또는 그 `메모리 공간을 식별하기 위해 붙인 이름`이다. 따라서 변수에 할당되는 것은 `값`이다.
- 아래 예제에서 sum이라는 변수에 10 + 20(식)이 평가되어 생성된 숫자 값 30이 할당된다.
- sum변수에 할당되는 것이 10 + 20이 아니라 10 + 20이 평가된 결과 값인 30인 것을 기억하자. 따라서 10 + 20은 할당 이전에 평가되어 값을 생성해야만 한다.

```js
var sum = 10 + 20;
```

<br />

## 👨🏻‍💻 리터럴(literal)

- 값은 다양한 방법으로 생성할 수 있는데 가장 기본적인 방법은 `리터럴`을 사용하는 것이다.
- 리터럴은 `사람이 이해할 수 있는 문자` 또는` 약속된 기호`를 사용해 값을 생성하는 `표기법(notation)`을 말한다.
- 아래 예제에서 3은 단순히 아라비아 숫자가 아니라 숫자 리터럴이다. 사람이 이해할 수 있는 아라비아 숫자를 사용해 숫자 리터럴 3을 코드에 기술하면 자바스크립트 엔진은 이를 평가해 숫자 값 3을 생성한다.

```js
3; // 숫자 리터럴 3
```

- 이처럼 리터럴은 `사람이 이해할 수 있는 문자(아라비아 숫자, 알파벳, 한글 등)` 또는 `미리 약속된 기호('', "", {}, [], // 등)`로 표기한 코드이다.
- 자바스크립트 엔진은 코드가 실행되는 시점인 `런타임(runtime)`에 리터럴을 평가해 값을 생성한다. 즉, 리터럴은 값을 생성하기 위해 미리 약속한 표기법이라고 할 수 있다.

<br />

<img width="569" alt="스크린샷 2022-07-09 오후 2 25 50" src="https://user-images.githubusercontent.com/64779472/178092896-4678c60f-8670-438f-a604-8369bc041722.png">

<br />

## 👨🏻‍💻 표현식(expression)

- 표현식은 `값으로 평가될 수 있는 문(statement)`이다. 즉, 표현식이 평가되면 `새로운 값을 생성`하거나 `기존 값을 참조`한다.
- 위에서 리터럴을 설명할 때 리터럴은 값으로 평가된다고 설명했다. 따라서 `리터럴도 표현식`인 것이다.
- 아래 예제에서 100은 리터럴이다. 리터럴 100은 자바스크립트 엔진에 의해 평가되어 값을 생성하므로 리터럴은 그 자체로 표현식인 것이다.

```js
var sum = 100;
```

- 아래 예제 50 + 50은 리터럴과 연산자(+)로 이루어져 있다. 하지만 50 + 50도 평가되어 숫자 값 100을 생성하므로 50 + 50도 `표현식`이다.

```js
var score = 50 + 50;
```

- 또한 변수 식별자를 참조하면 변수 값으로 평가된다. 식별자 참조는 값을 생성하지는 않지만 값으로 평가되므로 이 또한 `표현식`인 것이다. 참고로, 식별자는 변수, 함수 등의 이름을 의미한다.

```js
score; // 100
```

- 이처럼 표현식은 `리터럴, 식별자, 연산자, 함수 호출` 등의 이뤄질 수 있다. 즉, `값으로 평가될 수 있는 문은 모두 표현식이다.`

```js
// 리터럴 표현식
10;
("Hello");

// 식별자 표현식
sum;
person.name;
arr[1];

// 연산자 표현식
50 + 50;

// 함수 호출 표현식(선언 되었다고 가정)
square();
```

- 계속 언급하지만 표현식은 `값으로 평가된다.` 이때 표현식과 표현식이 평가된 값을 동등한 관계, 즉 `동치(equivalent)다.` 예를 들어, 수학 수식 1 + 2 = 3에서 1 + 2는 3과 동치다. 즉, 1 + 2는 3과 같다고 할 수 있다.
- 자바스크립트의 표현식 1 + 2는 평가되어 값 3을 생성하므로 표현식 1 + 2와 값 3은 동치인 것이다. 따라서 `표현식은 값처럼 사용할 수 있다. ` 이처럼 문법적으로 값이 위치할 수 있는 자리에서 표현식도 위치할 수 있다는 것을 기억하자.
- 아래 예제는 방금 말한 부분에대한 예시이다. + 연산자는 좌항과 우항의 값을 산술 연산하는 연산자이므로 숫자 값이 위치해야 한다. 아래 예제는 좌항 x는 식별자 표현식이다. 즉, x는 할당되어 있는 변수 값 3으로 평가된다. 따라서 숫자 값이 위치해야 할 자리에 표현식 x를 사용할 수 있는 것이다.

```js
var x = 1 + 2;
x + 3; // 6
```

<br />

## 👨🏻‍💻 문(Statement)/토큰(token)

- 문과 표현식을 구별하고 해석할 수 있다면 자바스크립트 엔진의 입장에서 코드를 읽을 수 있고 실행 결과를 예측하는데 도움이 된다. 이는 버그를 줄이고 코드의 품질을 높여줄 수 있다. 따라서 문과 표현식은 확실히 이해할 필요가 있다.
- 개념적으로 설명하면 문(statement)는 `프로그램을 구성하는 기본 단위`이자 `최소 실행 단위`이다. 문의 집합으로 이뤄진 것이 바로 프로그램이며, 문을 작성하고 순서에 맞게 나열하는 것이 프로그래밍이다.
- 문은 `여러 토큰으로 구성`된다. 토큰(token)이란 `문법적인 의미`를 가지며, 문법적으로 `더 이상 나눌 수 없는 코드의 기본 요소`를 의미한다. 예를 들어 `키워드`, `식별자`, `연산자`, `리터럴` 심지어 `세미콜론(;)`이나 `마침표(.)` 등이다.
- 특수 기호는 문법적인 의미를 가지며, 문법적으로 더 이상 나눌 수 없는 코드의 기본 요소이기 때문에 모두 토큰인 것이다.

<br />

<img width="434" alt="스크린샷 2022-07-09 오후 2 24 35" src="https://user-images.githubusercontent.com/64779472/178092860-2c7454b2-ad6e-4c69-b426-722fc028bab6.png">

<br />

- 문을 `명령문`이라고도 부른다. 즉, 문은 `컴퓨터에 내리는 명령`이다. 문이 실행되면 명령이 실행되고 무슨 일인가 일어난다.
- 문은 `선언문`, `할당문`, `조건문`, `반복문` 등으로 구분할 수 있다.
- 변수 선언문을 실행하면 변수가 선언되고, 할당문을 실행하면 값이 할당된다. 조건문을 실행하면 지정한 조건에 따라 실행할 코드 블록({ ... }) 이 결정되어 실행되고, 반복문을 실행하면 특정 코드 블록이 반복 실행된다.

```js
// 변수 선언문
var x;

// 할당문
x = 5;
​
// 함수 선언문
function foo () {}

// 조건문
if (x > 1 ) {
  console.log(x);
}

// 반복문
for (let i = 0; i < 5; i++) {
  console.log(x, i);
}
```

<br />

## 참고

- 모던 자바스크립트 DeepDive
