# 💻 JavaScript & 일급 객체 & 컴파일/인터프리터 언어

<br />

## 👨🏻‍💻 자바스크립트란?

- 자바스크립트(JavaScript)는 `객체(Object) 기반의 스크립트 언어`이다.
- HTML로는 웹의 내용을 작성하고, CSS로는 웹을 디자인하며, 자바스크립트로는 웹의 동작을 구현할 수 있다.
- 자바스크립트는 주로 `웹 브라우저`에서 사용되거나, `Node.js`와 같은 프레임워크를 사용하면 서버 측 프로그래밍언어에서도 사용할 수 있다.
- 현재 컴퓨터나 스마트폰 등에 포함된 대부분의 웹 브라우저에는 `자바스크립트 인터프리터`가 내장되어 있다.

<br />

## 👨🏻‍💻 자바스크립트 특징

- 자바스크립트는 `객체 기반의 스크립트 언어`이다.
- 자바스크립트는 동적 타입 언어이며, 타입을 명시할 필요가 없는 `인터프리터 언어`이다. 따라서 프로그램을 실행하는 도중에 변수에 저장되는 데이터 타입이 동적으로 바뀔 수 있다.
- 자바스크립트는 객체 지향형 프로그래밍과 함수형 프로그래밍을 모두 표현할 수 있다.
- 일반적인 객체 지향 언어들은 `클래스`를 통해 객체 지향 언어에서 나타나는 상속 등의 특징을 구현한다.
- 자바스크립트는 `프로토타입(prototype)`이라는 개념을 통해 객체 지향 언어들의 특징을 구현한다. 따라서 자바스크립트는 클래스 기반이 아닌 `프로토타입 기반의 객체 지향 언어`인 것이다.
- 자바스크립트에서의 함수는 객체이며, 함수가 `일급 객체`이다.
- 함수가 `클로저`를 정의한다.

<br />

## 👨🏻‍💻 일급 객체란?

- 일급 객체란, 컴퓨터 프로그래밍에서 일반적으로 다른 객체들에 적용 가능한 연산을 모두 지원하는 객체
- 자바스크립트의 함수가 이 일급 객체이다.

<br />

### 🏃 일급 객체의 조건

- 변수(Variable)에 담을 수 있다.

```js
let bar = function () {
  return "Javascript";
};
```

<br />

- 파라미터로 전달할 수 있다.

```js
let number = [1, 2, 3];

number.forEach(function (x) {
  console.log(x * 2);
});
```

<br />

- 반환 값으로 사용할 수 있다.

```js
function test() {
  return function () {
    console.log("Javascript");
  };
}

let bar = test();

bar();
```

<br />

## 👨🏻‍💻 동적 타입 언어?

- 자바스크립트와 같은 동적 타입 언어는 `어떤 데이터 타입의 값이라도 자유롭게 할당`할 수 있다. 이를 통해, 데이터 타입을 신경쓰지 않고 사용할 수 있다는 편리함이 있지만, 이러한 편리함 속에 위험도 도사리고 있다.
- 자바스크립트의 변수 값은 언제든지 변경될 수 있기 때문에 복잡한 프로그램에서는 변화하는 변수 값을 추적하기가 매우 어려워 질 수 있다.
- 뿐만 아니라, 변수의 타입이 고정되어 있지 않고 동적으로 변하는 동적 타입 언어의 변수는 값의 변경에 의해 타입도 언제든지 변경 될 수 있다.
  - 즉, 동적 타입 언어는 `유연성(flexibility)는 높지만 신뢰성(reliability)는 떨어진다.`
- 이러한 단점을 개선하기 위해 `const를 통한 상수 사용`, `변수의 유효 범위(스코프)를 최대한 좁게 만들기`, `전역 변수 사용 줄이기`, `타입 스크립트` 사용 등이 있다.

<br />

## 👨🏻‍💻 자바 vs 자바스크립트

### 🏃 Java(자바)

- 컴파일 언어
- 타입 검사를 엄격하게 함
- 클래스(Class)기반의 객체 지향 언어

<br />

### 🏃 JavaScript(자바스크립트)

- 인터프리터 언어
- 타입을 명시하지 않음
- 프로토타입(prototype)기반의 객체 지향 언어

<br />

## 👨🏻‍💻 컴파일 언어와 인터프리터 언어

### 🏃 컴파일 언어

- 컴파일: `고급 언어(인간이 구분하기 쉬운 언어)`로 작성된 프로그램을 `기계어(컴퓨터 등의 기계가 이해할 수 있는 언어)`로 번역하고 기계어 프로그램으로 고치는 과정이다.
- 컴파일러: 컴파일을 수행하는 소프트웨어
- 컴파일 언어: 소스 코드 여러 개를 묶어서 컴파일 한 후에 실행되는 프로그래밍 언어(ex. C, Java 등)
- 특징
  - 컴파일 하는데 시간이 걸리지만 실행되는 속도가 빠르다.
  - 컴파일을 하게 되면 실행 가능한 파일(목적 프로그램)이 생성된다.

<br />

### 🏃 인터프리터 언어

- 인터프리터: 고급 언어로 작성된 프로그램을 `한줄 단위로 받아 들여 번역`하고, 번역과 동시에 프로그램을 `한 줄 단위로 실행`시키는 프로그램이다.
- 인터프리터 언어: 소스 코드를 바로 실행하는 컴퓨터 프로그램 또는 환경을 말한다. 즉, 소스 코드를 한줄 한줄씩 읽어가면서 실행하는 프로그래밍 언어이다.
- 특징: 프로그램을 바로 실행할 수 있고 동작을 확인해 가면서 프로그램을 개발할 수 있다. 하지만, 프로그램 코드를 한 줄 한 줄 번역하면서 실행하기 때문에 컴파일 언어보다 처리 속도가 느리다는 단점이 있다.

<br />

### 🏃 컴파일 vs 인터프리터 차이점

- 실행 단계의 차이
  - 컴파일 언어는 `컴파일러` 단계가 필요하고, 인터프리터 언어는 별도의 `컴파일러` 과정이 필요하지 않다.
- 생산 속도 차이
  - 컴파일 언어의 경우 `컴파일러` 과정이 들어가기 때문에 인터프리터 언어보다 생산 속도가 느리다. 인터프리터 언어는 과정이 단순하기 때문에 생산 속도가 빠르다.
- 소스 코드 작성 제약사항
  - 컴파일 언어는 소스 코드 작성을 위한 제약사항이 인터프리터 언어보다 더 많다. 따라서, 컴파일 언어에는 사용해야 하는 `변수의 자료형`에 대해서 명확하게 알아야하며, 각종 문법에 따른 제약사항 들도 알아야 한다.
- 디버깅
  - 인터프리터 언어는 간편한 만큼 잃는 것도 있다. 소스 코드가 실행되기 전까지 `소스 코드의 버그를 인지하는 것이 어렵다.` 물론, 인지할 순 있지만 컴파일 언어에 비해 오류 인지 시점이 늦다. 또한, 컴파일 언어가 디버깅 작업이 훨씬 수월하다.
- 실행 속도
  - 생산 속도는 인터프리터 언어가 좋지만, 실행 속도는 컴파일 언어가 훨씬 빠르다.
  - 컴파일 한 뒤에 생성된 파일에 의해 프로그램이 실행되기 때문에 번역기에 번역 되고 실행되는 인터프리터 언어에 비해 훨씬 빠르다.

<br />

## 👨🏻‍💻 프로그래밍 언어의 유형

- 절차적 언어: 절차를 순서대로 작성해나가는 언어
- 객체 지향 언어: 처리와 관련된 데이터와 절차를 하나로 묶어 객체 단위로 관리하는 언어
- 함수형 언어: 프로그램을 함수로 조합하여 구현해 나가는 언어
- 논리형 언어: 데이터 사이의 관계와 논리를 설명해 나가는 언어

<br />

## 참고

https://coding-factory.tistory.com/303
https://hoon26.tistory.com/21
https://velog.io/@emily0_0/%EC%BB%B4%ED%8C%8C%EC%9D%BC-%EC%96%B8%EC%96%B4%EC%99%80-%EC%9D%B8%ED%84%B0%ED%94%84%EB%A6%AC%ED%84%B0-%EC%96%B8%EC%96%B4
https://opentutorials.org/module/3989/26105
https://velog.io/@sparkbosing/%EC%9E%90%EB%B0%94%EC%8A%A4%ED%81%AC%EB%A6%BD%ED%8A%B8-%EC%96%B8%EC%96%B4%EC%9D%98-%ED%8A%B9%EC%A7%95
https://codedragon.tistory.com/3443
