# 💻 Framework와 Library

<br />

## 👨🏻‍💻 프레임워크(Framework)

- 🌟 `프레임워크`는 뼈대나 기반 구조를 뜻하고, `제어의 역전` 개념이 적용된 대표적인 기술이다.
- 프로그래밍을 진행할 때 필수적인 `코드`, `알고리즘` 등과 같이 어느 정도의 `구조`를 제공해주기 때문에 프레임워크를 사용하는 프로그래머는 이 프레임워크의 뼈대 위에서 코드를 작성하여 프로그램을 개발하게 된다.
- 소프트웨어에서의 프레임워크는 `소프트웨어의 특정 문제를 해결하기 위해 상호 협력하는 클래스와 인터페이스의 집합`이라 할 수 있다.
- 완성된 어플리케이션이 아닌 프로그래머가 완성시키는 작업을 해야 한다.
- 객체 지향 개발을 하게 되면서 통합성, 일관성의 부족이 발생되는 문제를 해결할 방법중 하나라고 할 수 있다.

<br />

### 🏃 제어의 역전

- 🌟 `제어의 역전`이란, 어떠한 일을 하도록 만들어진 프레임워크에 제어의 권한을 넘김으로써 클라이언트 코드가 신경 써야 할 것을 줄이는 전략이다.
- 일반적으로 라이브러리는 프로그래머가 작성하는 클라이언트 코드가 라이브러리의 메소드를 호출해서 사용 하는 것을 의미 한다.
- 프레임워크를 규정하는 특성은 프레임워크의 메소드가 사용자의 코드를 호출 한다는데 있다.
- 이해가 쉽게 설명하자면, 제어를 역전 시키는(프레임워크가 나의 코드를 호출 할 수 있게 하는)것을 가장 쉽게 생각할 수 있는 접근 방법은 프레임워크의 `event`, `delegate`에 나의 메소드를 등록시키는 것이다.
  - 전달되는 인자와 반환 형식만 일치 한다면, 프레임워크 코드는 내가 작성한 객체와 타입을 고려하지 않는다. 등록된 메서드만 감지하여 `실행 invoke` 하는 것이다.
- 다른 방법은 프레임워크에 정의 되어 있는 `인터페이스`, `추상 타입`을 나의 코드에서 `구현`, `상속` 한 후 프레임워크에 넘겨주는 것이다.
  - 프레임워크는 인터페이스와 추상을 알고있으므로 내가 하고자 하는 일련의 작업을 처리할 수 있다. 이는 객체를 프레임 워크에 주입하는 것이고, 이를 `의존을 주입(dependency injection)` 한다고 한다.

<br />

## 👨🏻‍💻 라이브러리(Library)

- 🌟 `라이브러리`는 특정 기능에 대한 도구 또는 함수들의 집합이다.
- 프로그래머가 어떠한 기능을 수행하기 위해서 도움을 주는 또는 필요한 것을 제공해주는 역할을하는 합니다. 즉, 프로그램 기능 수행을 위해 활용 가능한 도구의 집합이다.
- 쉽게 정리하면, 라이브러리는 그냥 함수들이나 기능 모음을 가져다 쓰는 것이다.

<br />

## 👨🏻‍💻 프레임워크와 라이브러리의 차이점

- 라이브러리와 프레임워크의 차이는 `제어 흐름에 대한 주도권이 누구에게/어디에 있는가`에 있다. 즉, 어플리케이션의 `Flow(흐름)`을 누가 쥐고 있느냐에 달려 있다.
- 프레임워크는 전체적인 흐름을 `스스로(프레임워크)`가 쥐고 있으며 사용자는 그 안에서 필요한 코드를 짜 넣는다.
- 반면에, 라이브러리는 `사용자`가 전체적인 흐름을 만들며 라이브러리를 가져다 쓰는 것이라 할 수 있다.
- 정리하면, 라이브러리는 가져다가 사용하고 호출하는 측(사용자)에 전적으로 주도성이 있으며 프레임워크는 그 틀안에 이미 `제어 흐름`에 대한 `주도권이 내재(내포)`하고 있다.

<br />

## 참고

https://webclub.tistory.com/458 <br />
https://juyeop.tistory.com/23 <br />
https://www.castingn.com/sourcing/kkultip_detail/110 <br />
