# 💻 CSR, SSR (with.SPA, MPA)
## 👨🏻‍💻 SPA(Single Page Application)
- 하나의 HTML 파일을 기반으로 자바스크립트를 이용해 동적으로 화면의 콘텐츠를 바꾸는 방식의 웹 어플리케이션.

<br />

## 👨🏻‍💻MPA(Multiple Page Application)
- 사용자가 페이지를 요철할 때마다, 웹 서버가 요청한 UI와 필요한 데이터를 HTML로 파싱해서 보여주는 방식의 웹 어플리케이션이다.
  - Parsing(구문 분석)
    - 문장이 이루고 있는 구성 성분을 분해하고 분해된 성분의 위계 관계를 분석하여 구조를 결정하는 것. 즉, 데이터를 분해 분석하여 원하는 형태로 조립하고 다시 빼내는 프로그램을 말한다. 웹상에서 주어진 정보를 내가 원하는 형태로 가공하여 서버에서 불러들이는 것이다.

<br />

## 👨🏻‍💻CSR(Client Side Rendering)
- CSR에선 브라우저가 서버에 HTML과 JS파일을 요청한 후 로드되면 사용자의 상호작용에 따라 JS를 이용해 동적으로 렌더링 시킨다.

<br />

![csr](https://user-images.githubusercontent.com/64779472/116118170-00c5df00-a6f8-11eb-8a26-2be19ad18bf8.PNG)

<br />

### 😍 장점
1. 첫 로딩만 기다리면, 동적으로 빠르게 렌더링되기 때문에 사용자 경험(UX)이 좋다.
2. 서버에서 요청하는 횟수가 훨씬 적기 때문에 서버의 부담이 덜하다.

<br />

### 😩 단점
1. 모든 스크립트 파일이 로드될 때까지 기다려야 한다.
    - 리소스를 청크(chunk)단위로 묶어서 요청할 때만 다운받게 하는 방식으로 완화시킬 수는 있지만 완벽히 해결할 수 없다.(코드 스플리팅)
2. 검색엔진의 검색 봇이 크롤링을 하는데 어렴움을 겪기 때문에 검색엔진 최적화(SEO: Search Engine Optimization)의 문제가 있다.
    - 구글 봇의 경우 JS를 지원하지만, 대부분의 다른 검색엔진의 경우 그렇지 않다. 
  
<br />

## 👨🏻‍💻SSR(Server Side Rendering)
- SSR에선 브라우저가 페이지를 요청할 때마다 해당 페이지에 관련된 HTML, CSS, JS 파일 및 데이터를 받아와서 렌더링을 시킨다.

<br />

![ssr](https://user-images.githubusercontent.com/64779472/116121584-b8102500-a6fb-11eb-87d2-a4d86e868e02.PNG)

<br />


### 😍 장점
1. 초기 로딩 속도가 빠르기 때문에 사용자가 컨텐츠를 빠르게 볼 수 있다.
2. JS를 이용한 렌더링이 아니기 때문에 검색 엔진 최적화(SEO)가 가능하다.

<br />

### 😩 단점
1. 매번 페이지를 요청할 때마다 새로고침 되기 때문에 사용자 경험(UX)가 SPA에 비해서 좋지 않다.
2. 서버에 매번 요청을 하기 때문에 서버의 부하가 커진다.
  
<br />

## 참고
https://github.com/baeharam/Must-Know-About-Frontend <br />