# 💻 Web Server와 WAS(Web Application Server)
- 웹 서버와 WAS는 클라이언트와 서버 간 통신을 위한 HTTP 프로토콜을 사용합니다. 하지만, 처리하는 컨텐츠의 특성에 따라 그 역할이 조금 다르다.

<br />

## Web Server

<img width="405" alt="스크린샷 2023-03-09 오후 11 51 21" src="https://user-images.githubusercontent.com/64779472/224061567-bc5c7649-cb4d-465a-ad84-aca37e28aa92.png">

- 웹 서버는 `정적인 컨텐츠(html, css, js, 이미지 등)`를 제공하는 서버로, 클라이언트의 요청에 대해 미리 작성된 파일을 그대로 전달한다. 
- 정적인 컨텐츠는 변경이 적고, 전달 속도가 빠르기 때문에 웹 서버에서 처리하는 것이 적합하다. 
- 대표적인 웹 서버에는 Apache HTTP Server, Nginx, Microsoft IIS 등이 있습니다.

<br />

### WAS(Web Application Server)

<img width="380" alt="스크린샷 2023-03-09 오후 11 52 39" src="https://user-images.githubusercontent.com/64779472/224061884-b0697e8b-365a-4a5a-a0c5-53ac71920a41.png">

- WAS(Web Application Server)는 동적인 웹 어플리케이션을 실행하며 데이터베이스와의 연동 등을 수행한다. 
- WAS는 웹 서버와는 달리 주로 `동적 콘텐츠`를 처리하며, 예를 들어 JSP, ASP, PHP 등의 언어로 작성된 프로그램을 실행하여 동적 콘텐츠를 생성하는 역할을 합니다.
- 대표적인 WAS에는 Apache Tomcat, IBM WebSphere, JBoss 등이 있습니다.

<br />

## 웹 서버와 WAS를 분리하는 이유
- 웹서버와 WAS를 분리하는 가장 큰 이유는 둘 간의 `역할 분담`과 그로인해 `서버 부하를 줄이기 위함`이다.
- 웹 서버와 WAS를 분리하면 부하 분산이 가능해져서 성능 개선을 할 수 있다. 부하 분산을 하면 각각의 서버에 걸리는 부하를 분산시켜서, 대량의 트래픽에 대응할 수 있다.
- 웹 서버는 HTML, CSS, 이미지 등과 같은 정적인 파일들을 처리하기 때문에, 파일 시스템만 읽어오면 되서 요청에 대한 응답이 매우 빠르다. 반면에, WAS는 동적인 컨텐츠를 처리하기 때문에, 요청에 대한 응답이 좀 더 느리게 되는 경우가 많다.
- `확장성` 측면에서도 이점을 가진다. 웹 서버와 WAS를 분리하면 각각의 서버를 `독립적으로 운영`할 수 있기 때문에, 서버 용량을 증설하기가 더 쉬워진다.
- 만약, WAS가 웹 서버의 기능까지 수행하게 될 경우, `성능 저하나 안정성 문제를 유발`할 수 있다. 🥲

<br />

## 표준 웹 서비스 아키텍처

<img width="766" alt="스크린샷 2023-03-09 오후 11 47 46" src="https://user-images.githubusercontent.com/64779472/224060580-c4ba6126-37c0-4a5f-980f-36d8c0fe5cfd.png">

- `Client - Web Server - WAS - DB`
- 위 아키텍처는 현재 대부분의 웹 서비스에서 사용되는 표준 아키텍처다. 동작 과정은 다음과 같다.
  1. 클라이언트가 웹 서버에 요청을 보내면 웹 서버는 해당 요청을 처리하는 역할을 한다. 
  2. 웹 서버는 처리를 위해 필요한 데이터를 WAS에 요청한다.
  3. WAS는 웹 서버로부터 요청받은 데이터를 DB에서 가져와 처리합니다. 
  4. WAS는 처리된 데이터를 다시 웹 서버에 전달한다. 
  5. 웹 서버는 클라이언트에 응답을 보낸다.

<br />
