# 💻 Waterfall vs Agile
<br />

## 👨🏻‍💻 폭포수 모델
![2](https://user-images.githubusercontent.com/64779472/117999152-88118480-b37f-11eb-928f-f1e00cd9e890.PNG)

<br />

### 🏃 폭포수 모델 특징
- `선형 순차적인 모델`이며, 70년대에 고안된 `고전적인 소프트웨어 생명 주기`
- 이름 그대로 폭포수처럼 위에서 아래로 물이 떨어지듯 차례대로 진행되어 이름이 붙여졌다.
- 여러 단계가 병랭적으로 진행되거나 거꾸로 진행되는 경우가 거의 없이 순차적으로 진행된다. 즉, 이전의 단계가 완벽하게 끝나야 다음 단계로 넘어갈 수 있다는 뜻이다.

<br />

### 🏃 폭포수 모델 장점
- 선형 모델이기 때문에 이해하기가 쉽다.
- 단계 별로 정형화된 접근 방법이 있어 체계적으로 문서화가 가능하다.
- 프로젝트 진행 상황을 명확히 파악이 가능하다.

<br />

### 🏃 폭포수 모델 단점
- 요구 사항을 완벽하게 작성해야 한다.
- 변경, 피드백 수용이 어렵다.
- 대형 프로젝트에는 적용이 부적합하다.
- 지나친 문서화 작업이 있다.
- 일정 지연 가능성이 크다.

<br />

## 👨🏻‍💻 애자일(Agile: 기민한, 민첩한)
![3](https://user-images.githubusercontent.com/64779472/117999738-1e45aa80-b380-11eb-99e8-74e0985d3383.PNG)

<br />

### 🏃 애자일의 특징
- 소프트웨어 개발 방식으로서 프로젝트 작업 계획을 짧은 단위로 세우고 프로토타입을 만들어 나가는 사이클을 반복함으로써 고객의 요구 변화에 유연하고 신속하게 대응하는 개발 방법론
- 문서 위주의 개발 방법이 아닌 실질적인 `코딩`을 통한 방법론
- `협력`과 `피드백`이 핵심인 방법론
- `짧은 주기의 개발 단위(스피린트)`를 `반복`하여 하나의 큰 프로젝트를 완성

<br />

### 🏃 애자일 선언문(애자일의 가치)
- 프로세스, 도구보다는 `사람과 상호작용`을
- 광범위한 문서보다는 `실제 작동하는 제품`을
- 계약 협상보다는 `고객과의 협력`을,
- 계획을 따르기보다는 `변화의 대응`을,
- 이 말은 왼쪽에 있는 것들도 가치가 있지만 `오른쪽`에 있는 것들에 더 가치를 둔다.

<br />

## 👨🏻‍💻 스크럼(Scrum)
![4](https://user-images.githubusercontent.com/64779472/118000451-c8253700-b380-11eb-83a4-04e7626c3e15.PNG)

<br />

### 🏃 스크럼이란?
- 애자일 방법론의 종류 중 하나로 반복적이고 점진적인 개발 방법
- 전통적인 소프트웨어 개발 모델인 폭포수 모델과 달리 각 반복주기가 종료될 때마다 부분적으로 완성된 결과물이 만들어지며, 이러한 반복 주기를 스프린트라고 한다.

<br />

### 🏃 제품 책임자(Product Owner)
- 제품 백로그를 `관리`, `통제`할 수 있는 권한을 가진 사람으로 단 1명뿐이다.
- 제품 백로그 항목들의 우선순위를 정하고, 매 스프린트 결과를 검토하여 우선 순위를 지속적으로 `조정`, `관리`한다.

<br />

### 🏃 개발팀(Team)
- 프로젝트 수행에 필요한 역량을 갖춘 팀으로, 각 팀원은 자신의 전문 영역에 고정되지 않고 다같이 팀 과제를 수행한다.
- 자율 관리 조직이기 때문에 제 3자의 명령을 받지 않고 스스로 업무, 분량, 목표를 결정하고 자신이 약속한 목표를 달성할 책임이 있다.

<br />

### 🏃 스크럼 마스터(Scrum Master)
- 스크럼의 가치에 대한 이해를 바탕으로 현장에 맞는 실천법을 정립하여 실제 프로젝트에서 실행될 수 있게 이끄는 역할이다.
- 일일 스크럼 회의를 주관한다.
- 기존의 프로젝트 관리자와는 달리 업무 지시, 통제를 하지 않고 필요한 자원을 지원하거나 장애물을 제거하는 조력자 역할을 한다.

<br />

### 🏃 제품 백로그(Product Backlog)
- 제품 완성에 필요한 특성, 개선점 등 제품의 모든 요구사항을 우선순위에 따라 나열한 목록이다.
- 제품 백로그는 확정, 고정된 것이 아니고 변화에 따라 지속적으로 업데이트 된다.
- 우선 순위가 높은 백로그는 낮은 백로그보다 더 명확하고 상세하게 기술되어야 한다.

<br />

### 🏃 스프린트 계획 회의(Sprint Planning Meeting)
- 제품 백로그에 작성된 프로젝트 요구사항을 가지고 스프린트 목표 및 기간을 설정하고 스프린트 백로그를 작성한다.

<br />

### 🏃 스프린트 백로그(Sprint Backlog)
- 하나의 스프린트 동안 완료할 과제들의 목록

<br />

### 🏃 스프린트(Sprint)
- 과제가 진행되는 주기를 지칭하는 것으로 1 ~ 4주로 구성되며, 하나의 스프린트가 끝나면 바로 다음 스프린트가 진행된다.
- 스프린트를 진행하는동안 기간, 과제 가감 등의 변경은 불가능하다.

<br />

### 🏃 데일리 스크럼(Daily Scrum)
- 매일 팀원들의 진행사항을 간단하게 공유하는 시간

<br />

### 🏃 스프린트 리뷰(Sprint Review)
- 스프린트가 종료되었을 때 개발팀이 스프린트 동안 개발한 기능을 고객을 포함한 이해 관계자들에게 보여주고 피드백을 받는 과정

<br />

### 🏃 스프린트 회고(Sprint Retrospective)
- 리뷰 후 프로젝트를 진행하면서 좋았던 점, 문제점 등을 도출해 다음 스프린트를 더 나은 방향으로 개선할 수 있도록 하는 과정

<br />

## 👨🏻‍💻 폭포수 vs 애자일
![waterfallvsAgile](https://user-images.githubusercontent.com/64779472/118002961-1a675780-b383-11eb-8b09-d7f656beb9ed.PNG)

<br />
