# 💻 Compiler와 TransPiler, Polyfill

<br />

## 👨🏻‍💻 컴파일러(Compiler)

- 컴파일러란? 프로그래밍 언어로 작성된 인간의 의도(프로그램)를 기계(컴퓨터)가 이해하게 기계언어로 변환하는 변환기이다.
- 전통적인 컴파일러는 고급의 프로그래밍 언어를 저급의 프로그래밍 언어로 변환한다.

<br />

### 🏃 기계어

- 기계어란? 기계가 이해하는 2진 숫자(0과1)로 작성된 언어입니다. 프로그래머가 C언어로 작성한 C프로그램은 C컴파일러가 기계어로 변환한다.
- 변환된 기계어가 있어야 컴퓨터(기계)가 C프로그램의 내용을 이해할 수 있다.

<br />

### 🏃 컴파일러 변환 예제

```
  파스칼 -> C언어
  JAVA -> Bytecode
  C -> assembly
  TypeScript -> JavaScript
```

<br />

## 👨🏻‍💻 트랜스파일러(TransPiler)

- 트랜스 파일러는 소스 대 소스 컴파일러 (Source - to - Source Compiler) 또는 트랜스 컴파일러(Transcompiler)로 불린다.
- 트랜스 파일러는 하나의 프로그래밍 언어로 작성된 프로그램의 소스 코드를 입력으로 받아 다른 프로그래밍 언어로 동등한 소스 코드를 만들어 내는 `컴파일러의 일종`이다.
- 즉, 컴파일러가 더 큰 범주에 속하고, 그 안에 트랜스파일러 개념이 있는 것이다.

<br />

### 🏃 트랜스 파일러 목적

- 트랜스 파일러의 다른 목적으로 레거시 코드를 변환하여 차세대 기반 프로그래밍 언어 또는 하위 호환성을 유지하지 못하는 API를 사용할수 있게 하기 위해서다.
- 리팩토링할 프로그램이 원래의 구현자의 제어권 밖에 있거나 (이를테면 파이썬2를 파이썬3로 프로그램을 변환한다든지, 오래된 API를 새로운 API로 변환한다든지 등), 수작업으로 리팩토링 하기에는 시간이 많이 소요되거나 프로그램의 크기가 비현실적일 때 자동 리팩토링을 수행한다.
- 트랜스 파일러는 오리지널 소스 코드의 개발 및 디버그를 용이하게 하기 위해 가능한 원본 코드에 가까운 변환된 코드를 유지할 수 있으며, 원래 코드의 구조를 변경함으로써 변환된 코드가 원본 코드처럼 보이지 않게 만들 수도 있다.

<br />

### 🏃 트랜스 파일러 예제

```
  JavaScript ES6 -> ES5
  C++ -> C
  CoffeeScript -> JavaScript
```

<br />

## 👨🏻‍💻 폴리필(Polyfill)

- 웹 개발에서 기능을 지원하지 않는 웹 브라우저 상의 기능을 구현하는 코드를 뜻한다.
- 예를 들어 ES6에만 있는 기능을 ES6를 지원하지 않는 브라우저에서 사용하고 싶을 때 폴리필을 사용하여 호환성을 맞춰줄 수 있음
- 기능을 지원하지 않는 브라우저에서 원하는 기능을 구현할 수 있으나, 폴리필 플러그인 로드 때문에 시간과 트래픽이 늘어나고, 브라우저별 기능을 추가하는 것 때문에 코드가 매우 길어지고, 성능이 저하된다는 단점이 있다.

### 🏃 폴리필 예시

```
  HTML5 shiv: 인터넷 익스플로러9 이하에서 시맨틱 태그를 지원하도록 한다.
  CSS3 PIE: 인스턴 익스플로러9 이하에서 CSS3 둥근 모서리(border-radius)속성을 지원하도록 한다.
  FlashCanvas: 캔버스를 지원하지 않는 인터넷 익스플로러8 이하에서 HTML5 캔버스를 인터넷 익스플로러8 이하에 맞는 플래시 오브젝트로 바꾸어 나타내준다.
```

<br />

## 참고

https://ideveloper2.tistory.com/166 <br />
https://ko.wikipedia.org/wiki/%ED%8F%B4%EB%A6%AC%ED%95%84_(%ED%94%84%EB%A1%9C%EA%B7%B8%EB%9E%98%EB%B0%8D)<br />
https://ooz.co.kr/416 <br />
https://ssben.tistory.com/27 <br />
