# 💻 Cookie와 Session, Web Storage
<br />

## 👨🏻‍💻 쿠키(Cookie)
- 🌟 쿠키는 `클라이언트(브라우저) 로컬`에 저장되는 `키와 값(Key/Value)`이 들어있는 작은 데이터 파일이다.
- 클라이언트의 `브라우저 메모리` 혹은 `하드디스크`에 저장이 된다.
- 사용자 인증이 `유효한 시간`을 명시할 수 있으며, 유효 시간이 정해지면 브라우저가 종료되어도 인증이 유지된다는 특징이 있다.
- 쿠키는 클라이언트의 상태 정보를 `로컬`에 저장했다가 참조한다.
- 클라이언트에 `300개`까지 쿠키를 저장 가능하며, 하나의 도메인당 `20개`의 값만 가질 수 있다.
- 쿠키 하나의 크기는 `4KB`까지 저장이 가능하며, `유효 기간이 존재`한다.
- 쿠키는 사용자가 따로 요청하지 않아도 브라우저가 `Request 시`에 `Request Header`를 넣어서 `자동으로 서버에 매번 전송`한다.

<br />

### 🏃 쿠키의 구성 요소
- 이름(Name): 각각의 쿠키를 구별하는 데 사용되는 이름
- 값(Value): 쿠키의 이름과 관련된 값
- 유효시간(Expires): 쿠키의 유지시간
- 도메인(Domain): 쿠키를 전송할 도메인
- 경로(Path): 쿠키를 전송할 요청 경로

<br />

### 🏃 쿠키의 특징
- 대부분의 브라우저가 지원을 한다.
- 보안에 취약하다.
  - PC방 등의 공공장소에서 로그인할 때 쿠키를 사용한다면 이름, 연락처, 주민등록번호, 비밀번호와 같은 개인정보가 PC방 컴퓨터에 저장되어 해킹 가능성 있다.
- 유효 시간동안 보관되기 때문에 유효 시간이 있을 경우 브라우저가 닫혀도 유지가 된다.
- 매 HTTP 요청마다 포함되어 서버로 전송되기 때문에 서버에 부담이 크다.
- 용량이 작다(4KB)

<br />

### 🏃 쿠키의 동작 방식
![쿠키동작과정](https://user-images.githubusercontent.com/64779472/121037205-3b886000-c7ea-11eb-8aa5-81d505e94bb4.PNG)

1. 클라이언트가 페이지를 요청
2. 서버에서 쿠키를 생성
3. HTTP 헤더에 쿠키를 포함시켜 응답
4. 브라우저가 종료되더라도 쿠키 만료 기간이 있다면 클라이언트에서 보관하고 있음
5. 같은 요청을 할 경우 HTTP 헤더에 쿠키를 함께 보냄
6. 서버에서 쿠키를 읽어 이전 상태 정보를 변경할 필요가 있을 때, 쿠키를 업데이트 하여 변경된 쿠키를 HTTP 헤더에 포함시켜 응답

<br />

## 👨🏻‍💻 세션(Session)
- 🌟 세션은 `쿠키를 기반`으로 하고 있지만, `사용자 정보 파일`을 브라우저에 저장하는 쿠키와 달리 세션은 `서버` 측에서 관리한다.
- 서버에서 클라이언트를 구분하기 위해 `세션 ID`를 부여하며, 웹 브라우저가 서버에 접속해서 브라우저를 종료할 때까지 인증 상태를 유지한다.
- `접속 시간 제한`을 두어 일정 시간 응답이 없다면 정보가 유지되지 않게 설정도 가능하다.
- 사용자에 대한 정보를 서버에 두기 때문에 `쿠키보다 보안이 좋다.` 하지만, 사용자가 많아질수록 서버 메모리를 많이 차지하게 된다.
- 클라이언트가 `Request`를 보내면, 해당 서버의 엔진이 클라이언트에게 유일한 ID(세션 ID)를 부여한다.

<br />

### 🏃 세션의 동작 방식
![세션동작방식](https://user-images.githubusercontent.com/64779472/121039796-5b208800-c7ec-11eb-8173-817b2755849e.PNG)

1. 클라이언트가 서버에 접속 시 `세션 저장소`에서 `세션 ID`를 발급한다.
2. 클라이언트는 세션 ID에 대해 `쿠키`를 이용해 저장해서 가지고 있는다.
3. 클라이언트는 서버에 요청할 때, 갖고있던 `쿠키`의 `세션 ID`를 세션 저장소에 전달해서 사용한다.
4. 서버는 클라이언트로부터 `세션 ID`를 전달 받아 별 다른 작업없이 `세션 ID`로 `세션 저장소`에 있는 `클라이언트 정보`를 가져온다.
5. 클라이언트 정보를 가지고 서버 요청을 처리하여 클라이언트에게 응답한다.

<br />

### 🏃 세션의 특징
- 각 클라이언트에게 `고유 ID(세션 ID)`를 부여한다.
- 세션 ID로 클라이언트를 구분해서 클라이언트의 요구에 맞는 서비스를 제공한다.
- 보안 면에서 쿠키보다 우수하다.
- 사용자가 많아지면 서버 메모리를 많이 차지하게 되서 `성능 저하 요인`이 될 수 있다.

<br />

## 👨🏻‍💻 쿠키와 세션의 차이점
### 🔍 저장 위치
- 쿠키: 클라이언트
- 세션: 서버

<br />

### 🔍 보안
- 쿠키: 클라이언트에 저장되므로 `보안에 취약`
- 세션: 쿠키를 이용해 세션ID만 저장하고 이 값으로 구분해서 서버에서 처리하므로 `쿠키보다 보안성이 좋다.`

<br />

### 🔍 라이프사이클
- 쿠키: 만료 시간에 따라 브라우저를 종료해도 계속해서 남아있을 수 있다.
- 세션: 만료 시간을 정할 수 있지만 브라우저가 종료되면 만료 시간에 상관없이 삭제된다.

<br />

### 🔍 속도
- 쿠키: 클라이언트에 저장되어 서버 요청 시에 빠르다.
- 세션: 실제 저장된 정보가 서버에 있으므로 서버의 처리가 필요해 쿠키보다 느리다.

<br />

## 👨🏻‍💻 웹 스토리지(Web Storage)
- 클라이언트에 데이터를 저장할 수 있도록 `HTML5`부터 새롭게 지원하는 저장소이다.
- `키와 값(Key/Value)`의 형태로 데이터를 저장한다.
- 쿠키와 달리, 서버에 전송되지 않으므로 서버에 부담이 가지 않는다.`(명시적으로만 전송 가능)`
- 쿠키와 달리, 필요한 경우에만 꺼내 쓰는 것이므로 `자동 전송의 위험이 없다.` 다른 도메인에서 요청하는 경우에는, 꺼내 쓰고 싶어도 `도메인 단위로 접근이 제한`되는 특성 덕분에 값을 꺼내 쓸 수 없다. `(CSRF 안전)`
- 쿠키와 달리, 대략 `5MB`까지의 데이터를 저장할 수 있으며 `유효 기간이 존재하지 않는다.`
- HTML5를 지원하지 않는 브라우저에서는 사용할 수 없다.
- `로컬 스토리지(Local Storage)`와 `세션 스토리지(Session Storage)`가 있다. 이들은 window 객체의 프로퍼티로서 존재하며, 같은 `Storage 객체`를 `상속`하기 때문에 동일한 메서드를 가진다. 이 둘의 차이점은 `데이터의 영구성`이다.

<br />

### 🏃 로컬 스토리지(Local Storage)
- window.localStorage 객체
- 브라우저를 종료해도 유지되는 데이터로, 명시적으로 지우지 않는 한 `영구적으로 저장`된다.
- `도메인별`로 생성되며, 다른 도메인의 로컬 스토리지에는 접근이 불가능하다.
- 서로 다른 브라우저 탭이라도 동일한 도메인이라면 동일한 로컬 스토리지를 사용한다.
- 지속적으로 필요한 정보를 저장하기에 좋다.(ex 자동 로그인)

<br />

### 🏃 세션 스토리지(Session Storage)
- window.sessionStorage 객체
- 세션, 쿠키와 달리 `탭/윈도우 단위`로 세션 스토리지가 생성 된다.
- 즉, window 객체와 동일한 유효 범위 및 생존 기간을 가지며, `탭/윈도우를 닫을 시 데이터가 삭제된다.`
- 또한 동일한 탭/윈도우라도 다른 도메인이라면 또 다른 세션 스토리지가 생성 된다.
- 서로 다른 세션 스토리지는 서로 영향을 주지 않으며 `독립적`으로 동작한다.
- 윈도우 복제로 생성된 경우, 혹은 스크립트로 새 창을 연 경우 세션 스토리지가 `복제`되어 생성된다.
- 잠시 동안 필요한 정보`(일회성 정보)`를 저장하기에 좋다.(ex. 입력 폼 저장, 일회성 로그인)

<br />

## 👨🏻‍💻 값 가져오는 법과 세팅하는 법
```js
  //로컬 스토리지
  localStorage.getItem("A");

  //세션 스토리지
  sessionStorage.getItem("A");

  //쿠키
  getCookie("A");
```
<br />

```js
  //로컬 스토리지
  localStorage.setItem("A", 1); //Key = A, Value = 1

  //세션 스토리지
  sessionStorage.setItem("A", 1); //Key = A, Value = 1

  //쿠키
  setCookie("A", 1, 7);//Key = A, Value = 1, 유효시간 = 7초
```

<br />

## 참고
https://velog.io/@jch9537/Node.js-Session-Cookie <br />
https://homzzang.com/b/free-1208 <br />
https://hahahoho5915.tistory.com/32 <br />
https://interconnection.tistory.com/74 <br />
https://it-eldorado.tistory.com/90 <br />
https://racoonlotty.tistory.com/entry/%EC%BF%A0%ED%82%A4%EC%99%80-%EC%84%B8%EC%85%98-%EA%B7%B8%EB%A6%AC%EA%B3%A0-%EB%A1%9C%EC%BB%AC-%EC%8A%A4%ED%86%A0%EB%A6%AC%EC%A7%80%EC%99%80-%EC%84%B8%EC%85%98-%EC%8A%A4%ED%86%A0%EB%A6%AC%EC%A7%80 <br />
https://velog.io/@kler/TIL4-%EB%A1%9C%EC%BB%AC%EC%8A%A4%ED%86%A0%EB%A6%AC%EC%A7%80-%EC%84%B8%EC%85%98%EC%8A%A4%ED%86%A0%EB%A6%AC%EC%A7%80-%EC%BF%A0%ED%82%A4-%EC%A0%95%EB%A6%AC <br />