# 💻 Front-Interview

### 내가 직접 정리해보는 프론트엔드 기술 면접 리스트 😁

- 오탈자나 수정해야되는 부분있으면 언제든 pr, 또는 이슈 등록해주세요.

<br />

## 🌟 Contributors

[![contributors](https://contrib.rocks/image?repo=ssi02014/Front-Interview)](https://github.com/ssi02014/Front-Interview/graphs/contributors)

<br />

## 🔖 CS(Computer Science)

### 🔍 Overall

- [주소창에 URL 입력하면 벌어지는 일](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/enter-url-process.md)
- [동기(Synchronous)와 비동기(Asynchronous)](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/synchronous-asynchronous.md)
- [함수형프로그래밍(Functional Programming)](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/functionalProgramming.md)
- [폭포수(Waterfall) vs 애자일(Agile)](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/waterfall-Agile.md)
- [컴파일러, 트랜스파일러, 폴리필](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/transcompiler.md)

<br />

### 🔍 알고리즘과 자료구조

- [빅오(Big-O)표기법](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/big-O.md)

<br />

### 🔍 WEB Browser

- [쿠키(Cookie)와 세션(Session) 그리고 웹 스토리지(Web Storage)](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/cookie-session.md)
- [캐시(Cache)](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/cache.md)

<br />

### 🔍 운영체제(OS)

<br />

### 🔍 네트워크(Network)

- [HTTP와 HTTPS](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/http-https.md)
- [HTTP/1.1 vs HTTP/2.0 vs HTTP/3.0](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/http1-2-3.md)
- [DNS(Domain Name System)](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/DNS.md)
- [TCP와 UDP](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/tcp-udp.md)
- [유니캐스트/브로드캐스트/멀티캐스트](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/uni-broad-multicast.md)
- [웹 서버와 WAS](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/webserver-was.md)
- [CORS(Cross-Origin Resource Sharing)](https://github.com/ssi02014/Front-Interview/blob/master/documents/CS/cors.md)

<br />
<br />

## 🔖 프론트엔드 전반

- [브라우저 렌더링 과정](https://github.com/ssi02014/Front-Interview/blob/master/documents/Frontend-Overall/browser-rendering-process.md)
- [프레임워크(Framework)와 라이브러리(Library)](https://github.com/ssi02014/Front-Interview/blob/master/documents/Frontend-Overall/library-framework.md)
- [REST(Representational State Transfer) API](https://github.com/ssi02014/Front-Interview/blob/master/documents/Frontend-Overall/restful.md)
- [JSON(JavaScript Object Notation)](https://github.com/ssi02014/Front-Interview/blob/master/documents/Frontend-Overall/json.md)
- [V8 엔진](https://github.com/ssi02014/Front-Interview/blob/master/documents/Frontend-Overall/V8.md)
- [require vs import](https://github.com/ssi02014/Front-Interview/blob/master/documents/Frontend-Overall/require-import.md)

<br />

## 🔖 HTML

- [DOCTYPE](https://github.com/ssi02014/Front-Interview/blob/master/documents/HTML/doctype.md)
- [viewport](https://github.com/ssi02014/Front-Interview/blob/master/documents/HTML/viewport.md)

<br />

## 🔖 JavaScript

### ⭐️ 초급

- [자바스크립트란? & 일급 객체 & 컴파일/인터프리터 언어](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/javascript.md)
- [헷갈리는 용어(값, 리터럴, 표현식, 문, 토큰)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/value-literal-statement.md)
- [문서 객체 모델(Document Object Model:DOM)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/dom-tree.md)
- [var, let, const (with.호이스팅)](http://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/var-let-const.md)
- [이벤트 위임(with. bubbling, Capturing)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/event-delegation.md)
- [자바스크립트 부동소수점 계산 문제](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/floating-point.md)
- [객체 프로퍼티 접근법(마침표 접근, 대괄호 접근)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/accessing-properties.md)
- [원시 타입 vs 객체(참조) 타입](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/primitive-object.md)
- [함수: 값에 의한 호출(call by value), 참조에 의한 호출(call by reference)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/callbyvalue-reference.md)
- [콜백 함수와 고차 함수](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/callback-higher.md)

<br />

### ⭐️ 중급

- [스코프(Scope)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/scope.md)
- [호이스팅(Hoisting)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/hoisting.md)
- [이벤트 루프(Event Loop)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/event-loop.md)
- [클로저(Closure)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/closure.md)
- [실행 컨텍스트(Execution Context)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/execution-context.md)
- [Ajax(Asynchronous JavaScript And XML)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/ajax.md)
- [프로미스(Promise)](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/promise.md)
- [XMLHttpRequest와 Fetch](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/xmlhttprequest.md)
- [async/await](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/async-await.md)

<br />

### ⭐️ 심화

- [자바스크립트 가비지 컬렉션](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/gc.md)
- [이터러블/이터레이터, 제너레이터](https://github.com/ssi02014/Front-Interview/blob/master/documents/JavaScript/iterator-generator.md)

<br />

## 🔖 React

- [CSR (Client Side Rendering) vs SSR(Server Side Rendering)](https://github.com/ssi02014/Front-Interview/blob/master/documents/Frontend-Overall/csr-ssr.md)
- [리액트 vs 뷰 vs 앵귤러](https://github.com/ssi02014/Front-Interview/blob/master/documents/React/react-vue-angular.md)
- [JSX (JavaScript XML)](https://github.com/ssi02014/Front-Interview/blob/master/documents/React/jsx.md)
- [자주 사용하는 리액트 훅 (React Hooks)](https://github.com/ssi02014/Front-Interview/blob/master/documents/React/hooks.md)

<br />

### 🌟 React 심화

- [UseState는 비동기/배치 처리된다.](https://github.com/ssi02014/Front-Interview/blob/master/documents/React/useState.md)
- [React 재조정(Reconciliation), Virtual DOM 비교](https://github.com/ssi02014/Front-Interview/blob/master/documents/React/reconciliation.md)
- [ErrorBoundary](https://github.com/ssi02014/Front-Interview/blob/master/documents/React/errorBoundary.md)

<br />

## 🔖 TypeScript

- [타입스크립트란?](https://github.com/ssi02014/Front-Interview/blob/master/documents/typescript/typescript.md)
- [타입스크립트 기본 타입 및 자주 사용하는 유틸리티 타입](https://github.com/ssi02014/Front-Interview/blob/master/documents/typescript/types.md)
- [타입스크립트 typeof/keyof](https://github.com/ssi02014/Front-Interview/blob/master/documents/typescript/typeof-keyof.md)

<br />
