---
title: Installation and Configuration
description: 💻 In-depth guides about installation and configuration
weight: 1
---

# Installation and Configuration

## **[Installation](./installation/index.md)**

  * 🐳 [Docker Compose (✨ Recommended)](./installation/docker_compose_install.md)
  * 🦦 [Container (Podman)](./installation/container_install.md)
  * 🐧 [Linux](./installation/linux_install.md) 
  * 🍎 [Mac](./installation/mac_install.md) 
  * 🪟 [Windows](./installation/windows_install.md) 

## **[Configuration](./configuration/index.md)**

  * ⚙️ [Environment Variables](./configuration/dotenv.md) 
  * 🖥️ [Custom Config](./configuration/custom_config.md) 
    * 🅰️ [Azure OpenAI](./configuration/azure_openai.md)
    * ✅ [Compatible AI Endpoints](./configuration/ai_endpoints.md) 
  * 🐋 [Docker Compose Override](./configuration/docker_override.md)
  * 🤖 [AI Setup](./configuration/ai_setup.md)
  * 🚅 [LiteLLM](./configuration/litellm.md)
  * 🦙 [Ollama](./configuration/ollama.md)
  * 💸 [Free AI APIs](./configuration/free_ai_apis.md) 
  * 🛂 [Authentication System](./configuration/user_auth_system.md) 
  * 🍃 [Online MongoDB](./configuration/mongodb.md) 
  * 🌍 [Default Language](./configuration/default_language.md) 
  * 🌀 [Miscellaneous](./configuration/misc.md)