---
title: Configuration
description: ⚙️ This section provides detailed guides on how to configure LibreChat to suit your needs and preferences. You will learn how to set up various environment variables, customize your Docker settings, choose your AI models and APIs, enable user authentication, connect to online MongoDB, change the default language, and more.
weight: 2
---

# Configuration

  * ⚙️ [Environment Variables](./dotenv.md)
  * 🖥️ [Custom Config](./custom_config.md)
    * 🅰️ [Azure OpenAI](./azure_openai.md)
    * ✅ [Compatible AI Endpoints](./ai_endpoints.md) 
  * 🐋 [Docker Compose Override](./docker_override.md) 
---
  * 🤖 [AI Setup](./ai_setup.md)
  * 🚅 [LiteLLM](./litellm.md)
  * 🦙 [Ollama](./ollama.md)
  * 💸 [Free AI APIs](./free_ai_apis.md)
---
  * 🛂 [Authentication System](./user_auth_system.md) 
  * 🍃 [Online MongoDB](./mongodb.md) 
  * 🌍 [Default Language](./default_language.md) 
  * 🌀 [Miscellaneous](./misc.md)