---
title: Home
description: 🪶 Introducing LibreChat
weight: -10
---

<p align="center">
  <a href="https://librechat.ai">
    <img src="assets/LibreChat.svg" style="margin-left: 40px; height: 256px; width: 256px;>
  </a>
  <a href="https://librechat.ai">
    <!-- Use the margin-top property to add some space between the image and the text -->
    <h1 align="center" style="padding: 0;">LibreChat</h1>
  </a>
</p>


<p align="center">
  <a href="https://discord.librechat.ai"> 
    <img
      src="https://img.shields.io/discord/1086345563026489514?label=&logo=discord&style=for-the-badge&logoWidth=20&logoColor=white&labelColor=000000&color=blueviolet">
  </a>
  <a href="https://www.youtube.com/@LibreChat"> 
    <img
      src="https://img.shields.io/badge/YOUTUBE-red.svg?style=for-the-badge&logo=youtube&logoColor=white&labelColor=000000&logoWidth=20">
  </a>
  <a href="https://github.librechat.ai"> 
    <img 
      src="https://img.shields.io/badge/GITHUB-blue.svg?style=for-the-badge&logo=github&logoColor=white&labelColor=000000&logoWidth=20">
  </a>
<a aria-label="Sponsors" href="https://github.com/sponsors/danny-avila">
    <img
      src="https://img.shields.io/badge/SPONSORS-brightgreen.svg?style=for-the-badge&logo=github-sponsors&logoColor=white&labelColor=000000&logoWidth=20">
  </a>
</p>


## 🪶 Features
 - 🖥️ UI matching ChatGPT, including Dark mode, Streaming, and 11-2023 updates
 - 💬 Multimodal Chat:
     - Upload and analyze images with GPT-4 and Gemini Vision 📸 
     - More filetypes and Assistants API integration in Active Development 🚧 
 - 🌎 Multilingual UI:
     - English, 中文, Deutsch, Español, Français, Italiano, Polski, Português Brasileiro, Русский
     - 日本語, Svenska, 한국어, Tiếng Việt, 繁體中文, العربية, Türkçe, Nederlands
 - 🤖 AI model selection: OpenAI API, Azure, BingAI, ChatGPT, Google Vertex AI, Anthropic (Claude), Plugins
 - 💾 Create, Save, & Share Custom Presets
 - 🔄 Edit, Resubmit, and Continue messages with conversation branching
 - 📤 Export conversations as screenshots, markdown, text, json.
 - 🔍 Search all messages/conversations
 - 🔌 Plugins, including web access, image generation with DALL-E-3 and more
 - 👥 Multi-User, Secure Authentication with Moderation and Token spend tools
 - ⚙️ Configure Proxy, Reverse Proxy, Docker, many Deployment options, and completely Open-Source

## 📃 All-In-One AI Conversations with LibreChat
LibreChat brings together the future of assistant AIs with the revolutionary technology of OpenAI's ChatGPT. Celebrating the original styling, LibreChat gives you the ability to integrate multiple AI models. It also integrates and enhances original client features such as conversation and message search, prompt templates and plugins.

With LibreChat, you no longer need to opt for ChatGPT Plus and can instead use free or pay-per-call APIs. We welcome contributions, cloning, and forking to enhance the capabilities of this advanced chatbot platform.

<p align="center">
  <iframe 
    width="1000" 
    height="500" 
    src="https://www.youtube.com/embed/pNIOs1ovsXw?controls=1?autoplay=1&mute=1&loop=1" 
    title="Librechat Overview" 
    frameborder="0" 
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share; loop" 
    allowfullscreen>
  </iframe>
</p>

---

## ⭐ Star History

<a href="https://star-history.com/#danny-avila/LibreChat&Date">
  <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=danny-avila/LibreChat&type=Date&theme=dark" onerror="this.src='https://api.star-history.com/svg?repos=danny-avila/LibreChat&type=Date'" />
</a>

---

## ✨ Contributors
Contributions and suggestions bug reports and fixes are welcome!
Please read the documentation before you do!

For new features, components, or extensions, please open an issue and discuss before sending a PR. 

- Join the [Discord community](https://discord.librechat.ai)

## 💖 This project exists in its current state thanks to all the people who contribute
---
<a href="https://github.com/danny-avila/LibreChat/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=danny-avila/LibreChat" />
</a>
