## Flashing ESP8266 WiFi Development Module (NodeMCU)


See [Flashing Video](https://bit.ly/esp8266flashingvideo) here.

Github page [sreenathbs.github.io/Flash-ESP8266-NodeMCU](https://sreenathbs.github.io/Flash-ESP8266-NodeMCU)

All required files are available in this [repository](http://bit.ly/esp8266flash)

## Contents

1. [Get things Ready](https://github.com/sreenathbs/Flash-ESP8266-NodeMCU#get-things-ready)
2. [Flasing ESP8266](https://github.com/sreenathbs/Flash-ESP8266-NodeMCU#flashing-process)
3. [Building Custom Firmware](https://github.com/sreenathbs/Flash-ESP8266-NodeMCU#building-custom-firmware)



## Get things Ready

Before we start, get things ready.

  * [ESP8266 WiFi Module (NodeMCU)](http://bit.ly/esp8266wifi)
  * [NodeMCU Firmware Flasher](http://bit.ly/esp8266flash)
  * [NodeMCU Flash File](http://bit.ly/esp8266flash)
  * [ESPlorer](http://bit.ly/esp8266flash) (optional - to verify)
  

## Flashing ESP8266

Here we attempt to flash the device.


1. Connect ESP8266 Module to Computer via Micro USB Cable.

  * ![1](https://image.ibb.co/fyNgWQ/1.jpg)
  
2. Open NodeMCU Firmware Flasher (32 bit or 64 bit).

  * ![2](https://image.ibb.co/dN325k/2.jpg)
  
3. Select NodeMCU Flash File in the Config tab. (only if You are doing a custom Flash. Else leave this step.)

  * ![3](https://image.ibb.co/ee1YBQ/3.jpg)
  
4. Click on Flash(F) button on the Operation tab and wait until it finish.

  * ![4](https://image.ibb.co/efDKkk/4.jpg)
  
5. Open ESPlorer to verify

  * ![5](https://image.ibb.co/gkory5/5.jpg)
  
6. Select Open on the right side window and click the reset button on the device.

  * ![6](https://image.ibb.co/nxZaQk/6.jpg)
  
7. Check the version shown on the right side window. This NodeMCU version is flashed to your device.

  * ![7](https://image.ibb.co/iJriBQ/7.jpg)
  
### The Flash file has been successfully written to your device :)



## Building Custom Firmware

Use cloud services like NodeMCU Build to build your own customized Firmware.

1. [Click here](https://nodemcu-build.com) to go to NodeMCU Build Cloud Service.

  * ![21](https://image.ibb.co/hrVh5k/21.jpg)

2. Enter your email address to receive the Firmware.

  * ![22](https://image.ibb.co/hdbN5k/22.jpg)
  
3. Select the modules to be included in the Firmware.

  * ![23](https://image.ibb.co/hJoPJ5/23.jpg)
  
4. Click on the Submit button. You will see the below page.

  * ![24](https://image.ibb.co/jswYBQ/24.jpg)
  
5. Sit back and relax. Your Firmware will be delivered to your email address in a minute.

You can also use this Firmware to flash your ESP8266 WiFi module.

#### Thank You...

For any Doubts:
  
  Sreenath B S
  
  sreenathbs97@gmail.com
  
  [fb.com/sreenathbs](https://www.facebook.com/sreenathbs)
  
  [twitter.com/sreenathbs](https://www.twitter.com/sreenathbs)
  
  [linkedin.com/in/sreenathbs](https://www.linkedin.com/in/sreenathbs)
