import fs from 'node:fs/promises';
import { fileURLToPath } from 'node:url';
import path from 'node:path';

export async function getRelativeFileContents(relativePath: string) {
  const __filename = fileURLToPath(import.meta.url);
  const __dirname = path.dirname(__filename);
  return fs.readFile(path.join(__dirname, relativePath), { encoding: 'utf8' });
}
