import { Modifier, EditorState, SelectionState } from "draft-js";

/* NOT USED at the moment, but might be valuable if we want to fix atomic block behaviour */

export default function removeBlock(editorState, blockKey) {
  let content = editorState.getCurrentContent();

  const beforeKey = content.getKeyBefore(blockKey);
  const beforeBlock = content.getBlockForKey(beforeKey);

  // Note: if the focused block is the first block then it is reduced to an
  // unstyled block with no character
  if (beforeBlock === undefined) {
    const targetRange = new SelectionState({
      anchorKey: blockKey,
      anchorOffset: 0,
      focusKey: blockKey,
      focusOffset: 1,
    });
    // change the blocktype and remove the characterList entry with the sticker
    content = Modifier.removeRange(content, targetRange, "backward");
    content = Modifier.setBlockType(content, targetRange, "unstyled");
    // TODO Investigate.
    // eslint-disable-next-line @typescript-eslint/ban-ts-comment
    // @ts-ignore
    const newState = EditorState.push(editorState, content, "remove-block");

    // force to new selection
    const newSelection = new SelectionState({
      anchorKey: blockKey,
      anchorOffset: 0,
      focusKey: blockKey,
      focusOffset: 0,
    });
    return EditorState.forceSelection(newState, newSelection);
  }

  const targetRange = new SelectionState({
    anchorKey: beforeKey,
    anchorOffset: beforeBlock.getLength(),
    focusKey: blockKey,
    focusOffset: 1,
  });

  content = Modifier.removeRange(content, targetRange, "backward");
  // TODO Investigate.
  // eslint-disable-next-line @typescript-eslint/ban-ts-comment
  // @ts-ignore
  const newState = EditorState.push(editorState, content, "remove-block");

  // force to new selection
  const newSelection = new SelectionState({
    anchorKey: beforeKey,
    anchorOffset: beforeBlock.getLength(),
    focusKey: beforeKey,
    focusOffset: beforeBlock.getLength(),
  });
  return EditorState.forceSelection(newState, newSelection);
}
