# [Draftail](https://www.draftail.org/) [<img src="https://raw.githubusercontent.com/thibaudcolas/draftail.org/main/.github/draftail-logo.svg?sanitize=true" width="90" height="90" align="right">](https://www.draftail.org/)

[![npm](https://img.shields.io/npm/v/draftail.svg)](https://www.npmjs.com/package/draftail) [![Build status](https://github.com/springload/draftail/workflows/CI/badge.svg)](https://github.com/springload/draftail/actions) [![Coverage Status](https://coveralls.io/repos/github/springload/draftail/badge.svg)](https://coveralls.io/github/springload/draftail) [![Netlify Status](https://api.netlify.com/api/v1/badges/cb4f2732-c1c5-4566-b22e-ce491f504a82/deploy-status)](https://app.netlify.com/sites/draftail-demos/deploys)

> :memo::cocktail: A configurable rich text editor built with [Draft.js](https://draftjs.org/). Check out our [demos](https://www.draftail.org/examples)!

[![Screenshot of Draftail](https://www.draftail.org/img/draftail-ui-screenshot.png)](https://www.draftail.org/)

## Features

Draftail aims for a mouse-free, keyboard-centric experience. Here are important features worth highlighting:

- Support for [keyboard shortcuts](https://www.draftail.org/docs/keyboard-shortcuts). Lots of them!
- Paste from Word. Or any other editor. It just works.
- Autolists – start a line with `-` , `*` , `1.` to create a list item.
- Shortcuts for heading levels `##`, code blocks ` ``` `, text formats `**`, and more.
- Undo / redo – until the end of times.
- Common text types: headings, paragraphs, quotes, lists.
- Common text styles: Bold, italic, and many more.
- API to build custom controls for links, images, and more.
- Compatibility with the [`draft-js-plugins`](https://www.draft-js-plugins.com) ecosystem to build more advanced extensions.

> This project adheres to [Semantic Versioning](http://semver.org/spec/v2.0.0.html), and measures performance and [code coverage](https://coveralls.io/github/springload/draftail). We also try to follow accessibility best practices (tested with [aXe](https://www.axe-core.org/)) – please [get in touch](https://github.com/springload/draftail/issues/149#issuecomment-389476151) if you can help us do better in this area.

## Documentation

- [Getting started](https://www.draftail.org/docs/getting-started)
- [API reference](https://www.draftail.org/docs/api)
- [User guide](https://www.draftail.org/docs/user-guide)
- [Getting started with extensions](https://www.draftail.org/docs/getting-started-with-extensions)

## Contributing

See anything you like in here? Anything missing? We welcome all support, whether on bug reports, feature requests, code, design, reviews, tests, documentation, and more. Please have a look at our [contribution guidelines](docs/CONTRIBUTING.md).

If you just want to set up the project on your own computer, the contribution guidelines also contain all of the setup commands.

## Credits

Draftail is made possible by the work of [Springload](https://github.com/springload/). View the full list of [contributors](https://github.com/springload/draftail/graphs/contributors). [MIT](LICENSE) licensed. The [draftail.org](https://github.com/thibaudcolas/draftail.org) documentation and demos are powered by [Netlify](https://www.netlify.com/).
