package cn.edu.whut.springbear.course.common.model.pojo.vod;

import cn.edu.whut.springbear.course.common.model.pojo.base.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author Spring-_-Bear
 * @datetime 2022-10-18 19:34
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(description = "VideoVisitor")
@TableName("video_visitor")
public class VideoVisitor extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "课程 id")
    @TableField("course_id")
    private Long courseId;

    @ApiModelProperty(value = "视频 id")
    @TableField("video_id")
    private Long videoId;

    @ApiModelProperty(value = "来访者用户 id")
    @TableField("user_id")
    private Long userId;

    @ApiModelProperty(value = "昵称")
    @TableField("nick_name")
    private String nickName;

    @ApiModelProperty(value = "进入时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("join_time")
    private Date joinTime;

    @ApiModelProperty(value = "离开的时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("leave_time")
    private Date leaveTime;

    @ApiModelProperty(value = "用户停留的时间(单位：秒)")
    @TableField("duration")
    private Long duration;
}