import React from 'react';
import styled from 'styled-components';
import { ComponentStory, ComponentMeta } from '@storybook/react';
import {
    Accessibility,
    Alert,
    Alien,
    Analytics,
    AR,
    Arrange,
    ArrowBackUp,
    ArrowDown,
    ArrowLeft,
    ArrowRight,
    ArrowUp,
    Art,
    Avatar,
    Award,
    Ban,
    Billing,
    Bookmark,
    Brush,
    Business,
    Camera,
    Card,
    Cart,
    Check,
    Close,
    Collection,
    Concert,
    ConnectedWallets,
    ConnectNewWallet,
    Copy,
    Crypto,
    Delete,
    Desktop,
    Digital,
    Document,
    Done,
    Dots,
    Download,
    DragPoint,
    DropDown,
    DropLeft,
    DropRight,
    DropUp,
    Edit,
    Empty,
    Error,
    Events,
    ExternalLink,
    EyeClose,
    EyeOpen,
    Fashion,
    Feed,
    Filter,
    Friends,
    FriendsAdd,
    FriendsList,
    FriendsRequests,
    Fullscreen,
    Ghost,
    GoProView,
    Heart,
    Help,
    Home,
    Image,
    Influence,
    Info,
    Lab,
    Link,
    ListIcons,
    ListLinks,
    Login,
    Logout,
    Media,
    Meetup,
    Menu,
    Messages,
    Mic,
    MicOff,
    Minus,
    Mobile,
    Model,
    NFT,
    Notifications,
    Orders,
    OrdersList,
    Pause,
    Pen,
    Phygital,
    Physical,
    Play,
    Plus,
    ProductCode,
    Products,
    Profile,
    Promote,
    QRCode,
    Refresh,
    Retail,
    ReturnAndRefund,
    Scene,
    ScreenShare,
    Search,
    Security,
    Selector,
    Send,
    Settings,
    Share,
    Show,
    Smile,
    Space,
    SpaceCollection,
    Spaces,
    Sport,
    Star,
    Subscription,
    Support,
    Table,
    Ticket,
    Transfer,
    Upload,
    User,
    Video,
    VolumeFull,
    VolumeOff,
    Wallet,
    Wand,
    World,
} from '../../icons';

const icons = [
    Accessibility,
    Alert,
    Alien,
    Analytics,
    AR,
    Arrange,
    ArrowBackUp,
    ArrowDown,
    ArrowLeft,
    ArrowRight,
    ArrowUp,
    Art,
    Avatar,
    Award,
    Ban,
    Billing,
    Bookmark,
    Brush,
    Business,
    Camera,
    Card,
    Cart,
    Check,
    Close,
    Collection,
    Concert,
    ConnectedWallets,
    ConnectNewWallet,
    Copy,
    Crypto,
    Delete,
    Desktop,
    Digital,
    Document,
    Done,
    Dots,
    Download,
    DragPoint,
    DropDown,
    DropLeft,
    DropRight,
    DropUp,
    Edit,
    Empty,
    Error,
    Events,
    ExternalLink,
    EyeClose,
    EyeOpen,
    Fashion,
    Feed,
    Filter,
    Friends,
    FriendsAdd,
    FriendsList,
    FriendsRequests,
    Fullscreen,
    Ghost,
    GoProView,
    Heart,
    Help,
    Home,
    Image,
    Influence,
    Info,
    Lab,
    Link,
    ListIcons,
    ListLinks,
    Login,
    Logout,
    Media,
    Meetup,
    Menu,
    Messages,
    Mic,
    MicOff,
    Minus,
    Mobile,
    Model,
    NFT,
    Notifications,
    Orders,
    OrdersList,
    Pause,
    Pen,
    Phygital,
    Physical,
    Play,
    Plus,
    ProductCode,
    Products,
    Profile,
    Promote,
    QRCode,
    Refresh,
    Retail,
    ReturnAndRefund,
    Scene,
    ScreenShare,
    Search,
    Security,
    Selector,
    Send,
    Settings,
    Share,
    Show,
    Smile,
    Space,
    SpaceCollection,
    Spaces,
    Sport,
    Star,
    Subscription,
    Support,
    Table,
    Ticket,
    Transfer,
    Upload,
    User,
    Video,
    VolumeFull,
    VolumeOff,
    Wallet,
    Wand,
    World,
];

const IconsGrid = styled.div`
    display: flex;
    align-items: center;
    gap: 2rem;
    flex-wrap: wrap;
`

interface IconsTemplateProps {
    fill: string;
    stroke: string;
    height: number;
    width: number;
    viewBox: string;
}

const IconsTemplate = ({ fill, stroke, height, width, viewBox }: IconsTemplateProps) => (
    <IconsGrid>
        {
            icons.map((icon, index) => (
                <div key={index}>
                    {icon({ fill, stroke, height, width, viewBox })}
                </div>
            ))
        }
    </IconsGrid>
);

export default {
    title: 'Example/Icons',
    component: IconsTemplate,
    argTypes: {
        fill: {
            control: { type: 'color' },
        },
        stroke: {
            control: { type: 'color' },
        },
        height: {
            control: { type: 'number' },
        },
        width: {
            control: { type: 'number' },
        },
        viewBox: {
            control: { type: 'text' },
        }
    },
} as ComponentMeta<typeof IconsTemplate>;

const Template: ComponentStory<typeof IconsTemplate> = (args) => <IconsTemplate {...args} />;

export const Default = Template.bind({});
Default.args = {
    fill: null,
    stroke: null,
    height: 24,
    width: 24,
    viewBox: '0 0 24 24',
};
Default.parameters = {
    controls: {
        exclude: ['as', 'css'],
    },
};
