# GPT Vision

如果你已经拥有了 Azure GPT4 Vision，并且想要使用 OpenAI API 的接口格式来进行调用，我们可以在使用 `azure` 服务类型时，设置 `AZURE_VISION` 的数值为 `true|1|on|yes` 任意值，激活 Vision API。

```bash
AZURE_VISION=true
```

调用方法很简单，除了使用 SDK 之外，同样可以使用 `curl`：

```bash
curl -v http://127.0.0.1:8080/v1/chat/completions \
    -H "Content-Type: application/json" \
    -H "Authorization: Bearer 123" \
    -d '{
        "model": "gpt-4v",
        "messages":[
          {"role":"system","content":"You are a helpful assistant."},
          {"role":"user","content":[
            {"type":"text","text":"Describe this picture:"},
            { "type": "image_url", "image_url": { "url": "https://learn.microsoft.com/azure/ai-services/computer-vision/media/quickstarts/presentation.png", "detail": "high" }}
          ]}
        ]
    }'
```

当然，你也可以将本地的图片 Base64 处理后，再调用中进行传递：

```bash
curl -v http://127.0.0.1:8080/v1/chat/completions \
    -H "Content-Type: application/json" \
    -H "Authorization: Bearer 123" \
    -d '{
        "model": "gpt-4v", 
        "messages":[
          {"role":"system","content":"You are a helpful assistant."},
          {"role":"user","content":[
            {"type":"text","text":"Describe this picture:"},
            { "type": "image_url", "image_url": { "url": "data:image/jpeg;base64,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", "detail": "high" }}
          ]}
        ]
      }'
```