;Exercise 5.10: Design a new syntax for register-machine instructions and modify the simulator to use your new syntax. Can you implement your new syntax without changing any part of the simulator except the syntax procedures in this section?
(load "/Users/soulomoon/git/SICP/Chapter5/ch5-regsim.scm")
(define (print x)
  (newline )
  (display x)
  (newline ))
(define (make-execution-procedure inst labels machine
                                  pc flag stack ops)
  (cond ((eq? (car inst) 'assign)
         (make-assign inst machine labels ops pc))
        ((eq? (car inst) 'test)
         (make-test inst machine labels ops flag pc))
        ((eq? (car inst) 'branch)
         (make-branch inst machine labels flag pc))
        ((eq? (car inst) 'goto)
         (make-goto inst machine labels pc))
        ((eq? (car inst) 'save)
         (make-save inst machine stack pc))
        ((eq? (car inst) 'restore)
         (make-restore inst machine stack pc))
        ((eq? (car inst) 'perform)
         (make-perform inst machine labels ops pc))
        ((eq? (car inst) 'exchange)
         (make-exchange inst machine stack pc))
        (else (error "Unknown instruction type -- ASSEMBLE"
                     inst))))
(define (make-exchange inst machine stack pc)
  (let ((first-target (get-register machine (first-exchange-reg-name inst)))
        (second-target (get-register machine (second-exchange-reg-name inst))))
        (lambda ()
          (push stack (get-contents first-target))
          (push stack (get-contents second-target))
          (set-contents! first-target (pop stack))
          (set-contents! second-target (pop stack))
          (advance-pc pc))))
(define (exchange-get-helper exp)
  (if (tagged-list? exp 'reg)
      (cadr exp)
      (error "exchange-get-helper : not a reg! : exp")))

(define (first-exchange-reg-name inst)
  (exchange-get-helper (cadr inst)))

(define (second-exchange-reg-name inst)
  (exchange-get-helper (caddr inst)))

(define go-machine
  (make-machine
    '(a b)
    (list (list 'print print))
    '(
      (assign a (const 1))
      (assign b (const 2))
      (perform (op print) (reg a))
      (perform (op print) (reg b))
      (exchange (reg a) (reg b))
      (perform (op print) (reg a))
      (perform (op print) (reg b))
    )))
  (start go-machine)
