; Exercise 4.78: Redesign the query language as a nondeterministic program to be implemented using the evaluator of 4.3, rather than as a stream process. In this approach, each query will produce a single answer (rather than the stream of all answers) and the user can type try-again to see more answers. You should find that much of the mechanism we built in this section is subsumed by nondeterministic search and backtracking. You will probably also find, however, that your new query language has subtle differences in behavior from the one implemented here. Can you find examples that illustrate this difference?
; it turns out that I use continuation style to finish this work rather than simply using amb syntax,
; which add me a lot of work to do, but I learned a lot when impelementing query evaluater in continuation style.

; 4.4.4.1The Driver Loop and Instantiation

(define (make-table)
  (let ((local-table (list '*table*)))
    (define (lookup key-1 key-2)
      (let ((subtable (assoc key-1 (cdr local-table))))
        (if subtable
            (let ((record (assoc key-2 (cdr subtable))))
              (if record
                  (cdr record)
                  false))
            false)))
    (define (insert! key-1 key-2 value)
      (let ((subtable (assoc key-1 (cdr local-table))))
        (if subtable
            (let ((record (assoc key-2 (cdr subtable))))
              (if record
                  (set-cdr! record value)
                  (set-cdr! subtable
                            (cons (cons key-2 value)
                                  (cdr subtable)))))
            (set-cdr! local-table
                      (cons (list key-1
                                  (cons key-2 value))
                            (cdr local-table)))))
      'ok)    
    (define (dispatch m)
      (cond ((eq? m 'lookup-proc) lookup)
            ((eq? m 'insert-proc!) insert!)
            (else (error "Unknown operation -- TABLE" m))))
    dispatch))

;;;; From instructor's manual
(define operation-table (make-table))

(define get (operation-table 'lookup-proc))

(define put (operation-table 'insert-proc!))

(define (instantiate 
         exp frame unbound-var-handler)
  (define (copy exp)
    (cond ((var? exp)
           (let ((binding 
                  (binding-in-frame 
                   exp frame)))
             (if binding
                 (copy 
                  (binding-value binding))
                 (unbound-var-handler 
                  exp frame))))
          ((pair? exp)
           (cons (copy (car exp)) 
                 (copy (cdr exp))))
          (else exp)))
  (copy exp))

(define (qanalyze query)
  (let ((qanalyze (get (type query) 'qeval)))
    (if qanalyze
        (qanalyze (contents query))
        (analyze-simple-query query))))

; 4.4.4.2The Evaluator
(define (qeval query frame succeed fail)
  ((qanalyze query) frame succeed fail))

; Simple queries
(define (analyze-simple-query query-pattern)
  ; analyze each
  (let ((assertion-proc (analyze-find-assertions query-pattern))
        (rule-proc (analyze-apply-rules query-pattern)))
        ; try assertion if fail then rule 
        (lambda (frame succeed fail)
                (assertion-proc 
                  frame 
                  succeed
                  (lambda () (rule-proc frame succeed fail))))))

; Compound queries
(define (analyze-conjoin conjuncts)
  (lambda (frame succeed fail)
    (if (empty-conjunction? conjuncts)
        (succeed frame fail)
        (qeval 
          (first-conjunct conjuncts)
          frame
          (lambda (frame2 fail2)
                  ((analyze-conjoin (cdr conjuncts))
                    frame2
                    succeed
                    fail2))
          fail))))
(put 'and 'qeval analyze-conjoin)

(define (analyze-disjoin disjuncts)
  (lambda (frame succeed fail)
    (if (empty-disjunction? disjuncts)
        (fail)
        (qeval 
          (first-conjunct disjuncts)
          frame
          succeed
          ; (lambda (frame2 fail2) 
          ;   (succeed 
          ;     frame2 
          ;     (lambda () 
          ;             ((analyze-disjoin (cdr disjuncts))
          ;                 frame
          ;                 succeed
          ;                 fail2
          ;                 ))))
          ; fail
          (lambda ()
                  ((analyze-disjoin (cdr disjuncts))
                    frame
                    succeed
                    fail))
          ))))
(put 'or 'qeval analyze-disjoin)

; Filters
(define (analyze-negate operands)
   (lambda (frame succeed fail)
      (qeval (negated-query operands)
             frame
            ;  hack here to track back to the recent analyzed use (fail) directly
             (lambda (frame fail2) (fail))
             (lambda () (succeed frame fail)))))
(put 'not 'qeval analyze-negate)
; always-true in pass-continueation style
(define (always-true ignore) 
  (lambda (frame succeed fail)
          (succeed frame fail)))
(put 'always-true 'qeval always-true)

(define (analyze-lisp-value call)
  (lambda (frame succeed fail)
     (if (execute
          (instantiate
           call
           frame
           (lambda (v f)
             (error 
              "Unknown pat var: LISP-VALUE" 
              v))))
         (succeed frame fail)
         (fail))))
(put 'lisp-value 'qeval analyze-lisp-value)
; 4.4.4.3Finding Assertions by Pattern Matching
; similar to analyze-amb
(define (analyze-find-assertions pattern)
  (let ((fetch-proc (analyze-fetch-assertions pattern)))
    (lambda (frame succeed fail)
      (fetch-proc
        (lambda (assertion fail2) 
          (check-an-assertion assertion pattern frame succeed fail2))
        fail))))

(define (check-an-assertion assertion query-pat query-frame succeed fail)
  (let ((match-result
         (pattern-match 
          query-pat assertion query-frame)))
    (if (eq? match-result 'failed)
        (fail)
        (succeed match-result fail))))

(define (pattern-match pat dat frame)
  (cond ((eq? frame 'failed) 'failed)
        ((equal? pat dat) frame)
        ((var? pat) 
         (extend-if-consistent 
          pat dat frame))
        ((and (pair? pat) (pair? dat))
         (pattern-match 
          (cdr pat) 
          (cdr dat)
          (pattern-match
           (car pat) (car dat) frame)))
        (else 'failed)))

(define (extend-if-consistent var dat frame)
  (let ((binding (binding-in-frame var frame)))
    (if binding
        (pattern-match 
         (binding-value binding) dat frame)
        (extend var dat frame))))

; 4.4.4.4Rules and Unification
(define (analyze-apply-rules pattern)
  (let ((rule-proc (analyze-fetch-rules pattern)))
    (lambda (frame succeed fail)
      (rule-proc 
        (lambda (rule fail2)
          (apply-a-rule rule pattern frame succeed fail2))
        fail))))

(define (apply-a-rule rule query-pattern query-frame succeed fail)
  (let ((clean-rule 
         (rename-variables-in rule)))
    (let ((unify-result
           (unify-match query-pattern
                        (conclusion clean-rule)
                        query-frame)))
      (if (eq? unify-result 'failed)
          (fail)
          (qeval (rule-body clean-rule) unify-result succeed fail)))))

(define (rename-variables-in rule)
  (let ((rule-application-id 
         (new-rule-application-id)))
    (define (tree-walk exp)
      (cond ((var? exp)
             (make-new-variable 
              exp 
              rule-application-id))
            ((pair? exp)
             (cons (tree-walk (car exp))
                   (tree-walk (cdr exp))))
            (else exp)))
    (tree-walk rule)))

(define (unify-match p1 p2 frame)
  (cond ((eq? frame 'failed) 'failed)
        ((equal? p1 p2) frame)
        ((var? p1)
         (extend-if-possible p1 p2 frame))
        ((var? p2)
         (extend-if-possible 
          p2 
          p1 
          frame))        ; ***
        ((and (pair? p1) 
              (pair? p2))
         (unify-match 
          (cdr p1) 
          (cdr p2)
          (unify-match 
           (car p1)
           (car p2)
           frame)))
        (else 'failed)))

(define (extend-if-possible var val frame)
  (let ((binding (binding-in-frame var frame)))
    (cond (binding
           (unify-match
            (binding-value binding) val frame))
          ((var? val)                   ; ***
           (let ((binding 
                  (binding-in-frame 
                   val
                   frame)))
             (if binding
                 (unify-match
                  var 
                  (binding-value binding) 
                  frame)
                 (extend var val frame))))
          ((depends-on? val var frame)  ; ***
           'failed)
          (else (extend var val frame)))))

(define (depends-on? exp var frame)
  (define (tree-walk e)
    (cond ((var? e)
           (if (equal? var e)
               true
               (let
                 ((b (binding-in-frame 
                      e 
                      frame)))
                  (if b
                      (tree-walk 
                       (binding-value b))
                      false))))
          ((pair? e)
           (or (tree-walk (car e))
               (tree-walk (cdr e))))
          (else false)))
  (tree-walk exp))

; 4.4.4.5Maintaining the Data Base
(define THE-ASSERTIONS the-empty-stream)

; continuesly fetching 
(define (analyze-fetch-assertions pattern)
  (let ((assertions
          (if (use-index? pattern)
              (get-indexed-assertions pattern)
              (get-all-assertions))))
  (lambda (succeed fail)
    (define (try-next choices)
      (if (null? choices)
          (fail)
          (succeed (stream-car choices) 
                  (lambda () (try-next (stream-cdr choices))))))
    (try-next assertions))))

(define (get-all-assertions) THE-ASSERTIONS)

(define (get-indexed-assertions pattern)
  (get-stream (index-key-of pattern)
              'assertion-stream))

(define (get-stream key1 key2)
  (let ((s (get key1 key2)))
    (if s s the-empty-stream)))

(define THE-RULES the-empty-stream)

(define (analyze-fetch-rules pattern)
  (let ((rules
          (if (use-index? pattern)
              (get-indexed-rules pattern)
              (get-all-rules))))
    (lambda (succeed fail)
    (define (try-next choices)
      (if (null? choices)
          (fail)
          (succeed (stream-car choices) 
                  (lambda () (try-next (stream-cdr choices))))))
    (try-next rules))))

(define (get-all-rules) THE-RULES)

(define (get-indexed-rules pattern)
  (stream-append
   (get-stream (index-key-of pattern)
               'rule-stream)
   (get-stream '? 'rule-stream)))


(define (add-rule-or-assertion! assertion)
  (if (rule? assertion)
      (add-rule! assertion)
      (add-assertion! assertion)))

(define (add-assertion! assertion)
  (store-assertion-in-index assertion)
  (let ((old-assertions THE-ASSERTIONS))
    (set! THE-ASSERTIONS
          (cons-stream assertion 
                       old-assertions))
    'ok))

(define (add-rule! rule)
  (store-rule-in-index rule)
  (let ((old-rules THE-RULES))
    (set! THE-RULES
          (cons-stream rule old-rules))
    'ok))

(define (store-assertion-in-index assertion)
  (if (indexable? assertion)
      (let ((key (index-key-of assertion)))
        (let ((current-assertion-stream
               (get-stream 
                key 'assertion-stream)))
          (put key
               'assertion-stream
               (cons-stream 
                assertion
                current-assertion-stream))))))

(define (store-rule-in-index rule)
  (let ((pattern (conclusion rule)))
    (if (indexable? pattern)
        (let ((key (index-key-of pattern)))
          (let ((current-rule-stream
                 (get-stream 
                  key 'rule-stream)))
            (put key
                 'rule-stream
                 (cons-stream 
                  rule
                  current-rule-stream)))))))

(define (store-assertion-in-index assertion)
  (if (indexable? assertion)
      (let ((key (index-key-of assertion)))
        (let ((current-assertion-stream
               (get-stream 
                key 'assertion-stream)))
          (put key
               'assertion-stream
               (cons-stream 
                assertion
                current-assertion-stream))))))

(define (store-rule-in-index rule)
  (let ((pattern (conclusion rule)))
    (if (indexable? pattern)
        (let ((key (index-key-of pattern)))
          (let ((current-rule-stream
                 (get-stream 
                  key 'rule-stream)))
            (put key
                 'rule-stream
                 (cons-stream 
                  rule
                  current-rule-stream)))))))
                  
(define (indexable? pat)
  (or (constant-symbol? (car pat))
      (var? (car pat))))

(define (index-key-of pat)
  (let ((key (car pat)))
    (if (var? key) '? key)))

(define (use-index? pat)
  (constant-symbol? (car pat)))

(define (stream-append-delayed s1 delayed-s2)
  (if (stream-null? s1)
      (force delayed-s2)
      (cons-stream
       (stream-car s1)
       (stream-append-delayed (stream-cdr s1)
                              delayed-s2))))

(define (interleave-delayed s1 delayed-s2)
  (if (stream-null? s1)
      (force delayed-s2)
      (cons-stream
       (stream-car s1)
       (interleave-delayed 
        (force delayed-s2)
        (delay (stream-cdr s1))))))

(define (stream-flatmap proc s)
  (flatten-stream (stream-map proc s)))

(define (flatten-stream stream)
  (if (stream-null? stream)
      the-empty-stream
      (interleave-delayed
       (stream-car stream)
       (delay (flatten-stream
               (stream-cdr stream))))))

(define (singleton-stream x)
  (cons-stream x the-empty-stream))

(define (type exp)
  (if (pair? exp)
      (car exp)
      (error "Unknown expression TYPE"
             exp)))

(define (contents exp)
  (if (pair? exp)
      (cdr exp)
      (error "Unknown expression CONTENTS"
             exp)))

(define (assertion-to-be-added? exp)
  (eq? (type exp) 'assert!))

(define (add-assertion-body exp)
  (car (contents exp)))

(define (empty-conjunction? exps) (null? exps))
(define (first-conjunct exps) (car exps))
(define (rest-conjuncts exps) (cdr exps))
(define (empty-disjunction? exps) (null? exps))
(define (first-disjunct exps) (car exps))
(define (rest-disjuncts exps) (cdr exps))
(define (negated-query exps) (car exps))
(define (predicate exps) (car exps))
(define (args exps) (cdr exps))

(define (rule? statement)
  (tagged-list? statement 'rule))

(define (conclusion rule) (cadr rule))

(define (rule-body rule)
  (if (null? (cddr rule))
      '(always-true)
      (caddr rule)))

(define (query-syntax-process exp)
  (map-over-symbols expand-question-mark exp))

(define (map-over-symbols proc exp)
  (cond ((pair? exp)
         (cons (map-over-symbols 
                proc (car exp))
               (map-over-symbols 
                proc (cdr exp))))
        ((symbol? exp) (proc exp))
        (else exp)))

(define (expand-question-mark symbol)
  (let ((chars (symbol->string symbol)))
    (if (string=? (substring chars 0 1) "?")
        (list '? (string->symbol
                  (substring
                   chars 
                   1 
                   (string-length chars))))
        symbol)))

(define (var? exp) (tagged-list? exp '?))
(define (constant-symbol? exp) (symbol? exp))

(define rule-counter 0)

(define (new-rule-application-id)
  (set! rule-counter (+ 1 rule-counter))
  rule-counter)

(define (make-new-variable 
         var rule-application-id)
  (cons '? (cons rule-application-id
                 (cdr var))))

(define (contract-question-mark variable)
  (string->symbol
   (string-append "?"
     (if (number? (cadr variable))
         (string-append
          (symbol->string (caddr variable))
          "-"
          (number->string (cadr variable)))
         (symbol->string (cadr variable))))))

(define (make-binding variable value)
  (cons variable value))

(define (binding-variable binding)
  (car binding))

(define (binding-value binding)
  (cdr binding))

(define (binding-in-frame variable frame)
  (assoc variable frame))

(define (extend variable value frame)
  (cons (make-binding variable value) frame))

(define (display-stream s)
  (stream-for-each display-line s))

(define (stream-map proc s)
  (if (stream-null? s)
      the-empty-stream
      (cons-stream (proc (stream-car s))
                   (stream-map proc (stream-cdr s)))))
(define (stream-car stream) 
  (car stream))

(define (stream-cdr stream) 
  (force (cdr stream)))
(define (stream-for-each proc s)
  (if (stream-null? s)
      (display-line "")
      (begin (proc (stream-car s))
             (stream-for-each proc (stream-cdr s)))))

(define (display-line x)
  (newline)
  (display x))
(define (tagged-list? exp tag)
  (if (pair? exp)
      (eq? (car exp) tag)
      false))
(define (stream-append s1 s2)
  (if (stream-null? s1)
      s2
      (cons-stream (stream-car s1)
                   (stream-append (stream-cdr s1) s2))))
(define (stream-filter pred stream)
  (cond ((stream-null? stream) the-empty-stream)
        ((pred (stream-car stream))
         (cons-stream (stream-car stream)
                      (stream-filter pred
                                     (stream-cdr stream))))
        (else (stream-filter pred (stream-cdr stream)))))

; for lisp-value
(load "/Users/soulomoon/git/SICP/Chapter4/ch4-query-mceval.rkt")

(define user-initial-environment (setup-environment))
(define (execute exp)
  (apply# (eval# (predicate exp) user-initial-environment)
         (args exp)))

(define input-prompt  ";;; Amb-Eval input:")
(define output-prompt ";;; Amb-Eval value:")
(define (prompt-for-input string)
  (newline) (newline) (display string) (newline))
(define (announce-output string)
  (newline) (display string) (newline))
(define (user-print object)
      (display object))
(define (i query)
  (define (internal-loop try-again)
    (prompt-for-input input-prompt)
    (if (null? query)
      'end
      (let ((input (car query)))
        (display input)
        (set! query (cdr query))
        (if (eq? input 'try-again)
            (try-again)
            (let ((q (query-syntax-process input)))
              (begin
                (newline)
                (display 
                ";;; Starting a new problem ")
                input
                (qeval
                  q
                  '()
                  ;; ambeval success
                  (lambda (frame next-alternative)
                    (announce-output output-prompt)
                    (user-print 
                      (instantiate
                        q
                        frame
                        (lambda (v f)
                          (contract-question-mark v))))
                    (internal-loop next-alternative))
                  ;; ambeval failure
                  (lambda ()
                    (announce-output
                      ";;; There are no more values of")
                    (user-print input)
                    (internal-loop try-again)
                    ))))))))
  (internal-loop
   (lambda ()
     (newline)
     (display 
      ";;; There is no current problem")
     (i query))))

(define (list->stream l)
  (if (null? l)
      the-empty-stream
      (cons-stream (car l) (list->stream (cdr l)))))

(define (initialize-data-base rules-and-assertions)
  (define (deal-out r-and-a rules assertions)
    (cond ((null? r-and-a)
           (set! THE-ASSERTIONS (list->stream assertions))
           (set! THE-RULES (list->stream rules))
           'done)
          (else
           (let ((s (query-syntax-process (car r-and-a))))
             (cond ((rule? s)
                    (store-rule-in-index s)
                    (deal-out (cdr r-and-a)
                              (cons s rules)
                              assertions))
                   (else
                    (store-assertion-in-index s)
                    (deal-out (cdr r-and-a)
                              rules
                              (cons s assertions))))))))
  ; (let ((operation-table (make-table)))
  ;   (set! get (operation-table 'lookup-proc))
  ;   (set! put (operation-table 'insert-proc!)))
  ; (put 'and 'qeval conjoin)
  ; (put 'or 'qeval disjoin)
  ; (put 'not 'qeval negate)
  ; (put 'lisp-value 'qeval lisp-value)
  ; (put 'always-true 'qeval always-true)
  (deal-out rules-and-assertions '() '()))

(define microshaft-data-base
  '(
;; from section 4.4.1
(address (Bitdiddle Ben) (Slumerville (Ridge Road) 10))
(job (Bitdiddle Ben) (computer wizard))
(salary (Bitdiddle Ben) 60000)

(address (Hacker Alyssa P) (Cambridge (Mass Ave) 78))
(job (Hacker Alyssa P) (computer programmer))
(salary (Hacker Alyssa P) 40000)
(supervisor (Hacker Alyssa P) (Bitdiddle Ben))

(address (Fect Cy D) (Cambridge (Ames Street) 3))
(job (Fect Cy D) (computer programmer))
(salary (Fect Cy D) 35000)
(supervisor (Fect Cy D) (Bitdiddle Ben))

(address (Tweakit Lem E) (Boston (Bay State Road) 22))
(job (Tweakit Lem E) (computer technician))
(salary (Tweakit Lem E) 25000)
(supervisor (Tweakit Lem E) (Bitdiddle Ben))

(address (Reasoner Louis) (Slumerville (Pine Tree Road) 80))
(job (Reasoner Louis) (computer programmer trainee))
(salary (Reasoner Louis) 30000)
(supervisor (Reasoner Louis) (Hacker Alyssa P))

(supervisor (Bitdiddle Ben) (Warbucks Oliver))

(address (Warbucks Oliver) (Swellesley (Top Heap Road)))
(job (Warbucks Oliver) (administration big wheel))
(salary (Warbucks Oliver) 150000)

(address (Scrooge Eben) (Weston (Shady Lane) 10))
(job (Scrooge Eben) (accounting chief accountant))
(salary (Scrooge Eben) 75000)
(supervisor (Scrooge Eben) (Warbucks Oliver))

(address (Cratchet Robert) (Allston (N Harvard Street) 16))
(job (Cratchet Robert) (accounting scrivener))
(salary (Cratchet Robert) 18000)
(supervisor (Cratchet Robert) (Scrooge Eben))

(address (Aull DeWitt) (Slumerville (Onion Square) 5))
(job (Aull DeWitt) (administration secretary))
(salary (Aull DeWitt) 25000)
(supervisor (Aull DeWitt) (Warbucks Oliver))

(can-do-job (computer wizard) (computer programmer))
(can-do-job (computer wizard) (computer technician))

(can-do-job (computer programmer)
            (computer programmer trainee))

(can-do-job (administration secretary)
            (administration big wheel))

(rule (lives-near ?person-1 ?person-2)
      (and (address ?person-1 (?town . ?rest-1))
           (address ?person-2 (?town . ?rest-2))
           (not (same ?person-1 ?person-2))))

(rule (same ?x ?x))

(rule (wheel ?person)
      (and (supervisor ?middle-manager ?person)
           (supervisor ?x ?middle-manager)))

(rule (outranked-by ?staff-person ?boss)
      (or (supervisor ?staff-person ?boss)
          (and (supervisor ?staff-person ?middle-manager)
               (outranked-by ?middle-manager ?boss))))
))

;; Do following to reinit the data base from microshaft-data-base
;;  in Scheme (not in the query driver loop)
(define (setup-data-base)
  (initialize-data-base microshaft-data-base))

(setup-data-base)

; i could not but able to interleave or in the old way, 
; because in continueation style, one disjoin have to be run out to get to the next.
; because you can not dectest the first fail has come to an end to interleave it with the second one,
; so you have to place the second fail in the begin and wait it run out then get the the first one.

; somthing is interesting that , if you use try-again to find out alternative , it would actually trace back to the last query alternative, if the newest run out 
(i
'(
  (or (supervisor ?x ?y)
      (job ?z ?g))
  (and (lives-near ?x ?y)
       (job ?x ?k)
       (not (job ?x (computer ?z))))
    (or (supervisor ?x ?y)
      (job ?z ?g))

  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
  try-again
))

; Welcome to DrRacket, version 6.7 [3m].
; Language: SICP (PLaneT 1.18); memory limit: 2048 MB.
; 'ok
; 'ok
; 'ok
; 'ok
; 'ok
; 'done


; ;;; Amb-Eval input:
; (or (supervisor ?x ?y) (job ?z ?g))
; ;;; Starting a new problem 
; ;;; Amb-Eval value:
; (or (supervisor (Aull DeWitt) (Warbucks Oliver)) (job ?z ?g))

; ;;; Amb-Eval input:
; (and (lives-near ?x ?y) (job ?x ?k) (not (job ?x (computer ?z))))
; ;;; Starting a new problem 
; ;;; Amb-Eval value:
; (and (lives-near (Aull DeWitt) (Reasoner Louis)) (job (Aull DeWitt) (administration secretary)) (not (job (Aull DeWitt) (computer ?z))))

; ;;; Amb-Eval input:
; (or (supervisor ?x ?y) (job ?z ?g))
; ;;; Starting a new problem 
; ;;; Amb-Eval value:
; (or (supervisor (Aull DeWitt) (Warbucks Oliver)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Cratchet Robert) (Scrooge Eben)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Scrooge Eben) (Warbucks Oliver)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Bitdiddle Ben) (Warbucks Oliver)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Reasoner Louis) (Hacker Alyssa P)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Tweakit Lem E) (Bitdiddle Ben)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Fect Cy D) (Bitdiddle Ben)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Hacker Alyssa P) (Bitdiddle Ben)) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Aull DeWitt) (administration secretary)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Cratchet Robert) (accounting scrivener)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Scrooge Eben) (accounting chief accountant)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Warbucks Oliver) (administration big wheel)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Reasoner Louis) (computer programmer trainee)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Tweakit Lem E) (computer technician)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Fect Cy D) (computer programmer)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Hacker Alyssa P) (computer programmer)))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor ?x ?y) (job (Bitdiddle Ben) (computer wizard)))

; ;;; Amb-Eval input:
; try-again
; ;;; There are no more values of
; (or (supervisor ?x ?y) (job ?z ?g))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (and (lives-near (Aull DeWitt) (Bitdiddle Ben)) (job (Aull DeWitt) (administration secretary)) (not (job (Aull DeWitt) (computer ?z))))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (and (lives-near (Reasoner Louis) (Aull DeWitt)) (job (Reasoner Louis) (computer programmer trainee)) (not (job (Reasoner Louis) (computer ?z))))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (and (lives-near (Reasoner Louis) (Bitdiddle Ben)) (job (Reasoner Louis) (computer programmer trainee)) (not (job (Reasoner Louis) (computer ?z))))

; ;;; Amb-Eval input:
; try-again
; ;;; There are no more values of
; (and (lives-near ?x ?y) (job ?x ?k) (not (job ?x (computer ?z))))

; ;;; Amb-Eval input:
; try-again
; ;;; Amb-Eval value:
; (or (supervisor (Cratchet Robert) (Scrooge Eben)) (job ?z ?g))

; ;;; Amb-Eval input:
; 'end
