; Exercise 3.78: Consider the problem of designing a signal-processing system to study the homogeneous second-order linear differential equation
; d2ydt2−adydt−by=0.
; d2ydt2−adydt−by=0.
; The output stream, modeling yy, is generated by a network that contains a loop. This is because the value of d2y/dt2d2y/dt2 depends upon the values of yy and dy/dtdy/dt and both of these are determined by integrating d2y/dt2d2y/dt2. The diagram we would like to encode is shown in Figure 3.35. Write a procedure solve-2nd that takes as arguments the constants aa, bb, and dtdt and the initial values y0y0 and dy0dy0 for yy and dy/dtdy/dt and generates the stream of successive values of yy.

(load "/home/soulomoon/git/SICP/Chapter3/stream.scm")

(define (integral
         delayed-integrand initial-value dt)
  (define int
    (cons-stream 
     initial-value
     (let ((integrand 
            (force delayed-integrand)))
       (add-streams 
        (scale-stream integrand dt)
        int))))
  int)


(define (solve dt y0 dy0)
  (define dy (delay (integral y dy0 dt)))
  (define y (delay (integral dy y0 dt)))
  (force y))

(define (solve-2nd a b dt y0 dy0)
  (define dy (delay (integral ddy dy0 dt)))
  (define y (delay (integral dy y0 dt)))
  (define ddy
    (delay 
      (add-streams 
        (scale-stream (force dy) (* a dt))
        (scale-stream (force y) (* b (square dt))))))
  (display (stream-ref (force y) 20))(newline )
  (display (stream-ref (force dy) 20))(newline )
  (display (stream-ref (force ddy) 20))(newline )
  (force y))

(stream-ref (solve 0.0001 1 1) 10000)
(stream-ref (solve-2nd 1 1 0.0001 1 1) 10000)

; Welcome to DrRacket, version 6.7 [3m].
; Language: SICP (PLaneT 1.18); memory limit: 128 MB.
; 2.7181459268252266
; 1.0020019013305987
; 1.0020021013307312
; 1.0021021015407319
; 2.7182230657978494
; > 