; Exercise 3.11: In 3.2.3 we saw how the environment model described the behavior of procedures with local state. Now we have seen how internal definitions work. A typical message-passing procedure contains both of these aspects. Consider the bank account procedure of 3.1.1:

(define (make-account balance)
  (define (withdraw amount)
    (if (>= balance amount)
        (begin (set! balance 
                     (- balance 
                        amount))
               balance)
        "Insufficient funds"))
  (define (deposit amount)
    (set! balance (+ balance amount))
    balance)
  (define (dispatch m)
    (cond ((eq? m 'withdraw) withdraw)
          ((eq? m 'deposit) deposit)
          (else (error "Unknown request: 
                        MAKE-ACCOUNT" 
                       m))))
  dispatch)
; Show the environment structure generated by the sequence of interactions

; (define acc (make-account 50))

; ((acc 'deposit) 40)
; 90

; ((acc 'withdraw) 60)
; 30
; Where is the local state for acc kept? Suppose we define another account

; (define acc2 (make-account 100))
; How are the local states for the two accounts kept distinct? Which parts of the environment structure are shared between acc and acc2?
              |--------------------------|
global env--> |  make-account-+          |
              |---------------|----------|
                              |      ^ 
                              |      |
                              v      |
                           [*] [*]---+ 
                            |
                            |
                            v
                 parameters:balance
                 body: (define (withdraw amount)
                         (if (>= balance amount)
                             (begin (set! balance 
                                           (- balance 
                                             amount))
                                     balance)
                             "Insufficient funds"))
                       (define (deposit amount)
                         (set! balance (+ balance amount))
                         balance)
                       (define (dispatch m)
                         (cond ((eq? m 'withdraw) withdraw)
                               ((eq? m 'deposit) deposit)
                               (else (error "Unknown request: 
                                             MAKE-ACCOUNT" 
                                             m))))
                       dispatch
 
              +--------------------------+
global env--> |                          |
              |      acc                 |
              +-------|------------------+
                      |               ^ 
                      |               |
                      |               |
     (make-account 50)|        +-------------+
                      |  e1->  | blance: 50  | 
                      |        | withdraw    | 
                      |        | deposit     |<------+  
                      +--------->dispatch---------->[*] [*]---->parameters:...
                               +-------------+                  ............
                                   ^  
                       (deposit 40)|
                                   |
                                +------------+   
                                |            |                        
                           e2 ->| amount:40  |                        
                                |            |                        
                                +------------+
                                ((acc 'deposit) 40)
                                blance