; Exercise 3.2: In software-testing applications, it is useful to be able to count the number of times a given procedure is called during the course of a computation. Write a procedure make-monitored that takes as input a procedure, f, that itself takes one input. The result returned by make-monitored is a third procedure, say mf, that keeps track of the number of times it has been called by maintaining an internal counter. If the input to mf is the special symbol how-many-calls?, then mf returns the value of the counter. If the input is the special symbol reset-count, then mf resets the counter to zero. For any other input, mf returns the result of calling f on that input and increments the counter. For instance, we could make a monitored version of the sqrt procedure:

(define (make-monitored f)
  (let ((times 0))
    (lambda (m) 
      (cond ((eq? m 'how-many-calls?) times)
            ((eq? m 'reset-acount) (set! times 0))
            (else (begin (set! times (+ 1 times)) 
                        (f m)))))))

(define s (make-monitored sqrt))

(s 100)
10

(s 'how-many-calls?)
1

(s 25)
5

(s 'how-many-calls?)
2

(s 'reset-acount)

(s 'how-many-calls?)
0


; Welcome to DrRacket, version 6.7 [3m].
; Language: SICP (PLaneT 1.18); memory limit: 128 MB.
; 10
; 10
; 1
; 1
; 5
; 5
; 2
; 2
; 0
; 0
; > 