# GOVERNANCE.md

This file documents Solidus' governance model. It is meant for all users, but particularly for:

- users who are considering Solidus and need more clarity on the people and companies behind it;
- new contributors who want to understand who's in charge of reviewing and merging their code;
- existing contributors who would like to apply for the Core Team.

## Project Director

At present, [Nebulab](https://www.nebulab.it) is the main code contributor and director of Solidus.

Project Directors are in charge of the organizational and business aspects of the platform. They handle
the social media communication and marketing/business direction, and advertise Solidus to the software
community and larger eCommerce industry. The project directors commit to hearing all interested parties
around sensitive business development decisions, although they reserve the right to always act in the
best interest of the platform and its community.

## Core Team

The Core Team is a group of individuals who are committed to maintaining the project from a
technical perspective for the long term. Their main goal is to continuously deliver value to the
community through their work and the work of all contributors.

Here are some of the tasks they are responsible for:

- implementing new features;
- identifying and fixing bugs;
- triaging issues;
- reviewing and merging pull requests;
- providing support via Slack and other channels;
- improving the documentation;
- providing technical feedback and guidance to contributors;
- coordinating the work of contributors;
- maintaining the code, documentation and tools.

Members of the core team make the final decision as to what goes into the core and any other
non-marketing material (e.g. extensions, development tools) hosted in the official Solidus
GitHub organizations, although they may delegate part of this responsibility to other entities
(e.g. a specific company may be put in charge of maintaining an extension it has originally developed).

We understand that not all members will be able to dedicate the same amount of time to Solidus: this
is absolutely okay, since Solidus is an open source project and most of the work is done on a
volunteer basis. With that said, a minimum time investment is expected out of Core Team members.

### Joining the Core Team

New Core Team members are appointed by the Core Team.

To apply for the Core Team, you must be proposed by an existing member.

If you don't know anyone, simply send a Slack DM to Alberto Vena (@kennyadsl), explaining
why you think you should be in the Core Team and what kind of contribution you expect to bring.

### Leaving the Core Team

To leave the Core Team, simply communicate your decision to the other Core Team members via Slack,
email or call.

## Donors

Like many open source projects, Solidus lives thanks to the donations of our amazing community.

In order to be completely transparent towards the community, we chose Open Collective as our
platform for collecting and spending donations. This helps us keep the project running while at the
same time keeping you informed on the latest developments and how your money is being spent.

If you're an agency, being a donor also entitles you to becoming a Solidus partner. If you're
interested, head over to the [Partners](https://solidus.io/partners/) page on our website to learn
more about partners.

### Making a donation

Making a recurring donation is very simple, simply visit
[our Open Collective profile](https://opencollective.com/solidus), choose the amount and complete
the process.

We have four different donation tiers in Open Collective, each with their own perks, so make sure
to check them out and choose the one that fits you best.

You can also use Open Collective to make a one-off donation, if you prefer!

### Interrupting a recurring donation

If you want to interrupt a recurring donation, follow
[these instructions](https://docs.opencollective.com/help/backers-and-sponsors/payment#cancel-a-subscription).

## Stakeholders

Stakeholders are members of the Solidus community who have a strong interest in the future of
Solidus. This group includes retailers, agencies and long-term friends of the project.

They coordinate with weekly meetings and contribute to Solidus usually in non-technical ways,
for instance by choosing what conferences to attend or organize, by identifying marketing
opportunities or by deciding how to use the funds in Open Collective.

The Stakeholder group, is a group made of:

- Core team members
- Project directors
- Partners
- Advisors

### Voting mechanism

Any of the stakeholders may propose a vote for spending Open Collective funds or electing a
new advisor. The proposal must be added to the meeting agenda in advance.

The following principles apply to all votes:

- Meeting attendees who are not contributing financially to Open Collective hold no voting rights,
  although they may propose votes and/or voice their opinion prior to a vote in order to provide
  context and/or to influence the stakeholders.
- One-off Open Collective contributions have no effect on an entity’s voting rights.
- An entity can only vote during stakeholder meetings after a minimum of 3 months of recurring
  Open Collective contributions.
- In order to determine the number of votes at disposal of each voting stakeholder, the average
  Open Collective contribution of the last 3 months is used.
- If a proposal’s outcome is inconclusive, the stakeholders discuss the outcome until a reasonable
  compromise is reached.
- Each entity may invite up to 3 representatives to join the stakeholders group.

### Consensus algorithms

#### Single-choice proposals

Single-choice proposals are proposals where an entity may only vote for one outcome of the request
to spend Open Collective funds. For example:

> Spend $20,000 on the venue for the next SolidusConf

> Pick a feature to implement with OC funds

> Are you in favor of adding John Doe to the advisors group?

During the meeting, the stakeholders vote on the proposal. Each entity gets one vote, and the weight
of each entity’s vote is equal to their monthly Open Collective contribution (e.g. the vote of a
company contributing $750/month on Open Collective weighs 750).

The outcome of the proposal is the outcome that received the highest number of votes.
The weight of each entity’s vote is capped at 1000, regardless of their OC contribution level.

#### Multiple-choice proposals

Multiple-choice proposals are proposals where an entity is asked to choose multiple outcomes for
a proposal. An example would be

> What features do you want to implement with Open Collective funds?

During the meeting, the stakeholders vote on the proposal. Each entity gets a number of votes equal
to their monthly Open Collective contribution, which they can spread across multiple choices or just on one choice.

In multiple-choice proposals, the N proposals with the highest number of votes are picked and prioritized
according to their number of votes. N is an arbitrary number decided upfront by the entity proposing the vote.

The number of votes at disposal of each entity is capped at 1000, regardless of their OC contribution level.

#### Asynchronous voting

If an entity doesn’t plan to attend a meeting but still wants to vote on a proposal, they can communicate their
vote(s) in the stakeholders channel on Slack.

### Joining the stakeholders

To join the stakeholders, you must be part of one of the groups described above.

### Join as Partner

Partners are individuals or companies that are financially contributing to the platform’s Open Collective organization,
in exchange for a pre-established set of benefits, mainly the ability to vote during stakeholder meetings.

To join the stakeholders group as Partner, it's just needed that you setup a monthy donation via Open Collective with any of
following partnership tiers:

- **Supporter ($10/month)**: Doesn’t guarantee access to a partnership program.
- **Bronze ($100/month)**: Guarantees access to the partnership program as a Bronze partner and, as a result, access to the stakeholders group.
- **Silver ($325/month)**: Guarantees access to the partnership program as a Silver partner and, as a result, access to the stakeholders group.
- **Gold ($750+/month)**: Guarantees access to the partnership program as a Gold partner and, as a result, access to the stakeholders group.

Once it's done, send a Slack DM to Sean Denny (@seand) to request access to the private Slack channel.

### Join as Advisor

The advisors are individuals or companies that consistently provide value to the Solidus community through their industry
experience, professional network or other means. They participate in the stakeholder meetings and other stakeholder ceremonies
with the purpose of informing the group’s decisions and the platform’s direction. Advisors hold no decisional power. They are
elected during stakeholder meetings and their status must be re-confirmed every 6 months.

If you want to be nominated as Advisor please, send a Slack DM to Sean Denny (@seand) to request membership, explaining
how you have contributed to Solidus and what value you can bring to the stakeholders.

Your request must be approved by 2/3rds of the existing stakeholders for you to become a member.

### Leaving the stakeholders

To leave the stakeholders, simply announce your decision by Slack, email or call.
