import ChartMultiAxisLine from './ChartMultiAxisLine';

export default {
  title: 'Components/UI Elements/Charts/Multi Axis Line',
  component: ChartMultiAxisLine,
  argTypes: {},

  parameters: {
    componentSubtitle: '',
  },
};

const Template = (args, { argTypes }) => ({
  props: Object.keys(argTypes),
  components: { ChartMultiAxisLine },
  data() {
    return {
      currentData: null,
    };
  },
  template:
    '<div style="width: 900px;"><ChartMultiAxisLine v-model="currentData" v-bind="$props" /></div>',
});

export const Default = Template.bind({});
Default.args = {
  id: 'lineSeries',
  chartdata: {
    labels: [
      '2021-05-02 08:35',
      '2021-05-02 08:40',
      '2021-05-02 08:45',
      '2021-05-02 08:50',
      '2021-05-02 08:55',
      '2021-05-02 09:00',
      '2021-05-02 09:05',
      '2021-05-02 09:10',
      '2021-05-02 09:15',
      '2021-05-02 09:20',
      '2021-05-02 09:25',
      '2021-05-02 09:30',
      '2021-05-02 09:35',
      '2021-05-02 09:40',
      '2021-05-02 09:45',
      '2021-05-02 09:50',
      '2021-05-02 09:55',
      '2021-05-02 10:00',
      '2021-05-02 10:05',
      '2021-05-02 10:10',
      '2021-05-02 10:15',
      '2021-05-02 10:20',
      '2021-05-02 10:25',
      '2021-05-02 10:30',
      '2021-05-02 10:35',
      '2021-05-02 10:40',
      '2021-05-02 10:45',
      '2021-05-02 10:50',
      '2021-05-02 10:55',
      '2021-05-02 11:00',
      '2021-05-02 11:05',
      '2021-05-02 11:10',
      '2021-05-02 11:15',
      '2021-05-02 11:20',
      '2021-05-02 11:25',
      '2021-05-02 11:30',
      '2021-05-02 11:35',
      '2021-05-02 11:40',
      '2021-05-02 11:45',
      '2021-05-02 11:50',
      '2021-05-02 11:55',
      '2021-05-02 12:00',
      '2021-05-02 12:05',
      '2021-05-02 12:10',
      '2021-05-02 12:15',
      '2021-05-02 12:20',
      '2021-05-02 12:25',
      '2021-05-02 12:30',
      '2021-05-02 12:35',
      '2021-05-02 12:40',
      '2021-05-02 12:45',
      '2021-05-02 12:50',
      '2021-05-02 12:55',
      '2021-05-02 13:00',
      '2021-05-02 13:05',
      '2021-05-02 13:10',
      '2021-05-02 13:15',
      '2021-05-02 13:20',
      '2021-05-02 13:25',
      '2021-05-02 13:30',
      '2021-05-02 13:35',
      '2021-05-02 13:40',
      '2021-05-02 13:45',
      '2021-05-02 13:50',
      '2021-05-02 13:55',
      '2021-05-02 14:00',
      '2021-05-02 14:05',
      '2021-05-02 14:10',
      '2021-05-02 14:15',
      '2021-05-02 14:20',
      '2021-05-02 14:25',
      '2021-05-02 14:30',
      '2021-05-02 14:35',
      '2021-05-02 14:40',
      '2021-05-02 14:45',
      '2021-05-02 14:50',
      '2021-05-02 14:55',
      '2021-05-02 15:00',
      '2021-05-02 15:05',
      '2021-05-02 15:10',
      '2021-05-02 15:15',
      '2021-05-02 15:20',
      '2021-05-02 15:25',
      '2021-05-02 15:30',
      '2021-05-02 15:35',
      '2021-05-02 15:40',
      '2021-05-02 15:45',
      '2021-05-02 15:50',
      '2021-05-02 15:55',
      '2021-05-02 16:00',
      '2021-05-02 16:05',
      '2021-05-02 16:10',
      '2021-05-02 16:15',
      '2021-05-02 16:20',
      '2021-05-02 16:25',
      '2021-05-02 16:30',
      '2021-05-02 16:35',
      '2021-05-02 16:40',
      '2021-05-02 16:45',
      '2021-05-02 16:50',
      '2021-05-02 16:55',
      '2021-05-02 17:00',
      '2021-05-02 17:05',
      '2021-05-02 17:10',
      '2021-05-02 17:15',
      '2021-05-02 17:20',
      '2021-05-02 17:25',
      '2021-05-02 17:30',
      '2021-05-02 17:35',
      '2021-05-02 17:40',
      '2021-05-02 17:45',
      '2021-05-02 17:50',
      '2021-05-02 17:55',
      '2021-05-02 18:00',
      '2021-05-02 18:05',
      '2021-05-02 18:10',
      '2021-05-02 18:15',
      '2021-05-02 18:20',
      '2021-05-02 18:25',
      '2021-05-02 18:30',
      '2021-05-02 18:35',
      '2021-05-02 18:40',
      '2021-05-02 18:45',
      '2021-05-02 18:50',
      '2021-05-02 18:55',
      '2021-05-02 19:00',
      '2021-05-02 19:05',
    ],
    datasets: [
      [
        0.06, 0.1, 0.53, 1.85, 2.53, 3.15, 3.65, 4.19, 4.59, 5.07, 5.4, 6.01,
        6.63, 7.05, 7.49, 7.93, 8.38, 8.76, 9.14, 9.5, 9.86, 10.17, 10.47,
        10.78, 11.39, 11.61, 11.71, 12.0, 12.37, 12.7, 12.94, 13.16, 13.44,
        13.64, 10.12, 7.33, 13.05, 14.56, 14.83, 14.83, 14.78, 8.14, 8.05, 8.0,
        14.99, 7.4, 7.42, 7.83, 11.04, 14.09, 7.71, 8.39, 8.51, 15.15, 16.4,
        10.57, 15.08, 16.39, 11.16, 14.17, 16.38, 16.45, 16.08, 16.17, 16.09,
        16.08, 8.29, 15.75, 15.81, 15.79, 15.65, 15.63, 15.66, 15.14, 9.44,
        15.0, 14.8, 14.64, 14.46, 14.43, 14.37, 14.28, 14.12, 14.02, 13.76,
        13.37, 13.14, 13.03, 12.82, 12.53, 12.37, 12.11, 11.85, 11.57, 11.34,
        11.12, 10.77, 10.43, 10.13, 9.82, 9.4, 9.11, 8.74, 8.47, 8.14, 7.77,
        7.43, 7.07, 6.69, 6.23, 5.91, 5.49, 5.12, 4.67, 4.28, 3.88, 3.47, 3.07,
        2.7, 2.32, 1.96, 1.62, 1.34, 1.05, 0.82, 0,
      ],
      [
        10.78, 11.39, 11.61, 11.71, 12.0, 12.37, 12.7, 12.94, 13.16, 13.44,
        0.06, 0.1, 0.53, 1.85, 2.53, 3.15, 3.65, 4.19, 4.59, 5.07, 5.4, 6.01,
        6.63, 7.05, 7.49, 7.93, 8.38, 8.76, 9.14, 9.5, 9.86, 10.17, 10.47,
        14.99, 7.4, 7.42, 7.83, 11.04, 14.09, 7.71, 8.39, 8.51, 15.15, 16.4,
        10.57, 15.08, 16.39, 11.16, 14.17, 16.38, 16.45, 16.08, 16.17, 16.09,
        16.08, 8.29, 15.75, 15.81, 15.79, 15.65, 15.63, 15.66, 15.14, 9.44,
        13.37, 13.14, 13.03, 12.82, 12.53, 12.37, 12.11, 11.85, 11.57, 11.34,
        13.64, 10.12, 7.33, 13.05, 14.56, 14.83, 14.83, 14.78, 8.14, 8.05, 8.0,
        15.0, 14.8, 14.64, 14.46, 14.43, 14.37, 14.28, 14.12, 14.02, 13.76, 2.7,
        2.32, 1.96, 1.62, 1.34, 1.05, 0.82, 0, 11.12, 10.77, 10.43, 10.13, 9.82,
        9.4, 9.11, 8.74, 8.47, 8.14, 7.77, 7.43, 7.07, 6.69, 6.23, 5.91, 5.49,
        5.12, 4.67, 4.28, 3.88, 3.47, 3.07,
      ],
      [
        13.64, 10.12, 7.33, 13.05, 14.56, 14.83, 14.83, 14.78, 8.14, 8.05, 8.0,
        6.63, 7.05, 7.49, 7.93, 8.38, 8.76, 9.14, 9.5, 9.86, 10.17, 10.47,
        10.78, 11.39, 11.61, 11.71, 12.0, 12.37, 12.7, 12.94, 13.16, 13.44,
        14.99, 7.4, 7.42, 7.83, 11.04, 14.09, 7.71, 8.39, 8.51, 15.15, 16.4,
        0.06, 0.1, 0.53, 1.85, 2.53, 3.15, 3.65, 4.19, 4.59, 5.07, 5.4, 6.01,
        10.57, 15.08, 16.39, 11.16, 14.17, 16.38, 16.45, 16.08, 16.17, 16.09,
        13.37, 13.14, 13.03, 12.82, 12.53, 12.37, 12.11, 11.85, 11.57, 11.34,
        16.08, 8.29, 15.75, 15.81, 15.79, 15.65, 15.63, 15.66, 15.14, 9.44,
        15.0, 14.8, 14.64, 14.46, 14.43, 14.37, 14.28, 14.12, 14.02, 13.76, 2.7,
        2.32, 1.96, 1.62, 1.34, 1.05, 0.82, 0, 11.12, 10.77, 10.43, 10.13, 9.82,
        9.4, 9.11, 8.74, 8.47, 8.14, 7.77, 7.43, 7.07, 6.69, 6.23, 5.91, 5.49,
        5.12, 4.67, 4.28, 3.88, 3.47, 3.07,
      ],
    ],
    type: [
      { name: 'voltage', unit: 'V' },
      { name: 'current', unit: 'A' },
      { name: 'power', unit: 'W' },
    ],

    inverter: ['test 1', 'test 2', 'test 3'],
  },
};
