import React, { useEffect, useState } from 'react';
import { Message } from '@dashy/api-interfaces';

export const App = () => {
    const [m, setMessage] = useState<Message>({ message: '' });

    useEffect(() => {
        fetch('/api-status')
            .then((r) => r.json())
            .then(setMessage);
    }, []);

    return (
        <>
            <div style={{ textAlign: 'center' }}>
                <h1>Welcome to dashy!</h1>
                <img
                    width="450"
                    src="https://raw.githubusercontent.com/nrwl/nx/master/images/nx-logo.png"
                    alt="Nx - Smart, Fast and Extensible Build System"
                />
            </div>
            <div>{m.message}</div>
        </>
    );
};

export default App;
