% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_sequence}
\alias{add_sequence}
\title{Add nucleic acid sequence of regions to metadata column}
\usage{
add_sequence(ranges, genome, name = "sequence")
}
\arguments{
\item{ranges}{GRanges object}

\item{genome}{BSgenome object or any other valid input to
`Biostrings::getSeq()` (Do `showMethods(Biostrings::getSeq)` to show valid
types)}

\item{name}{name of metadata column to hold sequence information (default:
"sequence"). Note, this will overwrite existing columns without warning if
the name already exists.}
}
\value{
`ranges` with new metadata column named "sequence" (or another value
  passed to `name`) holding the DNA or RNA sequence from `genome`
}
\description{
Add nucleic acid sequence of regions to metadata column
}
\examples{
data(example_peaks, package = "memes")
dm.genome <- BSgenome.Dmelanogaster.UCSC.dm3::BSgenome.Dmelanogaster.UCSC.dm3
add_sequence(example_peaks, dm.genome)
}
