#include <string.h>
#include <stdint.h>
#include <limits.h>

#define ALIGN (sizeof(size_t))
#define ONES ((size_t)-1/UCHAR_MAX)
#define HIGHS (ONES * (UCHAR_MAX/2+1))
#define HASZERO(x) ((x)-(ONES & ~(x) & HIGHS))

size_t strlen(const char *s)
{
	int i = 0;

	while (*s != 0) {
		i++;
		s++;
	}

	return i;

#if 0 /* Does not work */
	const char *a = s;
	const size_t *w;
	if (!*s)
		return 0;
	for (; (uintptr_t)s % ALIGN; s++) if (!*s) return s-a;
	for (w = (const void *)s; !HASZERO(*w); w++);
	for (s = (const void *)w; *s; s++);
	return s-a;
#endif
}
