/*
 * Copyright 2021 Stephan Markwalder
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jarhc.model;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertSame;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ResourceDefTest {

	@Test
	void test() {

		// prepare
		JarFile jarFile = Mockito.mock(JarFile.class);

		// test
		ResourceDef def = new ResourceDef("path/to/file.txt", "checksum");
		def.setRelease(11);
		def.setJarFile(jarFile);

		// assert
		assertEquals("path/to/file.txt", def.getPath());
		assertEquals("checksum", def.getChecksum());
		assertEquals(11, def.getRelease());
		assertSame(jarFile, def.getJarFile());

	}

}