/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.toolbox;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.builder.xml.XsltUriResolver;
import org.apache.camel.component.xslt.XsltOutput;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XsltAggregationStrategy
implements AggregationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(XsltAggregationStrategy.class);
    private static final String DEFAULT_PROPERTY_NAME = "new-exchange";
    private volatile XsltBuilder xslt;
    private volatile URIResolver uriResolver;
    private String propertyName;
    private String xslFile;
    private String transformerFactoryClass;
    private XsltOutput output = XsltOutput.string;

    public XsltAggregationStrategy(String xslFileLocation) {
        this.xslFile = xslFileLocation;
    }

    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        if (newExchange == null) {
            return oldExchange;
        }
        if (oldExchange == null) {
            return newExchange;
        }
        try {
            if (this.xslt == null) {
                this.initialize(oldExchange.getContext());
            }
            oldExchange.setProperty(this.propertyName, newExchange.getIn().getBody(Document.class));
            this.xslt.process(oldExchange);
            return oldExchange;
        }
        catch (Throwable e) {
            oldExchange.setException(e);
            return oldExchange;
        }
    }

    public void setOutput(XsltOutput output) {
        this.output = output;
    }

    public void setXslt(XsltBuilder xslt) {
        this.xslt = xslt;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public void setTransformerFactoryClass(String transformerFactoryClass) {
        this.transformerFactoryClass = transformerFactoryClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    protected void initialize(CamelContext context) throws Exception {
        this.propertyName = ObjectHelper.isNotEmpty(this.propertyName) ? this.propertyName : DEFAULT_PROPERTY_NAME;
        this.xslt = context.getInjector().newInstance(XsltBuilder.class);
        if (this.transformerFactoryClass != null) {
            Class<?> factoryClass = context.getClassResolver().resolveMandatoryClass(this.transformerFactoryClass, XsltAggregationStrategy.class.getClassLoader());
            TransformerFactory factory = (TransformerFactory)context.getInjector().newInstance(factoryClass);
            this.xslt.getConverter().setTransformerFactory(factory);
        }
        if (this.uriResolver == null) {
            this.uriResolver = new XsltUriResolver(context.getClassResolver(), this.xslFile);
        }
        this.xslt.setUriResolver(this.uriResolver);
        this.xslt.setFailOnNullBody(true);
        this.xslt.transformerCacheSize(0);
        this.xslt.setAllowStAX(true);
        this.configureOutput(this.xslt, this.output.name());
        this.loadResource(this.xslFile);
    }

    protected void configureOutput(XsltBuilder xslt, String output) throws Exception {
        if (ObjectHelper.isEmpty(output)) {
            return;
        }
        if ("string".equalsIgnoreCase(output)) {
            xslt.outputString();
        } else if ("bytes".equalsIgnoreCase(output)) {
            xslt.outputBytes();
        } else if ("DOM".equalsIgnoreCase(output)) {
            xslt.outputDOM();
        } else if ("file".equalsIgnoreCase(output)) {
            xslt.outputFile();
        } else {
            throw new IllegalArgumentException("Unknown output type: " + output);
        }
    }

    protected void loadResource(String resourceUri) throws TransformerException, IOException {
        LOG.trace("{} loading schema resource: {}", (Object)this, (Object)resourceUri);
        Source source = this.xslt.getUriResolver().resolve(resourceUri, null);
        if (source == null) {
            throw new IOException("Cannot load schema resource " + resourceUri);
        }
        this.xslt.setTransformerSource(source);
    }

    public static XsltAggregationStrategy create(String xslFile) {
        return new XsltAggregationStrategy(xslFile);
    }

    public XsltAggregationStrategy withPropertyName(String propertyName) {
        this.setPropertyName(propertyName);
        return this;
    }

    public XsltAggregationStrategy withOutput(XsltOutput output) {
        this.setOutput(output);
        return this;
    }

    public XsltAggregationStrategy withUriResolver(URIResolver resolver) {
        this.setUriResolver(resolver);
        return this;
    }

    public XsltAggregationStrategy withTransformerFactoryClass(String clazz) {
        this.setTransformerFactoryClass(clazz);
        return this;
    }

    public XsltAggregationStrategy withSaxon() {
        this.setTransformerFactoryClass("net.sf.saxon.TransformerFactoryImpl");
        return this;
    }
}

