/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.browse;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.processor.loadbalancer.LoadBalancerConsumer;
import org.apache.camel.processor.loadbalancer.TopicLoadBalancer;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="browse", title="Browse", syntax="browse:name", label="core,monitoring")
public class BrowseEndpoint
extends DefaultEndpoint
implements BrowsableEndpoint {
    @UriPath(description="A name which can be any string to uniquely identify the endpoint")
    @Metadata(required="true")
    private String name;
    private List<Exchange> exchanges;
    private final LoadBalancer loadBalancer = new TopicLoadBalancer();

    public BrowseEndpoint() {
    }

    public BrowseEndpoint(String uri, Component component) {
        super(uri, component);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public List<Exchange> getExchanges() {
        if (this.exchanges == null) {
            this.exchanges = this.createExchangeList();
        }
        return this.exchanges;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultProducer(this){

            @Override
            public void process(Exchange exchange) throws Exception {
                BrowseEndpoint.this.onExchange(exchange);
            }
        };
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        LoadBalancerConsumer answer = new LoadBalancerConsumer(this, processor, this.loadBalancer);
        this.configureConsumer(answer);
        return answer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected List<Exchange> createExchangeList() {
        return new CopyOnWriteArrayList<Exchange>();
    }

    protected void onExchange(Exchange exchange) throws Exception {
        this.getExchanges().add(exchange);
        this.loadBalancer.process(exchange);
    }

    @Override
    protected void doStart() throws Exception {
        this.exchanges = this.createExchangeList();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.exchanges != null) {
            this.exchanges.clear();
            this.exchanges = null;
        }
        super.doStop();
    }
}

