/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.HashMap;
import java.util.Map;

public abstract class AliasedDiscoveryConfig<T extends AliasedDiscoveryConfig<T>> {
    private static final String USE_PUBLIC_IP_PROPERTY = "use-public-ip";
    private static final String ENABLED_PROPERTY = "enabled";
    private final String tag;
    private boolean enabled;
    private boolean usePublicIp;
    private final Map<String, String> properties = new HashMap<String, String>();

    protected AliasedDiscoveryConfig(String tag) {
        this.tag = tag;
    }

    public T setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (T)this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public T setProperty(String name, String value) {
        if (USE_PUBLIC_IP_PROPERTY.equals(name)) {
            this.usePublicIp = Boolean.parseBoolean(value);
        } else if (ENABLED_PROPERTY.equals(name)) {
            this.enabled = Boolean.parseBoolean(value);
        } else {
            this.properties.put(name, value);
        }
        return (T)this;
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public T setUsePublicIp(boolean usePublicIp) {
        this.usePublicIp = usePublicIp;
        return (T)this;
    }

    public boolean isUsePublicIp() {
        return this.usePublicIp;
    }

    String getTag() {
        return this.tag;
    }

    public String toString() {
        return "AliasedDiscoveryConfig{tag='" + this.tag + '\'' + ", enabled=" + this.enabled + ", usePublicIp=" + this.usePublicIp + ", properties=" + this.properties + '}';
    }
}

