# Piral Plugin Packages

Piral is developed as a monorepo.

## Available Pilet API Plugin Collections

- [piral-ext](./piral-ext/README.md) bundles some useful standard plugins for use in `piral`

## Available Opt-Out Pilet API Plugins

- [piral-dashboard](./piral-dashboard/README.md) offers the ability to show tiles registered by different pilets
- [piral-feeds](./piral-feeds/README.md) establishes an easy way to connect to a remote data source
- [piral-menu](./piral-menu/README.md) includes the menu item registration API
- [piral-modals](./piral-modals/README.md) features showing and registration of modal dialogs
- [piral-notifications](./piral-notifications/README.md) offers the ability to show notifications
- [piral-translate](./piral-translate/README.md) provides the translation API

## Available Opt-In Pilet API Plugins

- [piral-adal](./piral-adal/README.md) integrates MSAL for authentication with a fetch middleware
- [piral-auth](./piral-auth/README.md) provides the `getUser` API
- [piral-axios](./piral-axios/README.md) provides the `axios` API for making HTTP requests
- [piral-breadcrumbs](./piral-breadcrumbs/README.md) provides a breadcrumbs component
- [piral-configs](./piral-configs/README.md) provides rich configuration options with validation
- [piral-containers](./piral-containers/README.md) allows individual pilets to use their own global state
- [piral-fetch](./piral-fetch/README.md) provides the `fetch` API
- [piral-forms](./piral-forms/README.md) allows construction of reusable forms
- [piral-lazy](./piral-lazy/README.md) provides generic lazy loading for all components
- [piral-oauth2](./piral-oauth2/README.md) integrates generic OAuth 2 for authentication with a fetch middleware
- [piral-oidc](./piral-oidc/README.md) integrates OpenID Connect for authentication with a fetch middleware
- [piral-page-layouts](./piral-page-layouts/README.md) integrates different page layout styles
- [piral-redux](./piral-redux/README.md) provides bindings for using a distributed Redux-based state container
- [piral-search](./piral-search/README.md) provides enhanced search capability
- [piral-tracking](./piral-tracking/README.md) provides the tracking API
- [piral-update](./piral-update/README.md) provides an easy to use API for allowing live-updates to pilets
- [piral-urql](./piral-urql/README.md) provides the `query`, `mutate`, and `subscribe` API
