# Tutorials

The **Piral** framework offers the foundation for designing and realizing modular web applications. It provides a comprehensive set of functionality and extension points to realize a micro frontend solution tailored to your specific needs.

This chapter of the documentation contains tutorials, which are intended to support developers in getting familiar with the rich feature set of the Piral framework.

## Available Tutorials

The following tutorials are currently available:

1. [Introduction](./01-introduction.md) - an introduction to the development with Piral
2. [Getting Started](./02-getting-started.md) - a quick start for the first steps with Piral
3. [Publishing Pilets](./03-publishing-pilets.md) - a guide for using the public pilet feed service
4. [The Pilet API](./04-the-pilet-api.md) - a closer look at the Pilet API
5. [Customizing the API](./05-customizing-the-api.md) - how to extend and customize the Pilet API.
6. [Piral Layout](./06-piral-layout.md) - set up the layout of your Piral instance.
7. [Development Workflow](./07-development-workflow.md) - development of a micro frontend with Piral.
8. [The Piral CLI](./08-the-piral-cli.md) - details about working with our tooling.
9. [Pilet Best Practices](./09-pilet-best-practices.md) - recommendations for developing great pilets.
10. [Mocking the Backend](./10-mock-backend.md) - develop offline-first with Piral.
11. [Server-Side Rendering](./11-server-side-rendering.md) - improve startup performance with SSR.
12. [Sharing Between Pilets](./12-sharing-between-pilets.md) - sharing values, functions, or components.
13. [Sharing from Piral](./13-sharing-from-piral.md) - share information from the Piral instance.
14. [Converters](./14-converters.md) - how to make multiple frameworks play together.
15. [Shared Dependencies](./15-share-dependencies.md) - defined implicitly and explicitly.
16. [Actions and State](./16-actions-and-state.md) - custom declarations and extensions.
17. [Events](./17-events.md) - and how to use them in Piral.
18. [Authentication](./18-authentication.md) - and how to use authentication with Piral.
19. [Migration of SSR Applications](./19-migrate-ssr.md) - discusses options for migration of existing websites.
20. [Migration of Existing Applications](./20-migrate-app.md) - illustrates how existing applications can be migrated.
21. [Parcel vs Webpack](./21-parcel-vs-webpack.md) - goes into details of the available bundlers.
22. [Core and Base](./22-core-and-base.md) - discusses other framework packages and when they should be used.
23. [Monorepo](./23-monorepo.md) - introduces the concept and realization of a monorepo.
24. [Extension Patterns](./24-extension-patterns.md) - reveals a set of patterns for extension components.
25. [Sharing Multiple Versions](./25-multiple-versions.md) - discusses a set of strategies for sharing multiple versions of the same dependency.

Please don't hesitate to send us feedback regarding the tutorials and suggestions for additional topics.
