# Warning: 0171

An invalid pilet schema version was found.

## Description

For building a pilet you can select a schema version to use. The schema version affects
the interpretation of compatible feed services slightly and has an impact of the usage
of the pilet in the browser.

The selected schema version needs to be either "v0", "v1", "v2", or "mf".

- v0: will download and evaluate the pilet explicitly
- v1: will use a script tag for integration of the pilet
- v2: will use SystemJS for integration of the pilet (default)
- mf: will use Module Federation for integration of the pilet (only supported bundlers)

The v1 version has better support for older browsers, but requires a polyfill to work
correctly. This polyfill is part of the `piral-ie11polyfills-utils` package.
Alternatively, use the `currentScript-polyfill` package.

The v2 version uses a SystemJS format for the pilet. It has the broadest browser support
but requires the custom format as output. Most bundlers support SystemJS directly or
indirectly, making it a quite broad choice.

In bundlers that support Module Federation (e.g., Webpack 5) the "mf" format may be
the best choice. Keep in mind that "mf" is only supported by applications using
Piral 1.4.0 or higher.

## Example

Use the following command to switch explicitly to v0:

```sh
pilet build --schema v0
```

## Further Reading

 - [GitHub currentScript-polyfill](https://github.com/amiller-gh/currentScript-polyfill)
