# Warning: 0101

The Piral CLI detected a misalignment between the used version of the framework and the used version of the tooling.

## Description

The tooling and the framework of Piral should aligned at least with their most significant ("major") version. As such
using Piral in the frontend in version 0.10.5 should be aligned with a similar 0.10.x version of the Piral CLI for the
tooling.

Recommendation: Update to the same version of the Piral CLI.

```sh
npm i piral-cli@{piralVersion}
```

Alternatively, you can also change the used version of Piral.

## Example

As an example the following package.json may be given:

```json
{
  "name": "my-app-shell",
  "dependencies": {
    "piral": "^0.10.0"
  },
  "devDependencies": {
    "piral-cli": "^0.11.0"
  }
}
```

Since Piral itself is using the 0.10.x version the used Piral CLI should also be using a 0.10.x version.

To solve this just update the Piral CLI accordingly.

```sh
npm i piral-cli@^0.10.0
```

## Further Reading

 - [Semantic Versioning](https://semver.org)
