# Warning: 0100

The Piral CLI detected a misalignment between the used version of the tooling in the Piral instance and the currently
used version of the tooling.

## Description

The tooling of the pilet and the tooling used to produce the Piral instance should be aligned at least with their most
significant ("major") version. As such using the Piral CLI for building the emulator package in version 0.10.5 should be
aligned with a similar 0.10.x version of the Piral CLI for the pilet.

Recommendation: Update to the same version of the Piral CLI.

```sh
npm i piral-cli@{piralVersion}
```

Alternatively, you can also try to update the Piral instance.

## Example

As an example the following package.json may be given:

```json
{
  "name": "my-pilet",
  "dependencies": {},
  "devDependencies": {
    "my-app-shell": "^1.0.0"
    "piral-cli": "^0.11.0"
  },
  "piral": {
    "name": "my-app-shell",
    "tooling": "0.10.3"
  }
}
```

Since the used Piral instance is using the 0.10.3 version of the piral-cli the pilet should also use a 0.10.x version.

To solve this just update the Piral CLI accordingly.

```sh
npm i piral-cli@0.10.3
```

## Further Reading

 - [Semantic Versioning](https://semver.org)
