# Error: 0073

The entry point specified in the "app" field does not exist.

## Description

The entry point of a Piral instance is provided via the "app" field of the
package.json. The field is interpreted as a file path relative to the location
of the package.json. In case the resolved file path is invalid the bundler
cannot start building the Piral instance.

Make sure to only enter valid paths to resolve the app entry point correctly.

Check that a forward slash (`/`) has been used as path separator. Do not use
backslashes (`\`).

## Example

Let's assume we have a folder structure that looks like

```sh
package.json
+ src
  + index.html
```

The app field in the package.json has to be "src/index.html", not "index.html" or "/src/index.html".

Alternatively, you can also specify the path as "./src/index.html" (keep the dot in front). We
recommend also using the `/` as path separator on Windows to enable cross-platform usage of the
same repository.

## Further Reading

 - [File not found](https://stackoverflow.com/questions/17575492/file-not-found-in-node-js)
